/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ObjectStore;
import com.sap.db.util.PlatformUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;

@NotThreadSafe
class KeyStore {
    private ObjectStore _store;
    private boolean _isOpen = false;
    private String _filename;
    private boolean _allowUnencrypted;

    KeyStore() {
    }

    void open(String password) throws KSException, ObjectStore.StException, SQLException {
        this.open(password, true);
    }

    void open(String password, boolean create) throws KSException, ObjectStore.StException, SQLException {
        String filename = this._filename;
        if (password == null && !this._allowUnencrypted) {
            throw new KSException(ErrorCodes.PASSWORD_REQUIRED);
        }
        if (this._store == null) {
            this._store = new ObjectStore();
        }
        if (filename == null) {
            filename = Paths.get(PlatformUtils.getHdbkeystoreUserProfilePath(create), "hdbkeystore.dat").toString();
        }
        try {
            this._store.open(filename, password);
        }
        catch (ObjectStore.StException e) {
            if (e.getCode() == ObjectStore.ErrorCodes.FILE_OPEN_FAILED) {
                throw new KSException(ErrorCodes.COULD_NOT_OPEN_STORE);
            }
            throw e;
        }
        this._isOpen = true;
    }

    void close() {
        if (this._isOpen && this._store != null) {
            this._store.close();
        }
        this._isOpen = false;
    }

    boolean isOpen() {
        return this._isOpen;
    }

    String getKeyStoreFileName() throws SQLException {
        return Paths.get(PlatformUtils.getHdbkeystoreUserProfilePath(false), "hdbkeystore.dat").toString();
    }

    void storeKey(Key key) throws KSException, ObjectStore.StException {
        if (key == null) {
            throw new KSException(ErrorCodes.INVALID_PARAMETER);
        }
        if (!this._isOpen) {
            throw new KSException(ErrorCodes.STORE_NOT_OPEN);
        }
        String idStr = key.getUUID().toString();
        if (this._store.objectExists(idStr)) {
            throw new KSException(ErrorCodes.KEY_ALREADY_EXISTS);
        }
        this._store.addObject(idStr, key.getEncoding(), (short)key.getType().ordinal(), 0);
    }

    void storeKey(UUID id, String name, String databaseName, KeyType type, KeyAlgorithm algorithm, byte[] value, byte[] publicValue) throws KSException, ObjectStore.StException {
        if (id == null || value == null || value.length == 0) {
            throw new KSException(ErrorCodes.INVALID_PARAMETER);
        }
        if (!this._isOpen) {
            throw new KSException(ErrorCodes.STORE_NOT_OPEN);
        }
        String idStr = id.toString();
        if (this._store.objectExists(idStr)) {
            throw new KSException(ErrorCodes.KEY_ALREADY_EXISTS);
        }
        Key key = new Key(id);
        key.setName(name);
        key.setDatabaseName(databaseName);
        key.setType(type);
        key.setAlgorithm(algorithm);
        key.setPrivateValue(value);
        key.setPublicValue(publicValue);
        this._store.addObject(idStr, key.getEncoding(), (short)key.getType().ordinal(), 0);
    }

    void removeKey(UUID id) throws KSException, ObjectStore.StException {
        if (id == null) {
            throw new KSException(ErrorCodes.INVALID_PARAMETER);
        }
        if (!this._isOpen) {
            throw new KSException(ErrorCodes.STORE_NOT_OPEN);
        }
        try {
            this._store.removeObject(id.toString());
        }
        catch (ObjectStore.StException e) {
            if (e.getCode() == ObjectStore.ErrorCodes.OBJECT_NOT_FOUND) {
                throw new KSException(ErrorCodes.KEY_NOT_FOUND);
            }
            throw e;
        }
    }

    boolean keyExists(UUID id) throws KSException, ObjectStore.StException {
        if (id == null) {
            throw new KSException(ErrorCodes.INVALID_PARAMETER);
        }
        if (!this._isOpen) {
            throw new KSException(ErrorCodes.STORE_NOT_OPEN);
        }
        return this._store.objectExists(id.toString());
    }

    private boolean _checkKey(int h, String name, String databaseName) {
        if (name == null && databaseName == null) {
            return true;
        }
        try {
            byte[] obj = this._store.getObject(h);
            KeyReader reader = new KeyReader(obj);
            reader.load();
            if (name != null && !reader.checkAttributeAgainstPattern("Name", name)) {
                return false;
            }
            return databaseName == null || reader.checkAttributeAgainstPattern("DatabaseName", databaseName);
        }
        catch (Exception e) {
            return false;
        }
    }

    UUID findKey(String name, String databaseName) throws KSException, ObjectStore.StException {
        if (!this._isOpen) {
            throw new KSException(ErrorCodes.STORE_NOT_OPEN);
        }
        int h = -1;
        do {
            if ((h = this._store.findNextObject(h, 0, 0)) != -1) continue;
            return null;
        } while (!this._checkKey(h, name, databaseName));
        String uuidStr = this._store.getObjectName(h);
        return UUID.fromString(uuidStr);
    }

    UUID[] findKeys(String name, String databaseName) throws KSException, ObjectStore.StException {
        if (!this._isOpen) {
            throw new KSException(ErrorCodes.STORE_NOT_OPEN);
        }
        ArrayList<UUID> ids = new ArrayList<UUID>();
        int h = -1;
        while ((h = this._store.findNextObject(h, 0, 0)) != -1) {
            if (!this._checkKey(h, name, databaseName)) continue;
            UUID id = UUID.fromString(this._store.getObjectName(h));
            ids.add(id);
        }
        return ids.toArray(new UUID[0]);
    }

    Key getKey(UUID id) throws KSException, ObjectStore.StException {
        if (id == null) {
            throw new KSException(ErrorCodes.INVALID_PARAMETER);
        }
        if (!this._isOpen) {
            throw new KSException(ErrorCodes.STORE_NOT_OPEN);
        }
        try {
            return new Key(id, this._store.getObject(id.toString()));
        }
        catch (ObjectStore.StException e) {
            if (e.getCode() == ObjectStore.ErrorCodes.OBJECT_NOT_FOUND) {
                throw new KSException(ErrorCodes.KEY_NOT_FOUND);
            }
            throw e;
        }
    }

    void setObjectStore(ObjectStore objectStore) {
        this._store = objectStore;
    }

    void allowUnencrypted(boolean allow) {
        this._allowUnencrypted = allow;
    }

    void setFilename(String filename) {
        this._filename = filename;
    }

    static class KSException
    extends Exception {
        private final ErrorCodes _code;

        KSException(ErrorCodes code) {
            this._code = code;
        }

        ErrorCodes getCode() {
            return this._code;
        }
    }

    static enum ErrorCodes {
        INVALID_PARAMETER,
        STORE_NOT_OPEN,
        KEY_NOT_FOUND,
        KEY_ALREADY_EXISTS,
        MALFORMED_KEY,
        ATTRIBUTE_NOT_FOUND,
        COULD_NOT_OPEN_STORE,
        MISSING_KEY_ATTRIBUTE,
        PASSWORD_REQUIRED;

    }

    static class Key {
        private UUID _uuid;
        private String _name;
        private String _databaseName;
        private KeyType _type = KeyType.UNSPECIFIED;
        private KeyAlgorithm _algorithm = KeyAlgorithm.UNSPECIFIED;
        private byte[] _privateValue;
        private byte[] _publicValue;

        Key(UUID uuid) {
            this._uuid = uuid;
        }

        Key(UUID uuid, String name, String databaseName, KeyType type, KeyAlgorithm algorithm, byte[] privateValue, byte[] publicValue) throws KSException {
            this._uuid = uuid;
            this._name = name;
            this._databaseName = databaseName;
            this._type = type;
            this._algorithm = algorithm;
            this._privateValue = privateValue;
            this._publicValue = publicValue;
            this.validate();
        }

        protected Key(UUID uuid, byte[] encodedBytes) throws KSException {
            this._uuid = uuid;
            KeyReader reader = new KeyReader(encodedBytes);
            reader.load();
            this._name = reader.getAttributeString("Name");
            this._databaseName = reader.getAttributeString("DatabaseName");
            this._type = KeyType.fromString(reader.getAttributeString("Type"));
            this._algorithm = KeyAlgorithm.fromString(reader.getAttributeString("Algorithm"));
            this._privateValue = reader.getAttributeBytes("Value");
            this._publicValue = reader.getAttributeBytes("PublicValue");
            this.validate();
        }

        protected byte[] getEncoding() throws KSException {
            this.validate();
            KeyWriter writer = new KeyWriter();
            if (this._name != null) {
                writer.writeAttribute("Name", this._name);
            }
            if (this._databaseName != null) {
                writer.writeAttribute("DatabaseName", this._databaseName);
            }
            writer.writeAttribute("Type", this._type.toString());
            writer.writeAttribute("Algorithm", this._algorithm.toString());
            writer.writeAttribute("Value", this._privateValue);
            if (this._publicValue != null) {
                writer.writeAttribute("PublicValue", this._publicValue);
            }
            return writer.finish();
        }

        protected void validate() throws KSException {
            if (this._uuid == null || this._privateValue == null || this._type == KeyType.UNSPECIFIED || this._algorithm == KeyAlgorithm.UNSPECIFIED) {
                throw new KSException(ErrorCodes.MISSING_KEY_ATTRIBUTE);
            }
        }

        UUID getUUID() {
            return this._uuid;
        }

        String getName() {
            return this._name;
        }

        String getDatabaseName() {
            return this._databaseName;
        }

        KeyType getType() {
            return this._type;
        }

        KeyAlgorithm getAlgorithm() {
            return this._algorithm;
        }

        byte[] getPrivateValue() {
            return this._privateValue;
        }

        byte[] getPublicValue() {
            return this._publicValue;
        }

        void setUUID(UUID uuid) {
            this._uuid = uuid;
        }

        void setName(String name) {
            this._name = name;
        }

        void setDatabaseName(String databaseName) {
            this._databaseName = databaseName;
        }

        void setType(KeyType type) {
            this._type = type;
        }

        void setAlgorithm(KeyAlgorithm algorithm) {
            this._algorithm = algorithm;
        }

        void setPrivateValue(byte[] value) {
            this._privateValue = value;
        }

        void setPublicValue(byte[] value) {
            this._publicValue = value;
        }
    }

    static enum KeyType {
        UNSPECIFIED,
        KEYPAIR;


        static KeyType fromString(String typeString) {
            if (typeString != null && typeString.equals("KeyPair")) {
                return KEYPAIR;
            }
            return UNSPECIFIED;
        }

        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "Unspecified";
                }
                case 1: {
                    return "KeyPair";
                }
            }
            return "Unknown";
        }
    }

    static enum KeyAlgorithm {
        UNSPECIFIED,
        RSA2048;


        static KeyAlgorithm fromString(String algorithmString) {
            if (algorithmString != null && algorithmString.equals("RSA-OAEP-2048")) {
                return RSA2048;
            }
            return UNSPECIFIED;
        }

        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "Unspecified";
                }
                case 1: {
                    return "RSA-OAEP-2048";
                }
            }
            return "Unknown";
        }
    }

    private static class KeyReader {
        byte[] _buffer;
        Attribute[] _attrs = new Attribute[64];
        int _attrCount = 0;

        KeyReader(byte[] buffer) {
            this._buffer = buffer;
        }

        void load() throws KSException {
            int count;
            block3: {
                int offset = 0;
                count = 0;
                do {
                    if (offset + 4 > this._buffer.length) {
                        throw new KSException(ErrorCodes.MALFORMED_KEY);
                    }
                    int size = this._readInt32(this._buffer, offset);
                    offset += 4;
                    if (size == 0) break block3;
                    this._attrs[count] = new Attribute();
                    this._attrs[count].nameOffset = offset;
                    this._attrs[count].nameSize = size;
                    if ((offset += size) + 4 > this._buffer.length) {
                        throw new KSException(ErrorCodes.MALFORMED_KEY);
                    }
                    size = this._readInt32(this._buffer, offset);
                    this._attrs[count].valueOffset = offset += 4;
                    this._attrs[count].valueSize = size;
                    offset += size;
                } while (++count != 64);
                throw new KSException(ErrorCodes.MALFORMED_KEY);
            }
            this._attrCount = count;
        }

        byte[] getAttributeBytes(String name) {
            int index = this._findAttribute(name);
            if (index == -1) {
                return null;
            }
            byte[] ret = new byte[this._attrs[index].valueSize];
            System.arraycopy(this._buffer, this._attrs[index].valueOffset, ret, 0, this._attrs[index].valueSize);
            return ret;
        }

        String getAttributeString(String name) {
            int index = this._findAttribute(name);
            if (index == -1) {
                return null;
            }
            return new String(this._buffer, this._attrs[index].valueOffset, this._attrs[index].valueSize);
        }

        boolean checkAttributeAgainstPattern(String name, String pattern) {
            String s = this.getAttributeString(name);
            if (s == null) {
                return false;
            }
            String regex = ("\\Q" + pattern + "\\E").replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q");
            return s.matches(regex);
        }

        private int _readInt32(byte[] buf, int offset) {
            return buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | (buf[offset + 3] & 0xFF) << 24;
        }

        private int _findAttribute(String name) {
            for (int i = 0; i < this._attrCount; ++i) {
                if (!name.equals(new String(this._buffer, this._attrs[i].nameOffset, this._attrs[i].nameSize))) continue;
                return i;
            }
            return -1;
        }

        private static class Attribute {
            int nameOffset;
            int nameSize;
            int valueOffset;
            int valueSize;

            private Attribute() {
            }
        }
    }

    private static class KeyWriter {
        ByteArrayOutputStream _stream = new ByteArrayOutputStream();

        private KeyWriter() {
        }

        void writeAttribute(String name, String value) throws KSException {
            this.writeAttribute(name, value.getBytes());
        }

        void writeAttribute(String name, byte[] value) throws KSException {
            try {
                if (name == null) {
                    this._writeInt32(0);
                } else {
                    this._writeInt32(name.length());
                    if (!name.isEmpty()) {
                        this._stream.write(name.getBytes());
                    }
                }
                this._writeInt32(value.length);
                if (value.length > 0) {
                    this._stream.write(value);
                }
            }
            catch (IOException e) {
                throw new KSException(ErrorCodes.MALFORMED_KEY);
            }
        }

        byte[] finish() {
            this._writeInt32(0);
            return this._stream.toByteArray();
        }

        private void _writeInt32(int x) {
            this._stream.write((byte)x);
            this._stream.write((byte)(x >> 8));
            this._stream.write((byte)(x >> 16));
            this._stream.write((byte)(x >> 24));
        }
    }
}

