/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

@Immutable
public final class ReferenceUtils {
    private ReferenceUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    private static class StrongReference<T>
    extends WeakReference<T> {
        private final T _referent;

        public StrongReference(T referent) {
            super(null);
            this._referent = referent;
        }

        @Override
        public T get() {
            return this._referent;
        }
    }

    public static enum RefType {
        Strong{

            @Override
            public <T> Reference<T> newReference(T referent) {
                return new StrongReference<T>(referent);
            }
        }
        ,
        Soft{

            @Override
            public <T> Reference<T> newReference(T referent) {
                return new SoftReference<T>(referent);
            }
        }
        ,
        Weak{

            @Override
            public <T> Reference<T> newReference(T referent) {
                return new WeakReference<T>(referent);
            }
        };

        private static final RefType[] VALUES;
        private static final Map<String, RefType> CONN_PROP_VALUE_MAP;

        public static RefType decode(String connectionPropertyValue) {
            RefType value = CONN_PROP_VALUE_MAP.get(connectionPropertyValue);
            return value != null ? value : Strong;
        }

        public abstract <T> Reference<T> newReference(T var1);

        static {
            VALUES = RefType.values();
            CONN_PROP_VALUE_MAP = new TreeMap<String, RefType>(String.CASE_INSENSITIVE_ORDER);
            for (RefType value : VALUES) {
                CONN_PROP_VALUE_MAP.put(value.name().toUpperCase(Locale.ROOT), value);
            }
        }
    }
}

