/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.Cesu8Utils;
import java.math.BigDecimal;

@NotThreadSafe
public abstract class HPart {
    public static final int MAX_ARGUMENT_COUNT = Integer.MAX_VALUE;
    protected final int _offset;
    protected final int _length;
    protected final boolean _isReadOnly;
    protected final boolean _asciiStringOptimization;
    protected byte[] _packet;

    public HPart(byte[] packet, int offset, int length, boolean isReadOnly, boolean asciiStringOptimization) {
        this._packet = packet;
        this._offset = offset;
        this._length = length;
        this._isReadOnly = isReadOnly;
        this._asciiStringOptimization = asciiStringOptimization;
    }

    public byte[] getRawPacketArray() {
        return this._packet;
    }

    public int getLength() {
        return this._length;
    }

    public boolean getBoolean(int off) {
        return ByteUtils.getBoolean(this._packet, this._offset + off);
    }

    public byte[] putBoolean(boolean val, int off) {
        this._checkModifiable();
        return ByteUtils.putBoolean(val, this._packet, this._offset + off);
    }

    public int getUByte(int off) {
        return ByteUtils.getUByte(this._packet, this._offset + off);
    }

    public byte getByte(int off) {
        return ByteUtils.getByte(this._packet, this._offset + off);
    }

    public byte[] putByte(int val, int off) {
        this._checkModifiable();
        return ByteUtils.putByte(val, this._packet, this._offset + off);
    }

    public short getShort(int off) {
        return ByteUtils.getShort(this._packet, this._offset + off);
    }

    public byte[] putShort(int val, int off) {
        this._checkModifiable();
        return ByteUtils.putShort(val, this._packet, this._offset + off);
    }

    public int getInt(int off) {
        return ByteUtils.getInt(this._packet, this._offset + off);
    }

    public byte[] putInt(int val, int off) {
        this._checkModifiable();
        return ByteUtils.putInt(val, this._packet, this._offset + off);
    }

    public long getLong(int off) {
        return ByteUtils.getLong(this._packet, this._offset + off);
    }

    public byte[] putLong(long val, int off) {
        this._checkModifiable();
        return ByteUtils.putLong(val, this._packet, this._offset + off);
    }

    public float getFloat(int off) {
        return ByteUtils.getFloat(this._packet, this._offset + off);
    }

    public byte[] putFloat(float val, int off) {
        this._checkModifiable();
        return ByteUtils.putFloat(val, this._packet, this._offset + off);
    }

    public double getDouble(int off) {
        return ByteUtils.getDouble(this._packet, this._offset + off);
    }

    public byte[] putDouble(double val, int off) {
        this._checkModifiable();
        return ByteUtils.putDouble(val, this._packet, this._offset + off);
    }

    public BigDecimal getDecimalAsBigDecimal(int off, int fraction) {
        return ByteUtils.getDecimalAsBigDecimal(this._packet, this._offset + off, fraction);
    }

    public byte[] putBigDecimalAsDecimal(BigDecimal val, int off) {
        this._checkModifiable();
        return ByteUtils.putBigDecimalAsDecimal(val, this._packet, this._offset + off);
    }

    public BigDecimal getFixedDecimalAsBigDecimal(int off, int fraction, DataType dataType) {
        return ByteUtils.getFixedDecimalAsBigDecimal(this._packet, this._offset + off, fraction, dataType.getFixedByteCount());
    }

    public byte[] putBigDecimalAsFixedDecimal(BigDecimal val, int off, int fraction, DataType dataType) {
        this._checkModifiable();
        return ByteUtils.putBigDecimalAsFixedDecimal(val, this._packet, this._offset + off, fraction, dataType.getFixedByteCount());
    }

    public String getString(int off, int len, boolean lenientCESU8) {
        return Cesu8Utils.getString(this._packet, this._offset + off, len, this._asciiStringOptimization, lenientCESU8);
    }

    public int putString(String val, int off) {
        this._checkModifiable();
        return Cesu8Utils.putBytes(val, this._packet, this._offset + off);
    }

    public byte[] getBytes(int off, int len) {
        return ByteUtils.getBytes(this._packet, this._offset + off, len);
    }

    public byte[] getBytes(int off, int len, byte[] buffer) {
        return ByteUtils.getBytes(this._packet, this._offset + off, len, buffer);
    }

    public byte[] putBytes(byte[] val, int off) {
        this._checkModifiable();
        return ByteUtils.putBytes(val, this._packet, this._offset + off);
    }

    public byte[] putBytes(byte[] val, int srcOff, int srcLen, int off) {
        this._checkModifiable();
        return ByteUtils.putBytes(val, srcOff, srcLen, this._packet, this._offset + off);
    }

    protected void _checkModifiable() {
        if (this._isReadOnly) {
            throw new AssertionError((Object)"Part is read-only");
        }
    }
}

