/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.HanaClientBlob;
import com.sap.db.jdbc.converters.AbstractPutval;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import java.io.InputStream;
import java.sql.SQLException;

@NotThreadSafe
class HanaClientPutvalBlob
extends AbstractPutval {
    private final HanaClientBlob _blob;
    private InputStream _stream;
    private boolean _isEOF;

    protected HanaClientPutvalBlob(HanaClientBlob blob, int inputFieldPos) {
        super(inputFieldPos);
        this._blob = blob;
    }

    @Override
    public DataType getDataType() {
        return DataType.BLOB;
    }

    @Override
    public AbstractPutval cloneForBatch() {
        return new HanaClientPutvalBlob(this._blob, this._inputFieldPos);
    }

    @Override
    public void transferData(boolean isExecuteRequest, HDataPart dataPart) throws SQLException {
        boolean isStreamExhaused;
        if (this._stream == null) {
            this._stream = this._blob.getStreamForTransfer();
        }
        if (isStreamExhaused = dataPart.fillWithStream(isExecuteRequest, this._stream, this._descriptorOffset)) {
            this.markEOF();
        }
    }

    @Override
    public boolean isEOF() {
        return this._isEOF;
    }

    @Override
    public void markEOF() {
        this._isEOF = true;
    }

    public String toString() {
        return super.toString() + ":" + this._stream;
    }
}

