/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.SiteType;
import java.util.Map;

@Immutable
public final class SiteTypeVolumeID
implements Comparable<SiteTypeVolumeID> {
    private final SiteType _siteType;
    private final int _volumeID;
    private final boolean _hadUnknownSiteID;

    public static SiteTypeVolumeID newInstance(int siteVolumeID, Map<Byte, SiteType> siteIDToSiteTypeMap) {
        byte siteID = (byte)(siteVolumeID >> 24);
        int volumeID = siteVolumeID & 0xFFFFFF;
        SiteType siteType = siteIDToSiteTypeMap.get(siteID);
        boolean hadUnknownSiteID = false;
        if (siteType == null) {
            siteType = SiteType.NONE;
            if (!siteIDToSiteTypeMap.isEmpty()) {
                hadUnknownSiteID = true;
            }
        }
        return new SiteTypeVolumeID(siteType, volumeID, hadUnknownSiteID);
    }

    public SiteTypeVolumeID(int volumeID) {
        this(SiteType.NONE, volumeID, false);
    }

    public SiteTypeVolumeID(SiteType siteType, int volumeID) {
        this(siteType, volumeID, false);
    }

    private SiteTypeVolumeID(SiteType siteType, int volumeID, boolean hadUnknownSiteID) {
        this._siteType = siteType;
        this._volumeID = volumeID & 0xFFFFFF;
        this._hadUnknownSiteID = hadUnknownSiteID;
    }

    @Override
    public int compareTo(SiteTypeVolumeID other) {
        int siteTypeDiff = this._siteType.compareTo(other._siteType);
        if (siteTypeDiff != 0) {
            return siteTypeDiff;
        }
        int volumeIDDiff = this._volumeID - other._volumeID;
        if (volumeIDDiff != 0) {
            return volumeIDDiff;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SiteTypeVolumeID)) {
            return false;
        }
        SiteTypeVolumeID other = (SiteTypeVolumeID)object;
        return this._siteType.equals(other._siteType) && this._volumeID == other._volumeID;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._siteType.hashCode();
        result = 31 * result + this._volumeID;
        return result;
    }

    public String toString() {
        return this._siteType + ":" + this._volumeID;
    }

    public SiteType getSiteType() {
        return this._siteType;
    }

    public boolean isNoneSite() {
        return this._siteType == SiteType.NONE;
    }

    public boolean isNoneOrPrimary() {
        return this._siteType == SiteType.NONE || this._siteType == SiteType.PRIMARY;
    }

    public boolean isPrimarySite() {
        return this._siteType == SiteType.PRIMARY;
    }

    public boolean isSecondarySite() {
        return this._siteType == SiteType.SECONDARY;
    }

    public int getVolumeID() {
        return this._volumeID;
    }

    public boolean isValid() {
        return this._volumeID >= 0;
    }

    public boolean isSubpartition() {
        return this.getSiteType() == SiteType.NONE && this.getVolumeID() == 0;
    }

    public boolean hadUnknownSiteID() {
        return this._hadUnknownSiteID;
    }
}

