/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.util;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.regnosys.rosetta.RosettaRuntimeModule;
import com.regnosys.rosetta.RosettaStandaloneSetup;
import com.regnosys.rosetta.config.file.RosettaConfigurationFileProvider;
import com.regnosys.rosetta.tests.RosettaTestInjectorProvider;
import java.net.URL;
import org.eclipse.xtext.testing.GlobalRegistries;
import org.eclipse.xtext.testing.IInjectorProvider;
import org.eclipse.xtext.testing.IRegistryConfigurator;

public class RosettaCustomConfigInjectorProvider
implements IInjectorProvider,
IRegistryConfigurator {
    protected GlobalRegistries.GlobalStateMemento stateBeforeInjectorCreation;
    protected GlobalRegistries.GlobalStateMemento stateAfterInjectorCreation;
    protected Injector injector;

    public Injector getInjector() {
        if (this.injector == null) {
            this.injector = this.internalCreateInjector();
            this.stateAfterInjectorCreation = GlobalRegistries.makeCopyOfGlobalState();
        }
        return this.injector;
    }

    protected Injector internalCreateInjector() {
        return new RosettaStandaloneSetup(){

            public Injector createInjector() {
                return Guice.createInjector((Module[])new Module[]{RosettaCustomConfigInjectorProvider.this.createRuntimeModule()});
            }
        }.createInjectorAndDoEMFRegistration();
    }

    protected RosettaRuntimeModule createRuntimeModule() {
        return new RosettaRuntimeModule(){

            public ClassLoader bindClassLoaderToInstance() {
                return RosettaTestInjectorProvider.class.getClassLoader();
            }

            public Class<? extends RosettaConfigurationFileProvider> bindRosettaConfigurationFileProvider() {
                return CustomConfigFileProvider.class;
            }
        };
    }

    public void restoreRegistry() {
        this.stateBeforeInjectorCreation.restoreGlobalState();
        this.stateBeforeInjectorCreation = null;
    }

    public void setupRegistry() {
        this.stateBeforeInjectorCreation = GlobalRegistries.makeCopyOfGlobalState();
        if (this.injector == null) {
            this.getInjector();
        }
        this.stateAfterInjectorCreation.restoreGlobalState();
    }

    static {
        GlobalRegistries.initializeDefaults();
    }

    private static class CustomConfigFileProvider
    extends RosettaConfigurationFileProvider {
        private CustomConfigFileProvider() {
        }

        public URL get() {
            return Thread.currentThread().getContextClassLoader().getResource("rosetta-custom-config.yml");
        }
    }
}

