/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.util;

import com.google.common.base.Objects;
import com.regnosys.rosetta.builtin.RosettaBuiltinsService;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.rosetta.RosettaModel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.testing.util.ParseHelper;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ModelHelper {
    @Inject
    @Extension
    private ParseHelper<RosettaModel> _parseHelper;
    @Inject
    @Extension
    private ValidationTestHelper _validationTestHelper;
    @Inject
    private RosettaBuiltinsService builtins;
    public static final String commonTestTypes = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _versionInfo = ModelHelper.getVersionInfo();
            _builder.append((Object)_versionInfo);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("type ReportableEvent:");
            _builder.newLine();
            _builder.newLine();
            _builder.append("metaType scheme string");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("body Authority ESMA");
            _builder.newLine();
            _builder.append("body Authority CFTC");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("corpus Regulation MiFIR");
            _builder.newLine();
            _builder.append("corpus Regulation EMIR");
            _builder.newLine();
            _builder.newLine();
            _builder.append("corpus CommissionDelegatedRegulation RTS_22");
            _builder.newLine();
            _builder.newLine();
            _builder.append("segment article");
            _builder.newLine();
            _builder.append("segment whereas");
            _builder.newLine();
            _builder.append("segment annex");
            _builder.newLine();
            _builder.append("segment section");
            _builder.newLine();
            _builder.append("segment field");
            _builder.newLine();
            _builder.newLine();
            _builder.append("stereotype entityReferenceData");
            _builder.newLine();
            _builder.append("stereotype productReferenceData");
            _builder.newLine();
            _builder.append("stereotype commondReferenceData");
            _builder.newLine();
            _builder.append("stereotype preExecutionActivity");
            _builder.newLine();
            _builder.append("stereotype executionActivity");
            _builder.newLine();
            _builder.append("stereotype postExecutionActivity");
            _builder.newLine();
            _builder.append("stereotype contractualProduct");
            _builder.newLine();
            _builder.append("stereotype regulatoryEligibility");
            _builder.newLine();
            _builder.append("stereotype regulatoryReporting");
            _builder.newLine();
            _builder.newLine();
            _builder.append("synonym source FIX");
            _builder.newLine();
            _builder.append("synonym source FpML");
            _builder.newLine();
            _builder.append("synonym source DTCC");
            _builder.newLine();
            _builder.append("synonym source ISO");
            _builder.newLine();
            _builder.append("synonym source ISO_20022");
            _builder.newLine();
            _builder.append("synonym source Bank_A");
            _builder.newLine();
            _builder.append("synonym source Venue_B");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();
    private final RosettaJavaPackages.RootPackage rootpack = new RosettaJavaPackages.RootPackage("com.rosetta.test.model");

    private static CharSequence getVersionInfo() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("namespace \"com.rosetta.test.model\"");
        _builder.newLine();
        _builder.append("version \"test\"");
        _builder.newLine();
        return _builder;
    }

    public final RosettaJavaPackages.RootPackage rootPackage() {
        return this.rootpack;
    }

    public RosettaModel parseRosetta(CharSequence model) {
        try {
            boolean _notEquals;
            Object m = model;
            CharSequence _subSequence = model.subSequence(0, 9);
            boolean bl = _notEquals = !Objects.equal((Object)_subSequence, (Object)"namespace");
            if (_notEquals) {
                CharSequence _versionInfo = ModelHelper.getVersionInfo();
                String _plus = _versionInfo + "\n";
                String _plus_1 = _plus + (CharSequence)m;
                m = _plus_1;
            }
            ResourceSet resourceSet = this.testResourceSet();
            RosettaModel parsed = (RosettaModel)this._parseHelper.parse((CharSequence)m, resourceSet);
            EcoreUtil2.resolveAll((EObject)parsed);
            return parsed;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ArrayList<RosettaModel> parseRosetta(CharSequence ... models) {
        ResourceSet resourceSet = this.testResourceSet();
        Functions.Function1 _function = it -> {
            boolean _notEquals;
            Object _xifexpression = null;
            CharSequence _subSequence = it.subSequence(0, 9);
            boolean bl = _notEquals = !Objects.equal((Object)_subSequence, (Object)"namespace");
            if (_notEquals) {
                CharSequence _versionInfo = ModelHelper.getVersionInfo();
                String _plus = _versionInfo + "\n";
                _xifexpression = _plus + it;
            } else {
                _xifexpression = it;
            }
            return _xifexpression;
        };
        Functions.Function1 _function_1 = it -> {
            try {
                return (RosettaModel)this._parseHelper.parse(it, resourceSet);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        List _map = ListExtensions.map((List)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)models)), (Functions.Function1)_function), (Functions.Function1)_function_1);
        return new ArrayList<RosettaModel>(_map);
    }

    public RosettaModel parseRosettaWithNoErrors(CharSequence model) {
        RosettaModel parsed = this.parseRosetta(model);
        this._validationTestHelper.assertNoErrors((EObject)parsed);
        return parsed;
    }

    public ArrayList<RosettaModel> parseRosettaWithNoErrors(CharSequence ... models) {
        ArrayList<RosettaModel> parsed = this.parseRosetta(models);
        Consumer<RosettaModel> _function = it -> this._validationTestHelper.assertNoErrors((EObject)it);
        parsed.forEach(_function);
        return parsed;
    }

    public RosettaModel parseRosettaWithNoIssues(CharSequence model) {
        RosettaModel parsed = this.parseRosetta(model);
        this._validationTestHelper.assertNoIssues((EObject)parsed);
        return parsed;
    }

    public ArrayList<RosettaModel> parseRosettaWithNoIssues(CharSequence ... models) {
        ArrayList<RosettaModel> parsed = this.parseRosetta(models);
        Consumer<RosettaModel> _function = it -> this._validationTestHelper.assertNoIssues((EObject)it);
        parsed.forEach(_function);
        return parsed;
    }

    public RosettaModel combineAndParseRosetta(CharSequence ... models) {
        try {
            Object m = ModelHelper.getVersionInfo().toString();
            for (CharSequence model : models) {
                String _m = m;
                m = _m + "\n" + model;
            }
            ResourceSet resourceSet = this.testResourceSet();
            RosettaModel parsed = (RosettaModel)this._parseHelper.parse((CharSequence)m, resourceSet);
            this._validationTestHelper.assertNoErrors((EObject)parsed);
            return parsed;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ResourceSet testResourceSet() {
        try {
            ResourceSet resourceSet = ((RosettaModel)this._parseHelper.parse((CharSequence)commonTestTypes)).eResource().getResourceSet();
            resourceSet.getResource(this.builtins.basicTypesURI, true);
            resourceSet.getResource(this.builtins.annotationsURI, true);
            return resourceSet;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

