/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.regnosys.rosetta.RosettaRuntimeModule;
import com.regnosys.rosetta.RosettaStandaloneSetup;
import org.eclipse.xtext.testing.GlobalRegistries;
import org.eclipse.xtext.testing.IInjectorProvider;
import org.eclipse.xtext.testing.IRegistryConfigurator;

public class RosettaInjectorProvider
implements IInjectorProvider,
IRegistryConfigurator {
    protected GlobalRegistries.GlobalStateMemento stateBeforeInjectorCreation;
    protected GlobalRegistries.GlobalStateMemento stateAfterInjectorCreation;
    protected Injector injector;

    public Injector getInjector() {
        if (this.injector == null) {
            this.injector = this.internalCreateInjector();
            this.stateAfterInjectorCreation = GlobalRegistries.makeCopyOfGlobalState();
        }
        return this.injector;
    }

    protected Injector internalCreateInjector() {
        return new RosettaStandaloneSetup(){

            public Injector createInjector() {
                return Guice.createInjector((Module[])new Module[]{RosettaInjectorProvider.this.createRuntimeModule()});
            }
        }.createInjectorAndDoEMFRegistration();
    }

    protected RosettaRuntimeModule createRuntimeModule() {
        return new RosettaRuntimeModule(){

            public ClassLoader bindClassLoaderToInstance() {
                return RosettaInjectorProvider.class.getClassLoader();
            }
        };
    }

    public void restoreRegistry() {
        this.stateBeforeInjectorCreation.restoreGlobalState();
        this.stateBeforeInjectorCreation = null;
    }

    public void setupRegistry() {
        this.stateBeforeInjectorCreation = GlobalRegistries.makeCopyOfGlobalState();
        if (this.injector == null) {
            this.getInjector();
        }
        this.stateAfterInjectorCreation.restoreGlobalState();
    }

    static {
        GlobalRegistries.initializeDefaults();
    }
}

