/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util.types;

import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeArgument;
import com.rosetta.util.types.JavaTypeDeclaration;
import com.rosetta.util.types.JavaTypeVariable;
import com.rosetta.util.types.JavaTypeVisitor;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class JavaClass<T>
implements JavaReferenceType,
JavaTypeDeclaration<T> {
    public static final JavaClass<Object> OBJECT = new JavaClassImpl<Object>(Object.class);
    public static final JavaClass<Cloneable> CLONEABLE = new JavaClassImpl<Cloneable>(Cloneable.class);
    public static final JavaClass<Serializable> SERIALIZABLE = new JavaClassImpl<Serializable>(Serializable.class);

    public static <T> JavaClass<T> from(Class<T> raw, Type generic, Map<TypeVariable<?>, JavaTypeVariable> context) {
        if (generic instanceof Class) {
            return JavaClass.from(raw);
        }
        if (generic instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)generic;
            return JavaParameterizedType.from(raw, pt, context);
        }
        return null;
    }

    public static JavaClass<?> from(Type t, Map<TypeVariable<?>, JavaTypeVariable> context) {
        if (t instanceof Class) {
            return JavaClass.from((Class)t);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return JavaParameterizedType.from((Class)pt.getRawType(), pt, context);
        }
        return null;
    }

    public static <T> JavaClass<T> from(Class<T> c) {
        if (c.isArray() || c.isPrimitive() || c.getSimpleName().equals("")) {
            return null;
        }
        return new JavaClassImpl<T>(c);
    }

    public abstract DottedPath getPackageName();

    public DottedPath getCanonicalName() {
        return this.getPackageName().child(this.getSimpleName());
    }

    public abstract JavaClass<? super T> getSuperclass();

    public abstract List<JavaClass<?>> getInterfaces();

    @Override
    public JavaClass<T> applySubstitution(Map<JavaTypeVariable, JavaTypeArgument> substitution) {
        return this;
    }

    public String toString() {
        return this.getCanonicalName().withDots();
    }

    public int hashCode() {
        return Objects.hash(this.getPackageName(), this.getSimpleName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JavaClass other = (JavaClass)object;
        return Objects.equals(this.getPackageName(), other.getPackageName()) && Objects.equals(this.getSimpleName(), other.getSimpleName());
    }

    @Override
    public void accept(JavaTypeVisitor visitor) {
        visitor.visitType(this);
    }

    protected static class JavaClassImpl<T>
    extends JavaClass<T> {
        private final Class<T> backingClass;
        private final DottedPath packageName;

        public JavaClassImpl(Class<T> backingClass) {
            this.packageName = DottedPath.splitOnDots(backingClass.getCanonicalName()).parent();
            this.backingClass = backingClass;
        }

        public Class<T> getBackingClass() {
            return this.backingClass;
        }

        @Override
        public boolean isSubtypeOf(JavaType other) {
            if (other instanceof JavaPrimitiveType) {
                return false;
            }
            if (other.equals(OBJECT)) {
                return true;
            }
            if (other instanceof JavaClassImpl) {
                return ((JavaClassImpl)other).backingClass.isAssignableFrom(this.backingClass);
            }
            if (other instanceof JavaParameterizedType) {
                return ((JavaParameterizedType)other).isSupertypeOf(this);
            }
            return false;
        }

        @Override
        public boolean extendsDeclaration(JavaTypeDeclaration<?> other) {
            if (other.equals(OBJECT)) {
                return true;
            }
            if (other instanceof JavaGenericTypeDeclaration.JavaGenericTypeDeclarationImpl) {
                return ((JavaGenericTypeDeclaration.JavaGenericTypeDeclarationImpl)other).getBackingClass().isAssignableFrom(this.backingClass);
            }
            if (other instanceof JavaClassImpl) {
                return ((JavaClassImpl)other).getBackingClass().isAssignableFrom(this.backingClass);
            }
            if (other instanceof JavaParameterizedType) {
                return this.extendsDeclaration(((JavaParameterizedType)other).getGenericTypeDeclaration());
            }
            return false;
        }

        @Override
        public JavaTypeDeclaration<? super T> getSuperclassDeclaration() {
            Class<T> superclass = this.backingClass.getSuperclass();
            if (superclass == null) {
                return OBJECT;
            }
            return JavaTypeDeclaration.from(superclass);
        }

        @Override
        public JavaClass<? super T> getSuperclass() {
            JavaTypeDeclaration<T> superDeclaration = this.getSuperclassDeclaration();
            if (superDeclaration == null) {
                return null;
            }
            if (superDeclaration instanceof JavaClass) {
                return (JavaClass)superDeclaration;
            }
            return JavaClass.from(this.backingClass.getSuperclass(), this.backingClass.getGenericSuperclass(), Collections.emptyMap());
        }

        @Override
        public List<JavaTypeDeclaration<?>> getInterfaceDeclarations() {
            return Arrays.stream(this.backingClass.getInterfaces()).map(i -> JavaTypeDeclaration.from(i)).collect(Collectors.toList());
        }

        @Override
        public List<JavaClass<?>> getInterfaces() {
            ArrayList result = new ArrayList();
            Class<?>[] interfaces = this.backingClass.getInterfaces();
            Type[] genericInterfaces = this.backingClass.getGenericInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                JavaTypeDeclaration<?> decl = JavaTypeDeclaration.from(interfaces[i]);
                if (decl instanceof JavaClass) {
                    result.add((JavaClass)decl);
                    continue;
                }
                result.add(JavaClass.from(interfaces[i], genericInterfaces[i], Collections.emptyMap()));
            }
            return result;
        }

        @Override
        public String getSimpleName() {
            return this.backingClass.getSimpleName();
        }

        @Override
        public DottedPath getPackageName() {
            return this.packageName;
        }

        @Override
        public Class<T> loadClass(ClassLoader classLoader) throws ClassNotFoundException {
            return this.backingClass;
        }

        @Override
        public boolean isFinal() {
            return Modifier.isFinal(this.backingClass.getModifiers()) || this.backingClass.isEnum();
        }
    }
}

