/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util.serialisation;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.util.serialisation.TypeXMLConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class RosettaXMLConfiguration {
    @JsonAnyGetter
    private final SortedMap<ModelSymbolId, TypeXMLConfiguration> typeConfigMap;

    public RosettaXMLConfiguration(Map<ModelSymbolId, TypeXMLConfiguration> typeConfigMap) {
        this.typeConfigMap = new TreeMap<ModelSymbolId, TypeXMLConfiguration>(typeConfigMap);
    }

    public static RosettaXMLConfiguration load(InputStream input) throws IOException {
        ObjectMapper xmlConfigurationMapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        return (RosettaXMLConfiguration)xmlConfigurationMapper.readValue(input, RosettaXMLConfiguration.class);
    }

    public Optional<TypeXMLConfiguration> getConfigurationForType(ModelSymbolId symbolId) {
        return Optional.ofNullable((TypeXMLConfiguration)this.typeConfigMap.get(symbolId));
    }

    public List<ModelSymbolId> getSubstitutionsForType(ModelSymbolId symbolId) {
        return this.typeConfigMap.entrySet().stream().filter(e -> ((TypeXMLConfiguration)e.getValue()).getSubstitutionFor().map(t -> t.equals(symbolId)).orElse(false)).map(e -> (ModelSymbolId)e.getKey()).collect(Collectors.toList());
    }

    public int hashCode() {
        return Objects.hash(this.typeConfigMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RosettaXMLConfiguration other = (RosettaXMLConfiguration)obj;
        return Objects.equals(this.typeConfigMap, other.typeConfigMap);
    }

    @JsonCreator
    private RosettaXMLConfiguration() {
        this(Collections.emptyMap());
    }

    @JsonAnySetter
    private void add(String qualifiedName, TypeXMLConfiguration config) {
        this.typeConfigMap.put(ModelSymbolId.fromQualifiedName(qualifiedName), config);
    }
}

