/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.metafields;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.GlobalKeyFields;
import com.rosetta.model.lib.meta.Key;
import com.rosetta.model.lib.meta.MetaDataFields;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFieldsMeta;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MetaFields", builder=MetaFieldsBuilderImpl.class, version="0.0.0")
@RuneDataType(value="MetaFields", builder=MetaFieldsBuilderImpl.class, version="0.0.0")
public interface MetaFields
extends RosettaModelObject,
GlobalKeyFields,
MetaDataFields {
    public static final MetaFieldsMeta metaData = new MetaFieldsMeta();

    @Override
    public String getScheme();

    public String getTemplate();

    public String getLocation();

    public String getAddress();

    @Override
    public String getGlobalKey();

    @Override
    public String getExternalKey();

    @Override
    public List<? extends Key> getKey();

    public String getScopedKey();

    @Override
    public MetaFields build();

    @Override
    public MetaFieldsBuilder toBuilder();

    public static MetaFieldsBuilder builder() {
        return new MetaFieldsBuilderImpl();
    }

    default public RosettaMetaData<? extends MetaFields> metaData() {
        return metaData;
    }

    default public Class<? extends MetaFields> getType() {
        return MetaFields.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("scheme"), String.class, this.getScheme(), (RosettaModelObject)this, AttributeMeta.META);
        processor.processBasic(path.newSubPath("template"), String.class, this.getTemplate(), (RosettaModelObject)this, AttributeMeta.META);
        processor.processBasic(path.newSubPath("location"), String.class, this.getLocation(), (RosettaModelObject)this, AttributeMeta.META);
        processor.processBasic(path.newSubPath("address"), String.class, this.getAddress(), (RosettaModelObject)this, AttributeMeta.META);
        processor.processBasic(path.newSubPath("globalKey"), String.class, this.getGlobalKey(), (RosettaModelObject)this, AttributeMeta.META);
        processor.processBasic(path.newSubPath("externalKey"), String.class, this.getExternalKey(), (RosettaModelObject)this, AttributeMeta.META);
        this.processRosetta(path.newSubPath("key"), processor, Key.class, this.getKey(), new AttributeMeta[0]);
    }

    public static class MetaFieldsBuilderImpl
    implements MetaFieldsBuilder {
        protected String scheme;
        protected String template;
        protected String location;
        protected String address;
        protected String globalKey;
        protected String externalKey;
        protected List<Key.KeyBuilder> key = new ArrayList<Key.KeyBuilder>();

        @Override
        @RosettaAttribute(value="scheme")
        @RuneAttribute(value="@scheme")
        public String getScheme() {
            return this.scheme;
        }

        @Override
        @RosettaAttribute(value="template")
        public String getTemplate() {
            return this.template;
        }

        @Override
        @RosettaAttribute(value="scopedLocation")
        public String getLocation() {
            return this.location;
        }

        @Override
        @RosettaAttribute(value="address")
        @RuneAttribute(value="@ref:scoped")
        public String getAddress() {
            return this.address;
        }

        @Override
        @RosettaAttribute(value="globalKey")
        @RuneAttribute(value="@key")
        public String getGlobalKey() {
            return this.globalKey;
        }

        @Override
        @RosettaAttribute(value="externalKey")
        @RuneAttribute(value="@key:external")
        public String getExternalKey() {
            return this.externalKey;
        }

        @Override
        @RosettaAttribute(value="location")
        @Deprecated
        public List<? extends Key.KeyBuilder> getKey() {
            return this.key;
        }

        @Override
        @RuneAttribute(value="@key:scoped")
        public String getScopedKey() {
            if (this.key == null || this.key.isEmpty()) {
                return null;
            }
            return this.key.get(0).getKeyValue();
        }

        @Override
        public Key.KeyBuilder getOrCreateKey(int _index) {
            if (this.key == null) {
                this.key = new ArrayList<Key.KeyBuilder>();
            }
            return this.getIndex(this.key, _index, () -> {
                Key.KeyBuilder newKey = Key.builder();
                return newKey;
            });
        }

        @Override
        @RosettaAttribute(value="scheme")
        @RuneAttribute(value="@scheme")
        public MetaFieldsBuilder setScheme(String scheme) {
            this.scheme = scheme == null ? null : scheme;
            return this;
        }

        @Override
        @RosettaAttribute(value="template")
        public MetaFieldsBuilder setTemplate(String template) {
            this.template = template == null ? null : template;
            return this;
        }

        @Override
        @RosettaAttribute(value="scopedLocation")
        public MetaFieldsBuilder setLocation(String location) {
            this.location = location == null ? null : location;
            return this;
        }

        @Override
        @RosettaAttribute(value="address")
        @RuneAttribute(value="@ref:scoped")
        public MetaFieldsBuilder setAddress(String address) {
            this.address = address == null ? null : address;
            return this;
        }

        @Override
        @RosettaAttribute(value="globalKey")
        @RuneAttribute(value="@key")
        public MetaFieldsBuilder setGlobalKey(String globalKey) {
            this.globalKey = globalKey == null ? null : globalKey;
            return this;
        }

        @Override
        @RosettaAttribute(value="externalKey")
        @RuneAttribute(value="@key:external")
        public MetaFieldsBuilder setExternalKey(String externalKey) {
            this.externalKey = externalKey == null ? null : externalKey;
            return this;
        }

        @Override
        public MetaFieldsBuilder addKey(Key key) {
            if (key != null) {
                this.key.add(key.toBuilder());
            }
            return this;
        }

        @Override
        public MetaFieldsBuilder addKey(Key key, int _idx) {
            this.getIndex(this.key, _idx, () -> key.toBuilder());
            return this;
        }

        @Override
        public MetaFieldsBuilder addKey(List<? extends Key> keys) {
            if (keys != null) {
                for (Key key : keys) {
                    this.key.add(key.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="location")
        @Deprecated
        public MetaFieldsBuilder setKey(List<? extends Key> keys) {
            this.key = keys == null ? new ArrayList<Key.KeyBuilder>() : (List)keys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RuneAttribute(value="@key:scoped")
        public MetaFieldsBuilder setScopedKey(String scopedKey) {
            this.key = new ArrayList<Key.KeyBuilder>();
            if (scopedKey != null) {
                this.key = Lists.newArrayList((Object[])new Key.KeyBuilder[]{Key.builder().setKeyValue(scopedKey)});
            }
            return this;
        }

        @Override
        public MetaFields build() {
            return new MetaFieldsImpl(this);
        }

        @Override
        public MetaFieldsBuilder toBuilder() {
            return this;
        }

        @Override
        public MetaFieldsBuilder prune() {
            this.key = this.key.stream().filter(b -> b != null).map(b -> (Key.KeyBuilder)b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (this.getScheme() != null) {
                return true;
            }
            if (this.getTemplate() != null) {
                return true;
            }
            if (this.getLocation() != null) {
                return true;
            }
            if (this.getAddress() != null) {
                return true;
            }
            if (this.getGlobalKey() != null) {
                return true;
            }
            if (this.getExternalKey() != null) {
                return true;
            }
            return this.getKey() != null && this.getKey().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public MetaFieldsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MetaFieldsBuilder o = (MetaFieldsBuilder)other;
            merger.mergeRosetta(this.getKey(), o.getKey(), this::getOrCreateKey);
            merger.mergeBasic(this.getScheme(), o.getScheme(), this::setScheme, new AttributeMeta[0]);
            merger.mergeBasic(this.getTemplate(), o.getTemplate(), this::setTemplate, new AttributeMeta[0]);
            merger.mergeBasic(this.getLocation(), o.getLocation(), this::setLocation, new AttributeMeta[0]);
            merger.mergeBasic(this.getAddress(), o.getAddress(), this::setAddress, new AttributeMeta[0]);
            merger.mergeBasic(this.getGlobalKey(), o.getGlobalKey(), this::setGlobalKey, new AttributeMeta[0]);
            merger.mergeBasic(this.getExternalKey(), o.getExternalKey(), this::setExternalKey, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MetaFields _that = this.getType().cast(o);
            if (!Objects.equals(this.scheme, _that.getScheme())) {
                return false;
            }
            if (!Objects.equals(this.template, _that.getTemplate())) {
                return false;
            }
            if (!Objects.equals(this.location, _that.getLocation())) {
                return false;
            }
            if (!Objects.equals(this.address, _that.getAddress())) {
                return false;
            }
            if (!Objects.equals(this.globalKey, _that.getGlobalKey())) {
                return false;
            }
            if (!Objects.equals(this.externalKey, _that.getExternalKey())) {
                return false;
            }
            return ListEquals.listEquals(this.key, _that.getKey());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.scheme != null ? this.scheme.hashCode() : 0);
            _result = 31 * _result + (this.template != null ? this.template.hashCode() : 0);
            _result = 31 * _result + (this.location != null ? this.location.hashCode() : 0);
            _result = 31 * _result + (this.address != null ? this.address.hashCode() : 0);
            _result = 31 * _result + (this.globalKey != null ? this.globalKey.hashCode() : 0);
            _result = 31 * _result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
            _result = 31 * _result + (this.key != null ? this.key.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MetaFieldsBuilder {scheme=" + this.scheme + ", template=" + this.template + ", location=" + this.location + ", address=" + this.address + ", globalKey=" + this.globalKey + ", externalKey=" + this.externalKey + ", key=" + this.key + '}';
        }
    }

    public static interface MetaFieldsBuilder
    extends MetaFields,
    RosettaModelObjectBuilder,
    GlobalKeyFields.GlobalKeyFieldsBuilder,
    MetaDataFields.MetaDataFieldsBuilder {
        @Override
        public Key.KeyBuilder getOrCreateKey(int var1);

        @Override
        public List<? extends Key.KeyBuilder> getKey();

        @Override
        public MetaFieldsBuilder setScheme(String var1);

        public MetaFieldsBuilder setTemplate(String var1);

        public MetaFieldsBuilder setLocation(String var1);

        public MetaFieldsBuilder setAddress(String var1);

        @Override
        public MetaFieldsBuilder setGlobalKey(String var1);

        @Override
        public MetaFieldsBuilder setExternalKey(String var1);

        @Override
        public MetaFieldsBuilder addKey(Key var1);

        @Override
        public MetaFieldsBuilder addKey(Key var1, int var2);

        @Override
        public MetaFieldsBuilder addKey(List<? extends Key> var1);

        @Override
        public MetaFieldsBuilder setKey(List<? extends Key> var1);

        public MetaFieldsBuilder setScopedKey(String var1);

        @Override
        public String getScopedKey();

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("scheme"), String.class, this.getScheme(), (RosettaModelObjectBuilder)this, AttributeMeta.META);
            processor.processBasic(path.newSubPath("template"), String.class, this.getTemplate(), (RosettaModelObjectBuilder)this, AttributeMeta.META);
            processor.processBasic(path.newSubPath("location"), String.class, this.getLocation(), (RosettaModelObjectBuilder)this, AttributeMeta.META);
            processor.processBasic(path.newSubPath("address"), String.class, this.getAddress(), (RosettaModelObjectBuilder)this, AttributeMeta.META);
            processor.processBasic(path.newSubPath("globalKey"), String.class, this.getGlobalKey(), (RosettaModelObjectBuilder)this, AttributeMeta.META);
            processor.processBasic(path.newSubPath("externalKey"), String.class, this.getExternalKey(), (RosettaModelObjectBuilder)this, AttributeMeta.META);
            this.processRosetta(path.newSubPath("key"), processor, Key.KeyBuilder.class, this.getKey(), new AttributeMeta[0]);
        }

        public MetaFieldsBuilder prune();
    }

    public static class MetaFieldsImpl
    implements MetaFields {
        private final String scheme;
        private final String template;
        private final String location;
        private final String address;
        private final String globalKey;
        private final String externalKey;
        private final List<? extends Key> key;

        protected MetaFieldsImpl(MetaFieldsBuilder builder) {
            this.scheme = builder.getScheme();
            this.template = builder.getTemplate();
            this.location = builder.getLocation();
            this.address = builder.getAddress();
            this.globalKey = builder.getGlobalKey();
            this.externalKey = builder.getExternalKey();
            this.key = Optional.ofNullable(builder.getKey()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="scheme")
        @RuneAttribute(value="@scheme")
        public String getScheme() {
            return this.scheme;
        }

        @Override
        @RosettaAttribute(value="template")
        public String getTemplate() {
            return this.template;
        }

        @Override
        @RosettaAttribute(value="scopedLocation")
        public String getLocation() {
            return this.location;
        }

        @Override
        @RosettaAttribute(value="address")
        @RuneAttribute(value="@ref:scoped")
        public String getAddress() {
            return this.address;
        }

        @Override
        @RosettaAttribute(value="globalKey")
        @RuneAttribute(value="@key")
        public String getGlobalKey() {
            return this.globalKey;
        }

        @Override
        @RosettaAttribute(value="externalKey")
        @RuneAttribute(value="@key:external")
        public String getExternalKey() {
            return this.externalKey;
        }

        @Override
        @RosettaAttribute(value="location")
        @Deprecated
        public List<? extends Key> getKey() {
            return this.key;
        }

        @Override
        @RuneAttribute(value="@key:scoped")
        public String getScopedKey() {
            if (this.key == null || this.key.isEmpty()) {
                return null;
            }
            return this.key.get(0).getKeyValue();
        }

        @Override
        public MetaFields build() {
            return this;
        }

        @Override
        public MetaFieldsBuilder toBuilder() {
            MetaFieldsBuilder builder = MetaFields.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MetaFieldsBuilder builder) {
            Optional.ofNullable(this.getScheme()).ifPresent(builder::setScheme);
            Optional.ofNullable(this.getTemplate()).ifPresent(builder::setTemplate);
            Optional.ofNullable(this.getLocation()).ifPresent(builder::setLocation);
            Optional.ofNullable(this.getAddress()).ifPresent(builder::setAddress);
            Optional.ofNullable(this.getGlobalKey()).ifPresent(builder::setGlobalKey);
            Optional.ofNullable(this.getExternalKey()).ifPresent(builder::setExternalKey);
            Optional.ofNullable(this.getKey()).ifPresent(builder::setKey);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MetaFields _that = this.getType().cast(o);
            if (!Objects.equals(this.scheme, _that.getScheme())) {
                return false;
            }
            if (!Objects.equals(this.template, _that.getTemplate())) {
                return false;
            }
            if (!Objects.equals(this.location, _that.getLocation())) {
                return false;
            }
            if (!Objects.equals(this.address, _that.getAddress())) {
                return false;
            }
            if (!Objects.equals(this.globalKey, _that.getGlobalKey())) {
                return false;
            }
            if (!Objects.equals(this.externalKey, _that.getExternalKey())) {
                return false;
            }
            return ListEquals.listEquals(this.key, _that.getKey());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.scheme != null ? this.scheme.hashCode() : 0);
            _result = 31 * _result + (this.template != null ? this.template.hashCode() : 0);
            _result = 31 * _result + (this.location != null ? this.location.hashCode() : 0);
            _result = 31 * _result + (this.address != null ? this.address.hashCode() : 0);
            _result = 31 * _result + (this.globalKey != null ? this.globalKey.hashCode() : 0);
            _result = 31 * _result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
            _result = 31 * _result + (this.key != null ? this.key.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MetaFields {scheme=" + this.scheme + ", template=" + this.template + ", location=" + this.location + ", address=" + this.address + ", globalKey=" + this.globalKey + ", externalKey=" + this.externalKey + ", key=" + this.key + '}';
        }
    }
}

