/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.meta;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

@RosettaDataType(value="Key", builder=KeyBuilderImpl.class)
public interface Key
extends RosettaModelObject {
    public static final KeyMeta meta = new KeyMeta();

    public String getScope();

    public String getKeyValue();

    @Override
    public Key build();

    @Override
    public KeyBuilder toBuilder();

    @Override
    default public RosettaMetaData<? extends RosettaModelObject> metaData() {
        return meta;
    }

    @Override
    default public Class<? extends RosettaModelObject> getType() {
        return Key.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
    }

    public static KeyBuilder builder() {
        return new KeyBuilderImpl();
    }

    public static class KeyMeta
    implements RosettaMetaData<Key> {
        @Override
        public List<Validator<? super Key>> dataRules(ValidatorFactory factory) {
            return Collections.emptyList();
        }

        @Override
        public List<Function<? super Key, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
            return Collections.emptyList();
        }

        @Override
        public Validator<? super Key> validator() {
            return new Validator<Key>(){

                @Override
                public ValidationResult<Key> validate(RosettaPath path, Key key) {
                    if (key.getKeyValue() == null) {
                        return ValidationResult.failure("Key.value", ValidationResult.ValidationType.KEY, "Key", path, "", "Key value must be set");
                    }
                    if (key.getScope() == null) {
                        return ValidationResult.failure("Key.scope", ValidationResult.ValidationType.KEY, "Key", path, "", "Key scope must be set");
                    }
                    return ValidationResult.success("Key", ValidationResult.ValidationType.KEY, "Key", path, "");
                }
            };
        }

        @Override
        public Validator<? super Key> typeFormatValidator() {
            return null;
        }

        @Override
        public ValidatorWithArg<? super Key, Set<String>> onlyExistsValidator() {
            return null;
        }
    }

    public static class KeyBuilderImpl
    implements KeyBuilder {
        private String scope;
        private String keyValue;

        @Override
        public Key build() {
            return new KeyImpl(this);
        }

        @Override
        @RosettaAttribute(value="scope")
        public String getScope() {
            return this.scope;
        }

        @Override
        @RosettaAttribute(value="scope")
        public KeyBuilder setScope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        @RosettaAttribute(value="value")
        public String getKeyValue() {
            return this.keyValue;
        }

        @Override
        @RosettaAttribute(value="value")
        public KeyBuilder setKeyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        @Override
        public boolean hasData() {
            return this.keyValue != null;
        }

        @Override
        public KeyBuilder toBuilder() {
            return this;
        }

        public KeyBuilder prune() {
            return this;
        }

        public KeyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            KeyBuilder otherKey = (KeyBuilder)other;
            merger.mergeBasic(this.getKeyValue(), otherKey.getKeyValue(), this::setKeyValue, new AttributeMeta[0]);
            merger.mergeBasic(this.getScope(), otherKey.getScope(), this::setScope, new AttributeMeta[0]);
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keyValue == null ? 0 : this.keyValue.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyBuilderImpl other = (KeyBuilderImpl)obj;
            if (this.keyValue == null ? other.keyValue != null : !this.keyValue.equals(other.keyValue)) {
                return false;
            }
            return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
        }
    }

    public static interface KeyBuilder
    extends Key,
    RosettaModelObjectBuilder {
        public KeyBuilder setScope(String var1);

        public KeyBuilder setKeyValue(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
        }
    }

    public static class KeyImpl
    implements Key {
        private final String scope;
        private final String keyValue;

        public KeyImpl(KeyBuilder builder) {
            this.scope = builder.getScope();
            this.keyValue = builder.getKeyValue();
        }

        @Override
        @RosettaAttribute(value="scope")
        public String getScope() {
            return this.scope;
        }

        @Override
        @RosettaAttribute(value="value")
        public String getKeyValue() {
            return this.keyValue;
        }

        @Override
        public KeyBuilder toBuilder() {
            KeyBuilder key = Key.builder();
            key.setKeyValue(this.keyValue);
            key.setScope(this.scope);
            return key;
        }

        @Override
        public Key build() {
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keyValue == null ? 0 : this.keyValue.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyImpl other = (KeyImpl)obj;
            if (this.keyValue == null ? other.keyValue != null : !this.keyValue.equals(other.keyValue)) {
                return false;
            }
            return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
        }
    }
}

