/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.mapper;

import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.function.Supplier;

public class MapperUtils {
    public static <T> Mapper<T> runSingle(Supplier<Mapper<T>> supplier) {
        Mapper<T> result = supplier.get();
        if (result == null) {
            return MapperS.ofNull();
        }
        if (result instanceof MapperS || result instanceof ComparisonResult) {
            return result;
        }
        return MapperS.of(result.get());
    }

    public static <T> Mapper<? extends T> runSinglePolymorphic(Supplier<Mapper<? extends T>> supplier) {
        Mapper<T> result = supplier.get();
        if (result == null) {
            return MapperS.ofNull();
        }
        if (result instanceof MapperS || result instanceof ComparisonResult) {
            return result;
        }
        return MapperS.of(result.get());
    }

    public static <T> MapperC<T> runMulti(Supplier<Mapper<T>> supplier) {
        Mapper<T> result = supplier.get();
        if (result == null) {
            return MapperC.ofNull();
        }
        if (result instanceof MapperC) {
            return (MapperC)result;
        }
        return MapperC.of(result.getMulti());
    }

    public static <T> MapperC<? extends T> runMultiPolymorphic(Supplier<Mapper<? extends T>> supplier) {
        Mapper<T> result = supplier.get();
        if (result == null) {
            return MapperC.ofNull();
        }
        if (result instanceof MapperC) {
            return (MapperC)result;
        }
        return MapperC.of(result.getMulti());
    }

    @Deprecated
    public static <T> Mapper<T> fromBuiltInType(Supplier<Mapper<T>> supplier) {
        return supplier.get();
    }

    @Deprecated
    public static <T> Mapper<? extends T> fromDataType(Supplier<Mapper<? extends T>> supplier) {
        return supplier.get();
    }

    public static ComparisonResult toComparisonResult(Mapper<Boolean> mapper) {
        if (mapper instanceof ComparisonResult) {
            return (ComparisonResult)mapper;
        }
        if (mapper.getMulti().isEmpty()) {
            return ComparisonResult.successEmptyOperand("");
        }
        return mapper.getMulti().stream().allMatch(Boolean::booleanValue) ? ComparisonResult.success() : ComparisonResult.failure("");
    }
}

