/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.synonymmap;

import com.regnosys.rosetta.rosetta.RosettaMapPath;
import com.regnosys.rosetta.rosetta.RosettaMapRosettaPath;
import com.regnosys.rosetta.rosetta.RosettaMapTest;
import com.regnosys.rosetta.rosetta.RosettaMapTestAbsentExpression;
import com.regnosys.rosetta.rosetta.RosettaMapTestEqualityOperation;
import com.regnosys.rosetta.rosetta.RosettaMapTestExistsExpression;
import com.regnosys.rosetta.rosetta.RosettaMapTestExpression;
import com.regnosys.rosetta.rosetta.RosettaMapTestFunc;
import com.regnosys.rosetta.translate.synonymmap.SynonymAbsentTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymBinaryTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymConditionFuncTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymExistsTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymPathTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymRosettaPathTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymTest;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynonymCondition {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynonymCondition.class);
    private final RosettaMapTestExpression setToValue;
    private final List<SynonymTest> condition;

    public static SynonymCondition create(RosettaMapTestExpression setToValue, List<RosettaMapTest> condition) {
        return new SynonymCondition(setToValue, SynonymCondition.toTests(condition));
    }

    public SynonymCondition(RosettaMapTestExpression setToValue, List<SynonymTest> condition) {
        this.setToValue = setToValue;
        this.condition = condition;
    }

    private static List<SynonymTest> toTests(List<RosettaMapTest> condition) {
        ArrayList<SynonymTest> result = new ArrayList<SynonymTest>();
        for (RosettaMapTest exp : condition) {
            if (exp instanceof RosettaMapTestEqualityOperation) {
                result.add(new SynonymBinaryTest((RosettaMapTestEqualityOperation)exp));
                continue;
            }
            if (exp instanceof RosettaMapTestExistsExpression) {
                result.add(new SynonymExistsTest((RosettaMapTestExistsExpression)exp));
                continue;
            }
            if (exp instanceof RosettaMapTestAbsentExpression) {
                result.add(new SynonymAbsentTest((RosettaMapTestAbsentExpression)exp));
                continue;
            }
            if (exp instanceof RosettaMapPath) {
                result.add(new SynonymPathTest((RosettaMapPath)exp));
                continue;
            }
            if (exp instanceof RosettaMapRosettaPath) {
                result.add(new SynonymRosettaPathTest((RosettaMapRosettaPath)exp));
                continue;
            }
            if (exp instanceof RosettaMapTestFunc) {
                result.add(new SynonymConditionFuncTest((RosettaMapTestFunc)exp));
                continue;
            }
            throw new UnsupportedOperationException("Cannot convert expression of type " + exp.getClass().getSimpleName() + " to SynonymTest");
        }
        return result;
    }

    public RosettaMapTestExpression getSetToValue() {
        return this.setToValue;
    }

    public List<SynonymTest> getCondition() {
        return this.condition;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.setToValue == null ? 0 : this.setToValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynonymCondition other = (SynonymCondition)obj;
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        return !(this.setToValue == null ? other.setToValue != null : !this.setToValue.equals(other.setToValue));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.condition == null || this.condition.isEmpty() && this.setToValue != null) {
            builder.append("default to ");
            builder.append(SynonymTest.toString(this.setToValue));
        } else {
            if (this.setToValue != null) {
                builder.append("set to ");
                builder.append(SynonymTest.toString(this.setToValue));
            }
            if (this.condition != null && !this.condition.isEmpty()) {
                builder.append(" when ");
                builder.append(this.condition.stream().map(t -> t.toString()).collect(Collectors.joining(" and ")));
            }
        }
        return builder.toString();
    }
}

