/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel.json.schema;

import com.google.common.io.Resources;
import com.regnosys.rosetta.translate.TranslatorRootPackage;
import com.regnosys.rosetta.translate.datamodel.Schema;
import com.regnosys.rosetta.translate.datamodel.json.CreateiQJsonSchemaParser;
import com.regnosys.rosetta.translate.datamodel.json.schema.JavaFileWriter;
import com.regnosys.rosetta.translate.datamodel.json.schema.JsonSchemaToClasses;
import com.rosetta.util.DottedPath;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class JsonSchemaToJavaGenerator {
    private final JsonSchemaToClasses translator;
    private final List<String> sharedClassesExclusions;

    JsonSchemaToJavaGenerator(JsonSchemaToClasses translator, List<String> sharedClassesExclusions) {
        this.translator = translator;
        this.sharedClassesExclusions = sharedClassesExclusions;
    }

    void generate(List<GeneratorParam> params, String outputDir, String sharedPackage) {
        HashMap paramClassesMap = new HashMap();
        ArrayList allClasses = new ArrayList();
        params.forEach(param -> {
            Set<JavaFileWriter.PojoClass> paramClasses = this.createPojoClasses(param.schema, param.topClass);
            paramClassesMap.put(param, paramClasses);
            allClasses.addAll(paramClasses);
        });
        Set sharedClasses = allClasses.stream().collect(Collectors.collectingAndThen(Collectors.groupingBy(Function.identity(), Collectors.counting()), this::filterMultiple));
        sharedClasses.removeIf(c -> this.sharedClassesExclusions.contains(c.getName()));
        paramClassesMap.entrySet().forEach(entry -> {
            Set classes = (Set)entry.getValue();
            classes.removeAll(sharedClasses);
            this.writePojoClasses(outputDir, ((GeneratorParam)entry.getKey()).mainPackage, sharedPackage, classes);
        });
        this.writePojoClasses(outputDir, sharedPackage, sharedPackage, sharedClasses);
    }

    private Set<JavaFileWriter.PojoClass> filterMultiple(Map<JavaFileWriter.PojoClass, Long> classCountMap) {
        return classCountMap.entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private Set<JavaFileWriter.PojoClass> createPojoClasses(String schemaPath, String topClass) {
        URL schemaUrl = Resources.getResource((String)schemaPath);
        CreateiQJsonSchemaParser parser = new CreateiQJsonSchemaParser();
        Schema schema = parser.parseModel(schemaUrl);
        return this.translator.translate(schema, topClass);
    }

    private void writePojoClasses(String outputDir, String mainPackage, String sharedPackage, Set<JavaFileWriter.PojoClass> classes) {
        TranslatorRootPackage main = new TranslatorRootPackage(mainPackage);
        TranslatorRootPackage shared = new TranslatorRootPackage(sharedPackage);
        JavaFileWriter writer = new JavaFileWriter();
        classes.forEach(arg_0 -> JsonSchemaToJavaGenerator.lambda$writePojoClasses$4(writer, (DottedPath)main, (DottedPath)shared, outputDir, arg_0));
    }

    private static /* synthetic */ void lambda$writePojoClasses$4(JavaFileWriter writer, DottedPath main, DottedPath shared, String outputDir, JavaFileWriter.PojoClass c) {
        String contents = writer.toJava(main, shared, c).toString();
        writer.writeFile(Paths.get(outputDir, new String[0]), main, c.getName(), contents);
    }

    static class GeneratorParam {
        private final String schema;
        private final String topClass;
        private final String mainPackage;

        public GeneratorParam(String schema, String topClass, String mainPackage) {
            this.schema = schema;
            this.topClass = topClass;
            this.mainPackage = mainPackage;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GeneratorParam other = (GeneratorParam)obj;
            if (this.mainPackage == null ? other.mainPackage != null : !this.mainPackage.equals(other.mainPackage)) {
                return false;
            }
            if (this.schema == null ? other.schema != null : !this.schema.equals(other.schema)) {
                return false;
            }
            return !(this.topClass == null ? other.topClass != null : !this.topClass.equals(other.topClass));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mainPackage == null ? 0 : this.mainPackage.hashCode());
            result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
            result = 31 * result + (this.topClass == null ? 0 : this.topClass.hashCode());
            return result;
        }
    }
}

