/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.regnosys.rosetta.common.hashing.ReferenceConfig;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.translate.HandlerFactory;
import com.regnosys.rosetta.translate.HandlerStackItem;
import com.regnosys.rosetta.translate.HandlerSupplier;
import com.regnosys.rosetta.translate.HandlerWithPath;
import com.regnosys.rosetta.translate.IngestException;
import com.regnosys.rosetta.translate.ParserHelper;
import com.regnosys.rosetta.translate.ParserParent;
import com.regnosys.rosetta.translate.ParserResult;
import com.regnosys.rosetta.translate.ROMParseHandler;
import com.regnosys.rosetta.translate.RootHandler;
import com.regnosys.rosetta.translate.SynonymToEnumMapBuilder;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLParser
extends ParserParent {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLParser.class);

    public XMLParser(HandlerFactory factory, SynonymToEnumMapBuilder synonymToEnumMap, ReferenceConfig referenceConfig) {
        super(factory, synonymToEnumMap, referenceConfig);
    }

    @Override
    protected <T extends RosettaModelObject> ParserResult parseTheDocument(Reader xmlReader, Schema schema, Class<T> returnClass) {
        char[] xmlChars = ParserHelper.toCharsfromReader(xmlReader);
        List<String> validationErrors = this.validateXML(xmlChars, schema);
        ParserResult.Context context = new ParserResult.Context(this.synonymToEnumMap);
        Map<Class<? extends RosettaModelObject>, HandlerSupplier> handlers = this.factory.getHandlerSuppliers(context.getMappingContext());
        if (!handlers.containsKey(returnClass)) {
            throw new IngestException("Do not have parser for " + returnClass.getSimpleName());
        }
        if (validationErrors.isEmpty()) {
            ParserResult parserResult;
            CharArrayReader xml = new CharArrayReader(xmlChars);
            try {
                ROMParseHandler handler = (ROMParseHandler)handlers.get(returnClass).apply(new Path(), new Path());
                handler.setRosettaPath(new Path().addElement(new Path.PathElement(returnClass.getSimpleName())));
                XMLInputFactory inputFac = XMLParser.createXmlInputFactory();
                XMLStreamReader xmlStreamReader = inputFac.createXMLStreamReader(xml);
                this.parse(xmlStreamReader, handler, context);
                Object rosettaInstance = handler.getUnderlying();
                LOGGER.debug("Finished parsing");
                parserResult = new ParserResult((RosettaModelObjectBuilder)rosettaInstance, context);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)xml).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | XMLStreamException ioe) {
                    throw new IngestException("error reading input xml", ioe);
                }
            }
            ((Reader)xml).close();
            return parserResult;
        }
        context.getXmlValidationErrors().addAll(validationErrors);
        return new ParserResult(null, context);
    }

    protected static XMLInputFactory createXmlInputFactory() {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        return xmlInputFactory;
    }

    private List<String> validateXML(char[] xmlChars, Schema schema) {
        List<String> list;
        CharArrayReader xml = new CharArrayReader(xmlChars);
        try {
            XmlErrorHandler xmlErrorHandler = new XmlErrorHandler();
            Validator newValidator = schema.newValidator();
            newValidator.setErrorHandler(xmlErrorHandler);
            newValidator.validate(new StreamSource(xml));
            LOGGER.debug("Finished validating xml against schema");
            list = xmlErrorHandler.getErrors();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)xml).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SAXException e) {
                throw new IngestException("Error validating xml against xsd", e);
            }
        }
        ((Reader)xml).close();
        return list;
    }

    private void parse(XMLStreamReader reader, ROMParseHandler<?> rootHandler, ParserResult.Context context) throws XMLStreamException {
        ArrayDeque<HandlerStackItem> handlerStack = new ArrayDeque<HandlerStackItem>();
        boolean end = false;
        boolean rootElement = true;
        HandlerStackItem currentHandlers = new HandlerStackItem(Collections.singletonList(new HandlerWithPath(rootHandler)), new Path(Collections.emptyList()));
        handlerStack.push(currentHandlers);
        block8: while (!end) {
            reader.next();
            List<HandlerWithPath> handlers = currentHandlers.handlers();
            Path fullPath = currentHandlers.fullPath();
            switch (reader.getEventType()) {
                case 1: {
                    String qName = reader.getName().getLocalPart();
                    if (rootElement && rootHandler instanceof RootHandler) {
                        List<String> allowedRootElements = ((RootHandler)rootHandler).getAllowedRootElements();
                        if (!allowedRootElements.contains(qName)) {
                            context.getXmlValidationErrors().add(String.format("Invalid root XML element [%s], allowed elements %s", qName, allowedRootElements));
                            end = true;
                            continue block8;
                        }
                        rootElement = false;
                    }
                    Path.PathElement element = currentHandlers.addChild(qName, this.metas(reader));
                    Path newPath = fullPath.addElement(element);
                    List complexHandlers = handlers.stream().filter(HandlerWithPath::isComplexHandler).collect(Collectors.toList());
                    List<HandlerWithPath> newHandlers = complexHandlers.stream().flatMap(hwp -> hwp.matchingHandlers(element, fullPath).stream()).collect(Collectors.toList());
                    complexHandlers.stream().flatMap(hwp -> hwp.matchingMappingProcessors(fullPath, context.getMappingContext()).stream()).forEach(mapEntryProcessor -> context.getMappingProcessors().put((RosettaPath)mapEntryProcessor.getKey(), (MappingProcessor)mapEntryProcessor.getValue()));
                    if (newHandlers.isEmpty()) {
                        LOGGER.debug(newPath + " had no destination");
                        context.getMappingContext().getMappings().add(new Mapping(newPath, null, new Path(Collections.emptyList()), null, "had no destination", false, false, false));
                    }
                    this.handleAttributes(reader, newPath, newHandlers, context);
                    currentHandlers = new HandlerStackItem(newHandlers, newPath);
                    handlerStack.push(currentHandlers);
                    continue block8;
                }
                case 4: {
                    String stringVal = reader.getText().trim();
                    if (stringVal.length() <= 0) continue block8;
                    context.getMappingContext().getMappings().addAll(HandlerWithPath.createMappings(handlers, stringVal, fullPath));
                    continue block8;
                }
                case 2: {
                    handlerStack.pop();
                    if (handlerStack.isEmpty()) {
                        end = true;
                        continue block8;
                    }
                    ((HandlerStackItem)handlerStack.peek()).handlers().stream().filter(HandlerWithPath::isComplexHandler).forEach(HandlerWithPath::removeLastIfExists);
                    currentHandlers = (HandlerStackItem)handlerStack.peek();
                    continue block8;
                }
                case 5: {
                    continue block8;
                }
                case 7: {
                    continue block8;
                }
                case 8: {
                    return;
                }
            }
            throw new AssertionError((Object)("Unhandled XMLEvent value: " + reader.getEventType()));
        }
    }

    private Map<String, String> metas(XMLStreamReader reader) {
        return IntStream.range(0, reader.getAttributeCount()).mapToObj(Integer::valueOf).collect(Collectors.toMap(i -> reader.getAttributeName((int)i).getLocalPart(), i -> reader.getAttributeValue((int)i)));
    }

    private void handleAttributes(XMLStreamReader reader, Path path, List<HandlerWithPath> newHandlers, ParserResult.Context context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (reader.getAttributeName(i).getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
            String attributeName = reader.getAttributeName(i).getLocalPart();
            String attributeValue = reader.getAttributeValue(i);
            if (attributeName.equals("fpmlVersion")) continue;
            Path aPath = path.addElement(new Path.PathElement(attributeName));
            List complexHandlers = newHandlers.stream().filter(HandlerWithPath::isComplexHandler).collect(Collectors.toList());
            ArrayList<HandlerWithPath> attributeHandlers = new ArrayList<HandlerWithPath>();
            HashMap<RosettaPath, MappingProcessor> attributeMappingProcessors = new HashMap<RosettaPath, MappingProcessor>();
            for (HandlerWithPath complexHandler : complexHandlers) {
                complexHandler.addToStackIfNotNull(new Path.PathElement(attributeName));
                attributeHandlers.addAll(complexHandler.matchingHandlers(null, path));
                complexHandler.matchingMappingProcessors(path, context.getMappingContext()).forEach(e -> attributeMappingProcessors.put((RosettaPath)e.getKey(), (MappingProcessor)e.getValue()));
            }
            context.getMappingContext().getMappings().addAll(HandlerWithPath.createMappings(attributeHandlers, attributeValue, aPath));
            if (!attributeMappingProcessors.isEmpty()) {
                LOGGER.info(aPath + " has mapping processor");
            }
            attributeMappingProcessors.forEach((modelPath, mapper) -> context.getMappingProcessors().merge((RosettaPath)modelPath, (MappingProcessor)mapper, (existingMapper, newMapper) -> {
                existingMapper.getSynonymPaths().add(aPath);
                return existingMapper;
            }));
            newHandlers.stream().filter(HandlerWithPath::isComplexHandler).forEach(HandlerWithPath::removeLastIfExists);
        }
    }

    static class XmlErrorHandler
    implements ErrorHandler {
        List<String> errors = new ArrayList<String>();

        XmlErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) {
            LOGGER.warn(this.getParseExceptionInfo(e));
        }

        @Override
        public void error(SAXParseException e) {
            String error = this.getParseExceptionInfo(e);
            LOGGER.error(this.getParseExceptionInfo(e));
            this.errors.add(error);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            String message = this.getParseExceptionInfo(e);
            LOGGER.error("Fatal: " + message);
            throw new SAXException(message);
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            return "URI=" + spe.getSystemId() + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public List<String> getErrors() {
            return this.errors;
        }
    }
}

