/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.generator.java.enums.EnumHelper;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource;
import com.regnosys.rosetta.translate.GeneratedNameAndSource;
import com.regnosys.rosetta.translate.GenerationResult;
import com.regnosys.rosetta.translate.GeneratorParams;
import com.regnosys.rosetta.translate.GeneratorUtil;
import com.regnosys.rosetta.translate.synonymmap.SynonymMapBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class SynonymToEnumMapGenerator {
    private static final Logger LOGGER = Logger.getLogger(SynonymToEnumMapGenerator.class);
    public static final String GENERATED_CLASS_NAME = "SynonymToEnumMapBuilderImpl";
    @Inject
    private JavaTypeTranslator typeTranslator;

    public GeneratedNameAndSource generate(String packageName, List<GeneratorParams> params, List<RosettaEnumeration> rosettaEnumerations) {
        Functions.Function1 _function = it -> it.getSources();
        Set synonymSources = IterableExtensions.toSet((Iterable)ListExtensions.map(params, (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> GeneratorUtil.synonymSourceNames(it);
        List synonymSourcesNames = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)synonymSources, (Functions.Function1)_function_1)));
        String _join = IterableExtensions.join((Iterable)synonymSourcesNames, (CharSequence)", ");
        String _plus = "Generating SynonymToEnumMap for synonym sources " + _join;
        LOGGER.trace((Object)_plus);
        Functions.Function1 _function_2 = it -> GeneratorUtil.externalSynonymSources(it);
        List externalSynonyms = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)synonymSources, (Functions.Function1)_function_2)));
        Map<RosettaEnumeration, Map<String, ExpandedAttribute>> enumToSynonymToEnumValueMap = this.buildMap(synonymSourcesNames, externalSynonyms, rosettaEnumerations);
        CharSequence _generateClass = this.generateClass(packageName, enumToSynonymToEnumValueMap);
        GenerationResult result = new GenerationResult(false, _generateClass);
        return new GeneratedNameAndSource(packageName + ".SynonymToEnumMapBuilderImpl", result);
    }

    private Map<RosettaEnumeration, Map<String, ExpandedAttribute>> buildMap(List<String> synonymSourcesNames, List<RosettaExternalSynonymSource> externalSynonyms, List<RosettaEnumeration> rosettaEnumerations) {
        HashMap _xblockexpression = null;
        SynonymMapBuilder synMapBuilder = new SynonymMapBuilder(synonymSourcesNames, externalSynonyms, this.typeTranslator);
        HashMap enumToSynonymToEnumValueMap = CollectionLiterals.newHashMap();
        for (RosettaEnumeration e : rosettaEnumerations) {
            HashMap synonymToEnumValueMap = CollectionLiterals.newHashMap();
            Collection<ExpandedAttribute> _allEnumValue = synMapBuilder.getAllEnumValue(e);
            for (ExpandedAttribute enumVal : _allEnumValue) {
                Functions.Function1 _function = it -> it.getValues();
                Functions.Function1 _function_1 = it -> it.getName();
                Iterable _map = IterableExtensions.map((Iterable)Iterables.concat((Iterable)ListExtensions.map(synMapBuilder.getEnumSynonyms(enumVal), (Functions.Function1)_function)), (Functions.Function1)_function_1);
                for (String enumSyn : _map) {
                    synonymToEnumValueMap.put(enumSyn, enumVal);
                }
            }
            boolean _isEmpty = synonymToEnumValueMap.isEmpty();
            boolean _not = !_isEmpty;
            if (!_not) continue;
            enumToSynonymToEnumValueMap.put(e, synonymToEnumValueMap);
        }
        _xblockexpression = enumToSynonymToEnumValueMap;
        return _xblockexpression;
    }

    private CharSequence generateClass(String packageName, Map<RosettaEnumeration, Map<String, ExpandedAttribute>> enumToSynonymToEnumValueMap) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import com.google.common.collect.ImmutableMap;");
        _builder.newLine();
        _builder.append("import com.regnosys.rosetta.translate.SynonymToEnumMapBuilder;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.Optional;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        _builder.append(GENERATED_CLASS_NAME);
        _builder.append(" implements SynonymToEnumMapBuilder {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final Map<Class<?>, Map<String, Enum<?>>> synonymToEnumMap = ImmutableMap.<Class<?>, Map<String, Enum<?>>>builder()");
        _builder.newLine();
        Set<Map.Entry<RosettaEnumeration, Map<String, ExpandedAttribute>>> _entrySet = enumToSynonymToEnumValueMap.entrySet();
        for (Map.Entry<RosettaEnumeration, Map<String, ExpandedAttribute>> enumEntry : _entrySet) {
            boolean _isEmpty = enumEntry.getValue().isEmpty();
            boolean _not = !_isEmpty;
            if (!_not) continue;
            _builder.append("\t\t");
            String _name = enumEntry.getKey().getModel().getName();
            String _plus = _name + ".";
            String _name_1 = enumEntry.getKey().getName();
            String qualifiedEnumName = _plus + _name_1;
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append(".put(");
            _builder.append(qualifiedEnumName, "\t\t");
            _builder.append(".class, ImmutableMap.<String, Enum<?>>builder()");
            _builder.newLineIfNotEmpty();
            Set<Map.Entry<String, ExpandedAttribute>> _entrySet_1 = enumEntry.getValue().entrySet();
            for (Map.Entry<String, ExpandedAttribute> synonymToEnumValueEntry : _entrySet_1) {
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append(".put(\"");
                String _key = synonymToEnumValueEntry.getKey();
                _builder.append(_key, "\t\t\t");
                _builder.append("\", ");
                _builder.append(qualifiedEnumName, "\t\t\t");
                _builder.append(".");
                String _formatEnumName = EnumHelper.formatEnumName((String)synonymToEnumValueEntry.getValue().getName());
                _builder.append(_formatEnumName, "\t\t\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append(".build())");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append(".build();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Map<Class<?>, Map<String, Enum<?>>> getMap() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return synonymToEnumMap;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

