/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.util;

import com.google.common.base.MoreObjects;
import com.regnosys.ingest.test.framework.ingestor.RosettaIngestionException;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.path.RosettaPath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PathUtils {
    public static RosettaPath toHierarchicalPath(Path path) {
        List collect = path.getElements().stream().map(x -> RosettaPath.Element.create((String)x.getPathName(), (OptionalInt)PathUtils.toOptionalInt(x), (Map)x.getMetas())).collect(Collectors.toList());
        return RosettaPath.createPathFromElements(collect);
    }

    private static OptionalInt toOptionalInt(Path.PathElement x) {
        return x.getIndex().map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    public static List<Path> getExcludedPaths(String excludedPathsFile) {
        return Optional.ofNullable(excludedPathsFile).map(PathUtils::parseExcludedPathsFile).orElse(Collections.emptyList());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static List<Path> parseExcludedPathsFile(String excludedPathsFile) {
        ClassLoader loader = (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)PathUtils.class.getClassLoader());
        URL resource = loader.getResource(excludedPathsFile);
        if (resource == null) {
            return Collections.emptyList();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream()));){
            List<Path> list;
            block14: {
                Stream<String> stream = reader.lines();
                try {
                    list = stream.filter(s -> !s.isEmpty()).map(p -> Path.parse((String)p, (boolean)true)).collect(Collectors.toList());
                    if (stream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return list;
        }
        catch (IOException e) {
            throw new RosettaIngestionException(String.format("Unable to load excluded xml paths for resource %s", excludedPathsFile), e);
        }
    }
}

