/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.io.Resources;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.regnosys.ingest.test.framework.ingestor.AssertIngestion;
import com.regnosys.ingest.test.framework.ingestor.ExpectationUtil;
import com.regnosys.ingest.test.framework.ingestor.GeneratedIngestionParserMapper;
import com.regnosys.ingest.test.framework.ingestor.IngestionReport;
import com.regnosys.ingest.test.framework.ingestor.IngestionTestExpectation;
import com.regnosys.ingest.test.framework.ingestor.postprocess.PostProcessorRunner;
import com.regnosys.ingest.test.framework.ingestor.service.IngestionFactory;
import com.regnosys.ingest.test.framework.ingestor.service.IngestionService;
import com.regnosys.ingest.test.framework.ingestor.service.RosettaIngestionService;
import com.regnosys.ingest.test.framework.ingestor.service.TranslatorOptionsFactory;
import com.regnosys.ingest.test.framework.ingestor.testing.Expectation;
import com.regnosys.ingest.test.framework.util.MappingReportsSummaryWriter;
import com.regnosys.rosetta.RosettaRuntimeModule;
import com.regnosys.rosetta.RosettaStandaloneSetup;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationHandler;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationHandlerProvider;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import com.regnosys.rosetta.common.testing.MappingCoverage;
import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.common.validation.RosettaTypeValidator;
import com.regnosys.rosetta.translate.IngesterGenerator;
import com.regnosys.rosetta.translate.JsonHandlerFactory;
import com.regnosys.rosetta.translate.SynonymToEnumMapGenerator;
import com.regnosys.rosetta.translate.Translator;
import com.regnosys.rosetta.translate.TranslatorOptions;
import com.regnosys.rosetta.translate.XmlHandlerFactory;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.process.PostProcessStep;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.xtext.common.TerminalsStandaloneSetup;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IngestionTest<C extends RosettaModelObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IngestionTest.class);
    private static final Path INPUT_PATH = Path.of("cdm-sample-files", new String[0]);
    private static final Path OUTPUT_PATH = Path.of("result-json-files", new String[0]);
    protected static boolean writeActualExpectations = ExpectationUtil.WRITE_EXPECTATIONS;
    protected static Path tempDir;
    protected static boolean fails;
    protected static Multimap<String, IngestionTestExpectation> actualExpectation;
    protected static Injector injector;
    protected static List<PostProcessStep> postProcessors;
    protected static MappingReportsSummaryWriter mappingReportsSummaryWriter;
    protected final Path baseInputPath;
    protected final Path baseOutputPath;
    protected boolean testFail;

    public IngestionTest() {
        this(INPUT_PATH, OUTPUT_PATH);
    }

    public IngestionTest(Path path, Path path2) {
        this.baseInputPath = path;
        this.baseOutputPath = path2;
    }

    protected static void initialiseIngestionFactory(Module module, List<PostProcessStep> list) {
        IngestionTest.initialiseIngestionFactory(TranslatorOptionsFactory.getDefaultIngestionResource(IngestionTest.class.getClassLoader()), module, list);
    }

    protected static void initialiseIngestionFactory(Collection<URL> collection, Module module, List<PostProcessStep> list) {
        Module module2 = IngestionTest.setupRuntimeModules(module);
        postProcessors = list;
        IngestionFactory.init(collection, module2, list.toArray(new PostProcessStep[0]));
    }

    private static Module setupRuntimeModules(Module module) {
        TerminalsStandaloneSetup.doSetup();
        Module module2 = Modules.combine((Module[])new Module[]{module, new RosettaRuntimeModule()});
        injector = Guice.createInjector((Module[])new Module[]{module2});
        new RosettaStandaloneSetup().register(injector);
        return module2;
    }

    protected static void initialiseIngestionFactory(String string, Collection<URL> collection, Module module, List<PostProcessStep> list) {
        Module module2 = IngestionTest.setupRuntimeModules(module);
        postProcessors = list;
        IngestionFactory.init(string, collection, module2, list.toArray(new PostProcessStep[0]));
    }

    private static RosettaTypeValidator getRosettaTypeValidator() {
        return (RosettaTypeValidator)injector.getInstance(RosettaTypeValidator.class);
    }

    @BeforeAll
    static void beforeAll() {
        actualExpectation = ArrayListMultimap.create();
        mappingReportsSummaryWriter = new MappingReportsSummaryWriter();
        fails = false;
    }

    @BeforeAll
    static void createTempDir() {
        try {
            tempDir = Files.createTempDirectory("IngestionTest", new FileAttribute[0]);
            LOGGER.info("Writing JSON results file to tmp dir {}", (Object)tempDir.toFile().getAbsolutePath());
        }
        catch (IOException iOException) {
            LOGGER.debug("Cant create a temp directory - diffing will be disabled");
        }
    }

    @BeforeEach
    protected void setUp() {
        injector.injectMembers((Object)this);
    }

    @ParameterizedTest(name="{2}")
    @MethodSource(value={"fpMLFiles"})
    protected void ingest(String string, Expectation expectation, String string2) throws Throwable {
        this.testFail = true;
        System.out.println("---------------------- Running Test for file: " + expectation.getFileName() + " ----------------------");
        URL uRL = Resources.getResource((String)expectation.getFileName());
        IngestionReport<C> ingestionReport = null;
        String string3 = UrlUtils.getFileExtension((URL)uRL);
        if (string3.equals("xml")) {
            ingestionReport = this.ingestionService().ingestValidateAndPostProcess(this.getClazz(), UrlUtils.openURL((URL)uRL));
        } else if (string3.equals("json")) {
            ingestionReport = this.ingestionService().ingestAndPostProcessJson(this.getClazz(), UrlUtils.openURL((URL)uRL));
        } else {
            Assertions.fail((String)("Don't know how to process a file of this type " + expectation.getFileName()));
        }
        ingestionReport = this.postIngestIngestionReport(ingestionReport);
        String string4 = IngestionTest.toJson(ingestionReport.getRosettaModelInstance());
        LOGGER.debug(string4);
        actualExpectation.put((Object)string, (Object)new IngestionTestExpectation(string4, ExpectationUtil.actualExpectation(ingestionReport, expectation.getCategory(), expectation.getFileName(), expectation.getExcludedPaths())));
        Executable executable = this.assertJsonEquals(uRL, string4);
        mappingReportsSummaryWriter.capture(this.summaryDirPath(string, expectation), expectation.getFileName().toString(), ingestionReport.getMappingReport());
        executable.execute();
        this.assertExpectations(expectation, ingestionReport);
        this.testFail = false;
        System.out.println("-----------------------------------------------------------------");
        System.out.println();
    }

    protected C postIngest(C c) {
        return c;
    }

    protected IngestionReport<C> postIngestIngestionReport(IngestionReport<C> ingestionReport) {
        return new IngestionReport<RosettaModelObject>(ingestionReport.getMappingReport(), this.postIngest(ingestionReport.getRosettaModelInstance()), ingestionReport.getValidationReport(), ingestionReport.getQualificationReport(), ingestionReport.getInputValidation(), ingestionReport.getGenericErrorReport());
    }

    protected Executable assertJsonEquals(URL uRL, String string) {
        return () -> {
            String string2 = this.getExpectedJsonPath(uRL);
            String string3 = AssertIngestion.getExpectedJson(string2, this.getClass());
            if (string3 == null) {
                Assertions.fail((String)String.format("No json expectation found for path %s", string2));
            }
            AssertIngestion.assertJsonEquals(string3, string);
        };
    }

    protected String getExpectedJsonPath(URL uRL) {
        String string = UrlUtils.toPortableString((Path)UrlUtils.toPath((URL)uRL));
        String string2 = string.split(UrlUtils.toPortableString((Path)this.baseInputPath))[1].replace(".json", "_cdm.json").replace(".xml", ".json").substring(1);
        String string3 = "/" + UrlUtils.toPortableString((Path)this.baseOutputPath.resolve(string2));
        LOGGER.debug("Expected JSON path {}", (Object)string3);
        return string3;
    }

    protected void assertExpectations(Expectation expectation, IngestionReport<C> ingestionReport) throws JsonProcessingException {
        AssertIngestion.assertMapped(ingestionReport.getMappingReport(), expectation.getOutstandingMappings());
        AssertIngestion.assertValidated(ingestionReport.getValidationReport(), expectation.getValidationFailures());
        AssertIngestion.assertQualification(ingestionReport.getQualificationReport(), expectation.getQualificationExpectation());
        AssertIngestion.assertQualifiedNames(ingestionReport.getRosettaModelInstance(), ingestionReport.getQualificationReport(), expectation.getQualificationExpectation(), this.getQualificationHandlerMap());
        AssertIngestion.assertSerialisation(ingestionReport);
    }

    protected Map<Class<?>, QualificationHandler<?, ?, ?>> getQualificationHandlerMap() {
        return ((QualificationHandlerProvider)injector.getInstance(QualificationHandlerProvider.class)).getQualificationHandlerMap();
    }

    private String summaryDirPath(String string, Expectation expectation) {
        String string2 = expectation.getFileName().substring(0, expectation.getFileName().indexOf("/"));
        String string3 = string.substring(string.indexOf(string2) + string2.length() + 1, string.indexOf("/expectations.json")).replace("/", "-");
        return string3;
    }

    @AfterAll
    static void writeMappingReportsSummary() {
        try {
            Path path2 = ExpectationUtil.TEST_WRITE_BASE_PATH.filter(path -> Files.exists(path, new LinkOption[0])).map(path -> {
                Path path2 = path.resolve("mapping-analytics");
                try {
                    Files.createDirectories(path2, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                return path2;
            }).orElse(tempDir);
            mappingReportsSummaryWriter.writeSummaryCsvs(path2);
        }
        catch (IOException iOException) {
            System.err.println("Could not write CSV Mapping report, failed with error: " + iOException);
        }
    }

    protected abstract IngestionService ingestionService();

    protected abstract Class<C> getClazz();

    protected static Stream<Arguments> readExpectationsFromString(ImmutableList<String> immutableList) {
        return IngestionTest.readExpectationsFrom((ImmutableList<URL>)((ImmutableList)immutableList.stream().map(Resources::getResource).collect(ImmutableList.toImmutableList())));
    }

    protected static Stream<Arguments> readExpectationsFromPath(String string) {
        List list = ClassPathUtils.findPathsFromClassPath(List.of(string), (String)"expectations.json", Optional.empty(), (ClassLoader)IngestionTest.class.getClassLoader()).stream().map(UrlUtils::toUrl).collect(Collectors.toList());
        return IngestionTest.readExpectationsFrom((ImmutableList<URL>)ImmutableList.copyOf(list));
    }

    protected static Stream<Arguments> readExpectationsFrom(ImmutableList<URL> immutableList) {
        ObjectMapper objectMapper = new ObjectMapper();
        TypeReference<List<Expectation>> typeReference = new TypeReference<List<Expectation>>(){};
        return immutableList.stream().flatMap(arg_0 -> IngestionTest.lambda$readExpectationsFrom$4(objectMapper, (TypeReference)typeReference, arg_0));
    }

    protected static Stream<Expectation> readFile(URL uRL, ObjectMapper objectMapper, TypeReference<List<Expectation>> typeReference) {
        try {
            List list = (List)objectMapper.readValue(UrlUtils.openURL((URL)uRL), typeReference);
            return list.stream();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected static List<MappingCoverage> readCoverageFile(URL uRL, ObjectMapper objectMapper) {
        try {
            return (List)objectMapper.readValue(UrlUtils.openURL((URL)uRL), (TypeReference)new TypeReference<List<MappingCoverage>>(){});
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @AfterEach
    public void didItFail() {
        if (this.testFail) {
            fails = true;
        }
    }

    @AfterAll
    public static void printMetrics() {
        Slf4jReporter.forRegistry((MetricRegistry)IngestionService.INGESTION_METRICS).convertDurationsTo(TimeUnit.MILLISECONDS).build().report();
        Slf4jReporter.forRegistry((MetricRegistry)IngesterGenerator.GENERATOR_METRICS).convertDurationsTo(TimeUnit.MILLISECONDS).build().report();
    }

    @AfterAll
    static void printExpectations() throws IOException {
        ExpectationUtil.printExpectations(actualExpectation, writeActualExpectations);
    }

    protected static IngestionService getIngestionService(String string, final Module module, final Module module2, Class<?> clazz, boolean bl) {
        try {
            TranslatorOptions translatorOptions = IngestionFactory.getInstance().getTranslateOptions(string);
            Injector injector = new RosettaStandaloneSetup(){

                public Injector createInjector() {
                    return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{module}).with(new Module[]{module2})});
                }
            }.createInjectorAndDoEMFRegistration();
            IngesterGenerator ingesterGenerator = (IngesterGenerator)injector.getInstance(IngesterGenerator.class);
            SynonymToEnumMapGenerator synonymToEnumMapGenerator = (SynonymToEnumMapGenerator)injector.getInstance(SynonymToEnumMapGenerator.class);
            Translator.GeneratedClasses<XmlHandlerFactory> generatedClasses = new Translator(translatorOptions, clazz.getClassLoader(), ingesterGenerator, synonymToEnumMapGenerator).generateClassesFromXmlSchema(Paths.get("target/" + string, new String[0]), bl);
            GeneratedIngestionParserMapper generatedIngestionParserMapper = new GeneratedIngestionParserMapper(generatedClasses.getHandlerFactory(), generatedClasses.getSynonymToEnumMap(), translatorOptions.getXmlExclusionsFilePath(), translatorOptions.isJson(), translatorOptions.preProcessJson(), injector);
            PostProcessorRunner postProcessorRunner = new PostProcessorRunner(new ArrayList<PostProcessStep>(postProcessors));
            return new RosettaIngestionService(postProcessorRunner, generatedIngestionParserMapper, IngestionTest.getRosettaTypeValidator(), translatorOptions.getName());
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected static IngestionService getJsonIngestionService(String string, final Module module, final Module module2, Class<?> clazz, boolean bl) {
        try {
            TranslatorOptions translatorOptions = IngestionFactory.getInstance().getTranslateOptions(string);
            Injector injector = new RosettaStandaloneSetup(){

                public Injector createInjector() {
                    return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{module}).with(new Module[]{module2})});
                }
            }.createInjectorAndDoEMFRegistration();
            IngesterGenerator ingesterGenerator = (IngesterGenerator)injector.getInstance(IngesterGenerator.class);
            SynonymToEnumMapGenerator synonymToEnumMapGenerator = (SynonymToEnumMapGenerator)injector.getInstance(SynonymToEnumMapGenerator.class);
            ClassLoader classLoader = clazz.getClassLoader();
            Translator.GeneratedClasses<JsonHandlerFactory> generatedClasses = new Translator(translatorOptions, classLoader, ingesterGenerator, synonymToEnumMapGenerator).generateClassesFromJsonSchema(Paths.get("target/" + clazz.getSimpleName(), new String[0]), bl);
            GeneratedIngestionParserMapper generatedIngestionParserMapper = new GeneratedIngestionParserMapper(generatedClasses.getHandlerFactory(), generatedClasses.getSynonymToEnumMap(), translatorOptions.getXmlExclusionsFilePath(), translatorOptions.isJson(), translatorOptions.preProcessJson(), injector);
            return new RosettaIngestionService(new PostProcessorRunner(new ArrayList<PostProcessStep>(postProcessors)), generatedIngestionParserMapper, IngestionTest.getRosettaTypeValidator(), translatorOptions.getName());
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }

    static String toJson(Object object) throws JsonProcessingException {
        return RosettaObjectMapper.getNewRosettaObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(object);
    }

    @Test
    void ensureWriteActualExpectationIsFalse() {
        Assertions.assertFalse((boolean)writeActualExpectations);
    }

    private static /* synthetic */ Stream lambda$readExpectationsFrom$4(ObjectMapper objectMapper, TypeReference typeReference, URL uRL) {
        return IngestionTest.readFile(uRL, objectMapper, (TypeReference<List<Expectation>>)typeReference).map(expectation -> Arguments.of((Object[])new Object[]{uRL.getPath(), expectation, expectation.getFileName().substring(expectation.getFileName().lastIndexOf(47) + 1)}));
    }
}

