/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class MethodDefHandler
extends BlockParentHandler {
    public MethodDefHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, MethodDefHandler.getHandlerName(ast), ast, parent);
    }

    @Override
    protected DetailAST getTopLevelAst() {
        return null;
    }

    @Override
    protected void checkModifiers() {
        DetailAST modifier = this.getMainAst().findFirstToken(5);
        if (this.isOnStartOfLine(modifier) && !this.getIndent().isAcceptable(this.expandedTabsColumnNo(modifier))) {
            this.logError(modifier, "modifier", this.expandedTabsColumnNo(modifier));
        }
    }

    private void checkThrows() {
        DetailAST throwsAst = this.getMainAst().findFirstToken(81);
        if (throwsAst != null) {
            this.checkWrappingIndentation(throwsAst, throwsAst.getNextSibling(), this.getIndentCheck().getThrowsIndent(), this.getLineStart(MethodDefHandler.getMethodDefLineStart(this.getMainAst())), !this.isOnStartOfLine(throwsAst));
        }
    }

    private static int getMethodDefLineStart(DetailAST mainAst) {
        int lineStart = mainAst.findFirstToken(58).getLineNo();
        DetailAST typeNode = mainAst.findFirstToken(13);
        if (typeNode != null) {
            lineStart = MethodDefHandler.getFirstLine(typeNode);
        }
        for (DetailAST node = mainAst.findFirstToken(5).getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() == 159 || node.getLineNo() >= lineStart) continue;
            lineStart = node.getLineNo();
        }
        return lineStart;
    }

    @Override
    public void checkIndentation() {
        this.checkModifiers();
        this.checkThrows();
        if (MethodDefHandler.getMethodDefParamRightParen(this.getMainAst()) != null) {
            this.checkWrappingIndentation(this.getMainAst(), MethodDefHandler.getMethodDefParamRightParen(this.getMainAst()));
        }
        if (this.getLeftCurly() != null) {
            super.checkIndentation();
        }
    }

    private static DetailAST getMethodDefParamRightParen(DetailAST methodDefAst) {
        return methodDefAst.findFirstToken(77);
    }

    private static String getHandlerName(DetailAST ast) {
        String name;
        switch (ast.getType()) {
            case 8: {
                name = "ctor def";
                break;
            }
            case 161: {
                name = "annotation field def";
                break;
            }
            case 203: {
                name = "compact ctor def";
                break;
            }
            case 199: {
                name = "record def";
                break;
            }
            default: {
                name = "method def";
            }
        }
        return name;
    }
}

