/*
 * Decompiled with CFR 0.152.
 */
package com.pswidersk.gradle.python;

import com.pswidersk.gradle.python.ProgressLogger;
import com.pswidersk.gradle.python.ProgressObserver;
import com.pswidersk.gradle.python.PythonPluginExtension;
import com.pswidersk.gradle.python.PythonPluginUtilsKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.io.input.ObservableInputStream;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/pswidersk/gradle/python/CondaDownloadTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "pythonPlugin", "Lcom/pswidersk/gradle/python/PythonPluginExtension;", "progressLogger", "Lcom/pswidersk/gradle/python/ProgressLogger;", "setup", "", "downloadConda", "destinationFile", "Ljava/io/File;", "addBasicAuth", "connection", "Ljava/net/URLConnection;", "addCustomHeaders", "getExecutable", "python-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nCondaDownloadTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CondaDownloadTask.kt\ncom/pswidersk/gradle/python/CondaDownloadTask\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,74:1\n389#2,4:75\n216#3,2:79\n*S KotlinDebug\n*F\n+ 1 CondaDownloadTask.kt\ncom/pswidersk/gradle/python/CondaDownloadTask\n*L\n33#1:75,4\n55#1:79,2\n*E\n"})
public abstract class CondaDownloadTask
extends DefaultTask {
    @NotNull
    private final PythonPluginExtension pythonPlugin;
    @NotNull
    private final ProgressLogger progressLogger;

    public CondaDownloadTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.pythonPlugin = PythonPluginUtilsKt.getPythonPlugin(project);
        this.progressLogger = new ProgressLogger(arg_0 -> CondaDownloadTask.progressLogger$lambda$0(this, arg_0), 0, 2, null);
        this.setGroup("python");
        this.setDescription("Download " + this.pythonPlugin.getCondaInstaller().get());
        this.onlyIf(arg_0 -> CondaDownloadTask._init_$lambda$2(arg_0 -> CondaDownloadTask._init_$lambda$1(this, arg_0), arg_0));
    }

    @TaskAction
    public final void setup() {
        PythonPluginExtension $this$setup_u24lambda_u243 = this.pythonPlugin;
        boolean bl = false;
        RegularFile condaInstaller = (RegularFile)$this$setup_u24lambda_u243.getCondaInstallerFile$python_gradle_plugin().get();
        File file = condaInstaller.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        this.downloadConda(file);
    }

    private final void downloadConda(File destinationFile) {
        String string;
        block1: {
            Object object = this.pythonPlugin.getCondaRepoUrl().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String $this$dropLastWhile$iv = (String)object;
            boolean $i$f$dropLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$dropLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '/') continue;
                String string2 = $this$dropLastWhile$iv;
                int n = 0;
                int n2 = index$iv + 1;
                String string3 = string2.substring(n, n2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = "";
        }
        String condaRepoUrl = string;
        String condaInstaller = (String)this.pythonPlugin.getCondaInstaller().get();
        this.getLogger().lifecycle("Downloading " + condaInstaller + " to: " + destinationFile.getCanonicalPath() + " from: " + condaRepoUrl + " (please wait, it can take a while)");
        URLConnection connection = URI.create(condaRepoUrl + "/" + destinationFile.getName()).toURL().openConnection();
        Intrinsics.checkNotNull((Object)connection);
        this.addBasicAuth(connection);
        this.addCustomHeaders(connection);
        this.getExecutable(connection, destinationFile);
    }

    private final void addBasicAuth(URLConnection connection) {
        if (this.pythonPlugin.getCondaRepoUsername().isPresent()) {
            String condaRepoUsername = (String)this.pythonPlugin.getCondaRepoUsername().get();
            String condaRepoPassword = (String)this.pythonPlugin.getCondaRepoPassword().get();
            this.getLogger().lifecycle("Adding basic authorization headers for '" + condaRepoUsername + "' user.");
            String userAndPass = condaRepoUsername + ":" + condaRepoPassword;
            Base64.Encoder encoder = Base64.getEncoder();
            String string = userAndPass;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] byArray2 = encoder.encode(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(...)");
            byte[] byArray3 = byArray2;
            String basicAuth = "Basic " + new String(byArray3, Charsets.UTF_8);
            connection.setRequestProperty("Authorization", basicAuth);
        }
    }

    private final void addCustomHeaders(URLConnection connection) {
        Map condaRepoHeaders = (Map)this.pythonPlugin.getCondaRepoHeaders().get();
        Intrinsics.checkNotNull((Object)condaRepoHeaders);
        Map $this$forEach$iv = condaRepoHeaders;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            connection.addRequestProperty((String)it.getKey(), (String)it.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getExecutable(URLConnection connection, File destinationFile) {
        ProgressObserver progressObserver = new ProgressObserver(this.progressLogger, connection, 0, 4, null);
        ObservableInputStream.Observer[] observerArray = connection.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)observerArray, (String)"getInputStream(...)");
        Object object = observerArray;
        int n = 8192;
        BufferedInputStream bufferedInputStream = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
        object = new ObservableInputStream.Observer[]{progressObserver};
        ObservableInputStream urlInputStream = new ObservableInputStream((InputStream)bufferedInputStream, object);
        object = (Closeable)urlInputStream;
        Throwable throwable = null;
        try {
            long l;
            ObservableInputStream input = (ObservableInputStream)object;
            boolean bl = false;
            Closeable closeable = new FileOutputStream(destinationFile);
            Throwable throwable2 = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable;
                boolean bl2 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)((InputStream)input), (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        boolean res = destinationFile.setExecutable(true);
        if (!res) {
            this.getLogger().warn("Conda exec file could not be changed to executable.");
        }
    }

    private static final Unit progressLogger$lambda$0(CondaDownloadTask this$0, String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this$0.getLogger().lifecycle(msg);
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$1(CondaDownloadTask this$0, Task it) {
        return !((Directory)this$0.pythonPlugin.getCondaBinDir$python_gradle_plugin().get()).getAsFile().exists();
    }

    private static final boolean _init_$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

