/*
 * Decompiled with CFR 0.152.
 */
package com.paulhammant.ngwebdriver;

import com.paulhammant.ngwebdriver.ByAngular;
import com.paulhammant.ngwebdriver.VariableNotInScopeException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;

public class NgWebDriver {
    public static final String DEFAULT_ROOT_SELECTOR = "[ng-app]";
    private String rootSelector;
    private JavascriptExecutor driver;

    public NgWebDriver(JavascriptExecutor driver) {
        this.driver = driver;
        this.withRootSelector(DEFAULT_ROOT_SELECTOR);
    }

    public NgWebDriver withRootSelector(String rootSelector) {
        this.rootSelector = rootSelector;
        return this;
    }

    public ByAngular.Factory makeByAngularFactory() {
        return ByAngular.withRootSelector(this.rootSelector);
    }

    public void mutate(WebElement element, String variable, String value) {
        this.driver.executeScript("angular.element(arguments[0]).scope()." + variable + " = " + value + ";var root = document.querySelector('" + this.rootSelector + "');angular.element(root).injector().get('$rootScope').$apply();", new Object[]{element});
    }

    public String retrieveJson(WebElement element, String variable) {
        return (String)this.check(variable, this.driver.executeScript("return angular.toJson(angular.element(arguments[0]).scope()." + variable + ");", new Object[]{element}));
    }

    private Object check(String variable, Object o) {
        if (o == null) {
            throw new VariableNotInScopeException("$scope variable '" + variable + "' not found in same scope as the element passed in.");
        }
        return o;
    }

    public Object retrieve(WebElement element, String variable) {
        return this.check(variable, this.driver.executeScript("return angular.element(arguments[0]).scope()." + variable + ";", new Object[]{element}));
    }

    public String retrieveAsString(WebElement element, String variable) {
        return this.retrieve(element, variable).toString();
    }

    public Long retrieveAsLong(WebElement element, String variable) {
        Object rv = this.retrieve(element, variable);
        if (rv instanceof Double) {
            return ((Double)rv).longValue();
        }
        return (Long)rv;
    }

    public void waitForAngularRequestsToFinish() {
        this.driver.executeAsyncScript("var callback = arguments[arguments.length - 1];\nvar rootSelector = '" + this.rootSelector + "';\n\n" + ByAngular.functions.get("waitForAngular"), new Object[0]);
    }

    public void waitForAngular2RequestsToFinish() {
        this.driver.executeAsyncScript("var callback = arguments[arguments.length - 1];\n\n" + ByAngular.functions.get("waitForAllAngular2"), new Object[0]);
    }

    public String getLocationAbsUrl() {
        return (String)this.driver.executeScript("var selector = '" + this.rootSelector + "';\n\n" + ByAngular.functions.get("getLocationAbsUrl"), new Object[0]);
    }

    public Object evaluateScript(WebElement element, String script) {
        script = script.replace("$scope", "angular.element(arguments[0]).scope()");
        return this.driver.executeScript(script, new Object[]{element});
    }
}

