/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.secrets.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class GetSecretBundleRequest
extends BmcRequest<Void> {
    private String secretId;
    private String opcRequestId;
    private Long versionNumber;
    private String secretVersionName;
    private Stage stage;

    @ConstructorProperties(value={"secretId", "opcRequestId", "versionNumber", "secretVersionName", "stage"})
    GetSecretBundleRequest(String secretId, String opcRequestId, Long versionNumber, String secretVersionName, Stage stage) {
        this.secretId = secretId;
        this.opcRequestId = opcRequestId;
        this.versionNumber = versionNumber;
        this.secretVersionName = secretVersionName;
        this.stage = stage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getSecretVersionName() {
        return this.secretVersionName;
    }

    public Stage getStage() {
        return this.stage;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSecretBundleRequest, Void> {
        private String secretId;
        private String opcRequestId;
        private Long versionNumber;
        private String secretVersionName;
        private Stage stage;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSecretBundleRequest o) {
            this.secretId(o.getSecretId());
            this.opcRequestId(o.getOpcRequestId());
            this.versionNumber(o.getVersionNumber());
            this.secretVersionName(o.getSecretVersionName());
            this.stage(o.getStage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSecretBundleRequest build() {
            GetSecretBundleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public Builder secretVersionName(String secretVersionName) {
            this.secretVersionName = secretVersionName;
            return this;
        }

        public Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        public GetSecretBundleRequest buildWithoutInvocationCallback() {
            return new GetSecretBundleRequest(this.secretId, this.opcRequestId, this.versionNumber, this.secretVersionName, this.stage);
        }

        public String toString() {
            return "GetSecretBundleRequest.Builder(secretId=" + this.secretId + ", opcRequestId=" + this.opcRequestId + ", versionNumber=" + this.versionNumber + ", secretVersionName=" + this.secretVersionName + ", stage=" + (Object)((Object)this.stage) + ")";
        }
    }

    public static enum Stage {
        Current("CURRENT"),
        Pending("PENDING"),
        Latest("LATEST"),
        Previous("PREVIOUS"),
        Deprecated("DEPRECATED");

        private final String value;
        private static Map<String, Stage> map;

        private Stage(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Stage create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Stage: " + key);
        }

        static {
            map = new HashMap<String, Stage>();
            for (Stage v : Stage.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

