/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waiter;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.oracle.bmc.waiter.WaiterConfiguration;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericWaiter {
    private static final Logger LOG = LoggerFactory.getLogger(GenericWaiter.class);
    private final WaiterConfiguration waiterConfiguration;

    public <REQUEST, RESPONSE> Optional<RESPONSE> execute(Supplier<REQUEST> requestSupplier, Function<REQUEST, RESPONSE> functionCall, Predicate<RESPONSE> terminationPredicate) {
        WaiterConfiguration.WaitContext context = new WaiterConfiguration.WaitContext(System.currentTimeMillis());
        Object r = null;
        while (true) {
            LOG.debug("Invoking function call");
            r = functionCall.apply(requestSupplier.get());
            if (terminationPredicate.apply(r)) {
                return Optional.of((Object)r);
            }
            context.incrementAttempts();
            context.setCurrentTime(System.currentTimeMillis());
            if (this.waiterConfiguration.getTerminationStrategy().shouldTerminate(context)) break;
            try {
                long sleepTime = this.waiterConfiguration.getDelayStrategy().nextDelay(context);
                LOG.debug("Sleeping for {}ms, context at: {}", (Object)sleepTime, (Object)context);
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                LOG.info("Waiter interrupted");
                Thread.currentThread().interrupt();
                return Optional.absent();
            }
        }
        LOG.debug("Termination strategy decided to terminate with context at: {}", (Object)context);
        return Optional.absent();
    }

    @ConstructorProperties(value={"waiterConfiguration"})
    public GenericWaiter(WaiterConfiguration waiterConfiguration) {
        this.waiterConfiguration = waiterConfiguration;
    }
}

