/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.io.internal;

import com.oracle.bmc.http.internal.ResponseHelper;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import lombok.NonNull;

public class WrappedResponseInputStream
extends InputStream {
    protected final InputStream delegate;
    protected final Response delegateResponse;

    public WrappedResponseInputStream(@NonNull InputStream delegate, @NonNull Response delegateResponse) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked @NonNull but is null");
        }
        if (delegateResponse == null) {
            throw new NullPointerException("delegateResponse is marked @NonNull but is null");
        }
        this.delegate = delegate;
        this.delegateResponse = delegateResponse;
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.delegate.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        finally {
            ResponseHelper.closeResponseSilently(this.delegateResponse);
        }
    }
}

