/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.xml.jaxp.JXXMLFilter;
import oracle.xml.parser.schema.JXSchema;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xslt.XSLDocumentBuilder;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class JXSchemaFactory
extends SchemaFactory {
    XSDBuilder builder;
    ErrorHandler errHandler;
    LSResourceResolver resolver;
    private boolean isSecure;

    public JXSchemaFactory() {
        try {
            this.builder = new XSDBuilder();
        }
        catch (XSDException xSDException) {
            // empty catch block
        }
    }

    @Override
    public boolean isSchemaLanguageSupported(String string) {
        return string.equals("http://www.w3.org/2001/XMLSchema");
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException("the name parameter is null");
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.isSecure;
        }
        throw new SAXNotRecognizedException(string);
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException("the name parameter is null");
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.isSecure = true;
            if (this.isSecure) {
                this.builder.setSecureProcessing();
            }
        } else {
            throw new SAXNotRecognizedException(string);
        }
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(string);
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(string);
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    @Override
    public void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.resolver = lSResourceResolver;
    }

    @Override
    public LSResourceResolver getResourceResolver() {
        return this.resolver;
    }

    @Override
    public Schema newSchema(Source source) throws SAXException {
        return this.newSchema(new Source[]{source});
    }

    @Override
    public Schema newSchema(File file) throws SAXException {
        return this.newSchema(new StreamSource(file));
    }

    @Override
    public Schema newSchema(URL uRL) throws SAXException {
        return this.newSchema(new StreamSource(uRL.toExternalForm()));
    }

    @Override
    public Schema newSchema(Source[] sourceArray) throws SAXException {
        int n = sourceArray.length;
        XMLNode[] xMLNodeArray = new XMLNode[n];
        XMLDocument xMLDocument = new XMLDocument();
        XMLSchema xMLSchema = null;
        for (int i = 0; i < n; ++i) {
            Object object;
            Source source = sourceArray[i];
            String string = source.getSystemId();
            URL uRL = null;
            if (source instanceof DOMSource) {
                object = ((DOMSource)source).getNode();
                xMLNodeArray[i] = object instanceof XMLNode ? (XMLNode)object : (XMLNode)xMLDocument.importNode((Node)object, true);
            } else {
                object = null;
                InputSource inputSource = SAXSource.sourceToInputSource(source);
                DocumentBuilder documentBuilder = null;
                if (source instanceof SAXSource) {
                    object = ((SAXSource)source).getXMLReader();
                }
                if (object == null) {
                    object = new SAXParser();
                }
                if (object instanceof SAXParser && string != null) {
                    try {
                        uRL = new URL(string);
                        ((SAXParser)object).setBaseURL(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new SAXException(malformedURLException.getMessage());
                    }
                }
                try {
                    documentBuilder = object instanceof JXXMLFilter ? new XSLDocumentBuilder() : new DocumentBuilder();
                    object.setContentHandler(documentBuilder);
                    if (object instanceof SAXParser) {
                        ((SAXParser)object).setLexHandler(documentBuilder);
                    }
                    object.parse(inputSource);
                }
                catch (Exception exception) {
                    throw new SAXException(exception.getMessage());
                }
                xMLNodeArray[i] = object instanceof JXXMLFilter ? ((XSLDocumentBuilder)documentBuilder).getResultFragment() : documentBuilder.getDocument();
            }
            try {
                short s = xMLNodeArray[i].getNodeType();
                if (s == 9) {
                    xMLSchema = this.builder.build((XMLDocument)xMLNodeArray[i], string);
                    continue;
                }
                if (s == 1) {
                    xMLSchema = this.builder.build((XMLElement)xMLNodeArray[i], string);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            catch (Exception exception) {
                throw new SAXException(exception.getMessage());
            }
        }
        return new JXSchema(xMLSchema);
    }

    @Override
    public Schema newSchema() throws SAXException {
        return new JXSchema();
    }
}

