/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.sql.BLOB;
import oracle.xml.scalable.AbstractPageManager;
import oracle.xml.scalable.PageManager;

public class BlobPageManager
extends AbstractPageManager {
    BLOB blob;
    long blobOffset;

    public BlobPageManager(Connection connection) throws SQLException {
        this.blob = BLOB.createTemporary((Connection)connection, (boolean)true, (int)12);
        this.blob.open(1);
        this.init();
    }

    @Override
    public void seek(long l) throws IOException {
        this.blobOffset = l;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            int n3 = n2;
            InputStream inputStream = this.blob.getBinaryStream(this.blobOffset);
            while (n3 > 0) {
                int n4 = inputStream.read(byArray, n, n3);
                if (n4 == -1) {
                    return n2 - n3;
                }
                this.blobOffset += (long)n4;
                n3 -= n4;
                n += n4;
            }
            inputStream.close();
            return n2;
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException(sQLException.getMessage());
            iOException.initCause(sQLException);
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            OutputStream outputStream = this.blob.setBinaryStream(this.blobOffset);
            outputStream.write(byArray, n, n2);
            this.blobOffset += (long)n2;
            outputStream.close();
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException(sQLException.getMessage());
            iOException.initCause(sQLException);
            throw iOException;
        }
    }

    @Override
    public void deletePage(PageManager.PageId pageId) {
        long l = this.lastOffset;
        super.deletePage(pageId);
        try {
            if (l != this.lastOffset) {
                this.blob.truncate(this.lastOffset);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this.blob.close();
            BLOB.freeTemporary((BLOB)this.blob);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

