/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxp;

import java.io.IOException;
import java.io.InputStream;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class JXSAXParser
extends javax.xml.parsers.SAXParser {
    private SAXParser saxParser = new SAXParser();

    JXSAXParser() {
    }

    public Parser getParser() throws SAXException {
        return this.saxParser;
    }

    public XMLReader getXMLReader() throws SAXException {
        return this.saxParser;
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public boolean isValidating() {
        return this.saxParser.getValidationMode();
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("oracle.xdkjava.security.entityExpansionCountLimit")) {
            this.saxParser.setProperty(string, object);
        } else if (this.isValidating() || !string.equals("http://java.sun.com/xml/jaxp/properties/schemaLanguage") && !string.equals("http://java.sun.com/xml/jaxp/properties/schemaSource")) {
            this.saxParser.setProperty(string, object);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.saxParser.getProperty(string);
    }

    SAXParser getSAXParser() {
        return this.saxParser;
    }

    public void parse(InputStream inputStream, HandlerBase handlerBase, String string) throws SAXException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        int n = inputStream.available();
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        this.parse(inputSource, handlerBase);
    }

    public void parse(InputStream inputStream, DefaultHandler defaultHandler) throws SAXException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        int n = inputStream.available();
        InputSource inputSource = new InputSource(inputStream);
        this.parse(inputSource, defaultHandler);
    }

    public void parse(InputStream inputStream, DefaultHandler defaultHandler, String string) throws SAXException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        int n = inputStream.available();
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        this.parse(inputSource, defaultHandler);
    }

    public void parse(InputSource inputSource, DefaultHandler defaultHandler) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            int n = inputStream.available();
        }
        XMLReader xMLReader = this.getXMLReader();
        if (defaultHandler != null) {
            xMLReader.setContentHandler(defaultHandler);
            xMLReader.setEntityResolver(defaultHandler);
            xMLReader.setErrorHandler(defaultHandler);
            xMLReader.setDTDHandler(defaultHandler);
        }
        xMLReader.parse(inputSource);
    }
}

