/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Logger;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;

abstract class PhasedPublisher<T>
implements Flow.Publisher<T> {
    private final Phaser publishingPhaser;
    private final AtomicInteger nextPhaseDeregistrations = new AtomicInteger(0);
    private final TerminalAction terminalAction;
    private final CompletableFuture<Void> terminalFuture = new CompletableFuture();
    private final Executor executor;
    private final ConcurrentHashMap<Flow.Subscriber<?>, PhasedSubscription> subscriptions = new ConcurrentHashMap();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    protected PhasedPublisher(Executor executor, TerminalAction terminalAction) {
        this.executor = executor;
        this.terminalAction = terminalAction == null ? () -> {} : terminalAction;
        this.publishingPhaser = new PublishingPhaser();
    }

    private final void deregisterAfterArrivedPhase(int n2) {
        int n3 = this.publishingPhaser.register();
        if (n3 > n2) {
            this.publishingPhaser.awaitAdvance(n2);
            this.publishingPhaser.arriveAndDeregister();
        } else {
            this.nextPhaseDeregistrations.incrementAndGet();
        }
        this.publishingPhaser.arriveAndDeregister();
    }

    private final void executeNextPhaseDeregistrations(int n2) {
        int n3 = this.nextPhaseDeregistrations.getAndSet(0);
        if (n3 != 0) {
            this.executor.execute(() -> {
                this.publishingPhaser.awaitAdvance(n2);
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.publishingPhaser.arriveAndDeregister();
                }
            });
        }
    }

    protected void handleOnNext(T t2, Consumer<? super T> consumer) {
        consumer.accept(t2);
    }

    protected abstract CompletionStage<T> advancePhaseAsync();

    private final void handlePhaseAdvancement(T t2, Throwable throwable) {
        if (throwable != null) {
            this.endPublishing(CompletionStageUtil.unwrapCompletionException(throwable));
        } else if (t2 != null) {
            for (PhasedSubscription phasedSubscription : this.subscriptions.values()) {
                this.executor.execute(() -> phasedSubscription.emitNextItem(t2));
            }
        } else {
            this.endPublishing(null);
        }
    }

    private final void endPublishing(Throwable throwable) {
        this.publishingPhaser.forceTermination();
        try {
            this.terminalAction.run();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            }
            throwable.addSuppressed(throwable2);
        }
        if (throwable == null) {
            this.terminalFuture.complete(null);
        } else {
            this.terminalFuture.completeExceptionally(throwable);
        }
    }

    @Override
    public final void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber);
        PhasedSubscription phasedSubscription = new PhasedSubscription(subscriber);
        PhasedSubscription phasedSubscription2 = this.subscriptions.putIfAbsent(subscriber, phasedSubscription);
        if (phasedSubscription2 != null) {
            phasedSubscription2.emitError(new IllegalStateException("Subscriber argument to subscribe(Subscriber) is already subscribed"));
        } else {
            this.publishingPhaser.register();
            try (Monitor.CloseableLock closeableLock = phasedSubscription.monitor.acquireCloseableLock();){
                subscriber.onSubscribe(phasedSubscription);
                this.terminalFuture.whenCompleteAsync((void_, throwable) -> {
                    if (throwable == null) {
                        phasedSubscription.emitComplete();
                    } else {
                        phasedSubscription.emitError((Throwable)throwable);
                    }
                }, this.executor);
            }
            catch (Throwable throwable2) {
                phasedSubscription.cancel();
            }
        }
    }

    static {
        try {
            $$$methodRef$$$10 = PhasedPublisher.class.getDeclaredConstructor(Executor.class, TerminalAction.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = PhasedPublisher.class.getDeclaredMethod("lambda$new$0", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = PhasedPublisher.class.getDeclaredMethod("lambda$executeNextPhaseDeregistrations$1", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = PhasedPublisher.class.getDeclaredMethod("lambda$handlePhaseAdvancement$2", PhasedSubscription.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = PhasedPublisher.class.getDeclaredMethod("lambda$subscribe$3", PhasedSubscription.class, Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = PhasedPublisher.class.getDeclaredMethod("subscribe", Flow.Subscriber.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = PhasedPublisher.class.getDeclaredMethod("endPublishing", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = PhasedPublisher.class.getDeclaredMethod("handlePhaseAdvancement", Object.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = PhasedPublisher.class.getDeclaredMethod("handleOnNext", Object.class, Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = PhasedPublisher.class.getDeclaredMethod("executeNextPhaseDeregistrations", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = PhasedPublisher.class.getDeclaredMethod("deregisterAfterArrivedPhase", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    @FunctionalInterface
    static interface TerminalAction {
        public void run() throws Exception;
    }

    private class PhasedSubscription
    implements Flow.Subscription {
        private final Monitor monitor = Monitor.newInstance();
        private final Flow.Subscriber<? super T> proxiedSubscriber;
        private boolean isCancelled = false;
        private int lastArrivedPhase = -1;
        private long demand = 0L;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;

        private PhasedSubscription(Flow.Subscriber<? super T> subscriber) {
            this.proxiedSubscriber = subscriber;
        }

        private final void emitNextItem(T t2) {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                PhasedPublisher.this.handleOnNext(t2, object -> {
                    try {
                        this.proxiedSubscriber.onNext(object);
                    }
                    catch (Throwable throwable) {
                        this.cancel();
                    }
                });
                this.decrementDemand();
                if (this.demand > 0L) {
                    this.arriveForNextPhase();
                }
            }
        }

        private final void emitError(Throwable throwable) {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                this.cancel();
                try {
                    this.proxiedSubscriber.onError(throwable);
                }
                catch (Throwable throwable2) {
                }
            }
        }

        private final void emitComplete() {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                this.cancel();
                try {
                    this.proxiedSubscriber.onComplete();
                }
                catch (Throwable throwable) {
                }
            }
        }

        @Override
        public final void cancel() {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                this.isCancelled = true;
                this.demand = Long.MIN_VALUE;
                PhasedPublisher.this.subscriptions.remove(this.proxiedSubscriber);
                PhasedPublisher.this.deregisterAfterArrivedPhase(this.lastArrivedPhase);
            }
        }

        @Override
        public final void request(long l2) {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                if (l2 < 1L) {
                    this.emitError(new IllegalArgumentException("Received a negative subscription request. Argument to request(long) was: " + l2));
                    return;
                }
                boolean bl = this.demand == 0L;
                this.increaseDemand(l2);
                if (bl) {
                    this.arriveForNextPhase();
                }
            }
        }

        private final void increaseDemand(long l2) {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.demand != Long.MAX_VALUE && this.demand != Long.MIN_VALUE) {
                    long l3 = this.demand + l2;
                    this.demand = l3 < 0L ? Long.MAX_VALUE : l3;
                }
            }
        }

        private final void decrementDemand() {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.demand != Long.MAX_VALUE && this.demand != Long.MIN_VALUE) {
                    --this.demand;
                }
            }
        }

        private void arriveForNextPhase() {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                PhasedPublisher.this.publishingPhaser.awaitAdvance(this.lastArrivedPhase);
                this.lastArrivedPhase = PhasedPublisher.this.publishingPhaser.arrive();
            }
        }

        static {
            try {
                $$$methodRef$$$9 = PhasedSubscription.class.getDeclaredConstructor(PhasedPublisher.class, Flow.Subscriber.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = PhasedSubscription.class.getDeclaredMethod("lambda$emitNextItem$0", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = PhasedSubscription.class.getDeclaredMethod("arriveForNextPhase", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = PhasedSubscription.class.getDeclaredMethod("decrementDemand", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = PhasedSubscription.class.getDeclaredMethod("increaseDemand", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = PhasedSubscription.class.getDeclaredMethod("request", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = PhasedSubscription.class.getDeclaredMethod("cancel", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = PhasedSubscription.class.getDeclaredMethod("emitComplete", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = PhasedSubscription.class.getDeclaredMethod("emitError", Throwable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = PhasedSubscription.class.getDeclaredMethod("emitNextItem", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private final class PublishingPhaser
    extends Phaser {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private PublishingPhaser() {
        }

        @Override
        protected final boolean onAdvance(int n2, int n3) {
            if (n3 == 0) {
                PhasedPublisher.this.endPublishing(null);
            } else {
                PhasedPublisher.this.executor.execute(() -> PhasedPublisher.this.advancePhaseAsync().whenComplete((object, throwable) -> PhasedPublisher.this.handlePhaseAdvancement(object, (Throwable)throwable)));
            }
            PhasedPublisher.this.executeNextPhaseDeregistrations(n2);
            return false;
        }

        static {
            try {
                $$$methodRef$$$3 = PublishingPhaser.class.getDeclaredConstructor(PhasedPublisher.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = PublishingPhaser.class.getDeclaredMethod("lambda$onAdvance$0", Object.class, Throwable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = PublishingPhaser.class.getDeclaredMethod("lambda$onAdvance$1", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = PublishingPhaser.class.getDeclaredMethod("onAdvance", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

