/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.logging.Logger;
import oracle.jdbc.driver.BufferedPublisher;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;

abstract class LobSegmentSubscriber<T>
implements Flow.Subscriber<T> {
    private final Monitor signalMonitor = Monitor.newInstance();
    private final LobSegmentBuffer<T> buffer;
    private final BufferedPublisher<Long> outcomePublisher;
    private final Runnable terminalAction;
    private final Executor userCodeExecutor;
    private Flow.Subscription subscription;
    private boolean isTerminated = false;
    private volatile CompletionStage<Void> pushSegmentStage = CompletableFuture.completedFuture(null);
    static final Flow.Subscriber<Long> NO_OUTCOME_SUBSCRIBER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;

    LobSegmentSubscriber(LobSegmentBuffer<T> lobSegmentBuffer, Flow.Subscriber<Long> subscriber, Runnable runnable, Executor executor) {
        this.userCodeExecutor = executor;
        this.buffer = lobSegmentBuffer;
        if (subscriber == NO_OUTCOME_SUBSCRIBER) {
            this.outcomePublisher = null;
        } else {
            this.outcomePublisher = BufferedPublisher.newInstance(Flow.defaultBufferSize(), executor);
            this.outcomePublisher.subscribe(subscriber);
        }
        this.terminalAction = runnable;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        Objects.requireNonNull(subscription);
        try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
            if (this.subscription != null) {
                subscription.cancel();
                if (subscription.equals(this.subscription)) {
                    this.cancelSubscription();
                }
                return;
            }
            this.subscription = subscription;
            this.userCodeExecutor.execute(() -> subscription.request(1L));
        }
    }

    @Override
    public final void onNext(T t2) {
        Objects.requireNonNull(t2);
        try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
            if (this.isTerminated) {
                return;
            }
            this.pushSegmentStage = this.pushSegment(t2, 0).thenAccept(void_ -> {
                if (!this.isTerminated) {
                    this.userCodeExecutor.execute(() -> this.subscription.request(1L));
                }
            });
        }
    }

    private final CompletionStage<Void> pushSegment(T t2, int n2) {
        int n3 = this.buffer.putSegment(t2, n2);
        int n4 = this.buffer.getSegmentLength(t2) - (n2 + n3);
        if (n4 == 0) {
            return CompletionStageUtil.VOID_COMPLETED_FUTURE;
        }
        return this.flushBufferAsync(true).thenCompose(void_ -> this.pushSegment(t2, n2 + n3));
    }

    @Override
    public final void onComplete() {
        try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
            if (this.isTerminated) {
                return;
            }
            this.isTerminated = true;
            this.pushSegmentStage = this.pushSegmentStage.thenCompose(void_ -> {
                if (this.buffer.getPosition() > 0) {
                    return this.flushBufferAsync(false);
                }
                return CompletionStageUtil.VOID_COMPLETED_FUTURE;
            }).whenComplete((void_, throwable) -> {
                if (throwable == null && this.outcomePublisher != null) {
                    this.outcomePublisher.terminate(null);
                }
                this.terminalAction.run();
            });
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        Objects.requireNonNull(throwable);
        try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
            if (this.isTerminated) {
                return;
            }
            this.isTerminated = true;
            this.pushSegmentStage.whenComplete((void_, throwable2) -> {
                this.terminalAction.run();
                if (this.outcomePublisher != null && throwable2 == null) {
                    this.outcomePublisher.terminate(DatabaseError.createSqlException(null, 1713, null, throwable).fillInStackTrace());
                }
            });
        }
    }

    private final void cancelSubscription() {
        try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
            this.userCodeExecutor.execute(this.subscription::cancel);
            if (!this.isTerminated) {
                this.isTerminated = true;
                this.terminalAction.run();
            }
        }
    }

    private final CompletionStage<Void> flushBufferAsync(boolean bl) {
        int n2 = this.buffer.getPosition();
        CompletionStage<Void> completionStage = this.flushBufferAsync(n2).whenComplete((void_, throwable) -> {
            if (throwable == null) {
                this.buffer.reset();
            } else {
                this.cancelSubscription();
                if (this.outcomePublisher != null) {
                    this.outcomePublisher.terminate(CompletionStageUtil.unwrapCompletionException(throwable));
                }
            }
        });
        if (this.outcomePublisher != null) {
            CompletionStage<Void> completionStage2 = completionStage.thenCompose(void_ -> this.outcomePublisher.offerItem(Long.valueOf(n2)));
            if (bl) {
                return completionStage2;
            }
        }
        return completionStage;
    }

    abstract CompletionStage<Void> flushBufferAsync(int var1);

    static {
        try {
            $$$methodRef$$$16 = LobSegmentSubscriber.class.getDeclaredConstructor(LobSegmentBuffer.class, Flow.Subscriber.class, Runnable.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$onSubscribe$0", Flow.Subscription.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$onNext$1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$onNext$2", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$pushSegment$3", Object.class, Integer.TYPE, Integer.TYPE, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$onComplete$4", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$onComplete$5", Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$onError$6", Throwable.class, Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$flushBufferAsync$7", Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LobSegmentSubscriber.class.getDeclaredMethod("lambda$flushBufferAsync$8", Integer.TYPE, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LobSegmentSubscriber.class.getDeclaredMethod("flushBufferAsync", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LobSegmentSubscriber.class.getDeclaredMethod("cancelSubscription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LobSegmentSubscriber.class.getDeclaredMethod("onError", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LobSegmentSubscriber.class.getDeclaredMethod("onComplete", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LobSegmentSubscriber.class.getDeclaredMethod("pushSegment", Object.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LobSegmentSubscriber.class.getDeclaredMethod("onNext", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LobSegmentSubscriber.class.getDeclaredMethod("onSubscribe", Flow.Subscription.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NO_OUTCOME_SUBSCRIBER = new Flow.Subscriber<Long>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
            }

            @Override
            public void onNext(Long l2) {
            }

            @Override
            public void onError(Throwable throwable) {
            }

            @Override
            public void onComplete() {
            }

            static {
                try {
                    $$$methodRef$$$5 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$4 = 1.class.getDeclaredMethod("onNext", Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredMethod("onComplete", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("onError", Throwable.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("onNext", Long.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("onSubscribe", Flow.Subscription.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }

    static abstract class LobSegmentBuffer<T> {
        private volatile int position = 0;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        LobSegmentBuffer() {
        }

        static LobSegmentBuffer<byte[]> newByteBuffer(final byte[] byArray) {
            return new LobSegmentBuffer<byte[]>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;
                private static Executable $$$methodRef$$$3;
                private static Logger $$$loggerRef$$$3;
                private static Executable $$$methodRef$$$4;
                private static Logger $$$loggerRef$$$4;

                @Override
                protected int copyToBuffer(byte[] byArray2, int n2, int n3) {
                    int n4 = Math.min(byArray.length - n3, byArray2.length - n2);
                    System.arraycopy(byArray2, n2, byArray, n3, n4);
                    return n4;
                }

                @Override
                protected int getSegmentLength(byte[] byArray2) {
                    return byArray2.length;
                }

                static {
                    try {
                        $$$methodRef$$$4 = 1.class.getDeclaredConstructor(byte[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$3 = 1.class.getDeclaredMethod("copyToBuffer", Object.class, Integer.TYPE, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredMethod("getSegmentLength", Object.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("getSegmentLength", byte[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("copyToBuffer", byte[].class, Integer.TYPE, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
        }

        static LobSegmentBuffer<String> newCharacterBuffer(final char[] cArray) {
            return new LobSegmentBuffer<String>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;
                private static Executable $$$methodRef$$$3;
                private static Logger $$$loggerRef$$$3;
                private static Executable $$$methodRef$$$4;
                private static Logger $$$loggerRef$$$4;

                @Override
                protected int copyToBuffer(String string, int n2, int n3) {
                    int n4 = Math.min(cArray.length - n3, string.length() - n2);
                    string.getChars(n2, n2 + n4, cArray, n3);
                    return n4;
                }

                @Override
                protected int getSegmentLength(String string) {
                    return string.length();
                }

                static {
                    try {
                        $$$methodRef$$$4 = 2.class.getDeclaredConstructor(char[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$3 = 2.class.getDeclaredMethod("copyToBuffer", Object.class, Integer.TYPE, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$2 = 2.class.getDeclaredMethod("getSegmentLength", Object.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredMethod("getSegmentLength", String.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("copyToBuffer", String.class, Integer.TYPE, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
        }

        private int getPosition() {
            return this.position;
        }

        private void reset() {
            this.position = 0;
        }

        private int putSegment(T t2, int n2) {
            int n3 = this.copyToBuffer(t2, n2, this.position);
            this.position += n3;
            return n3;
        }

        protected abstract int copyToBuffer(T var1, int var2, int var3);

        protected abstract int getSegmentLength(T var1);

        static {
            try {
                $$$methodRef$$$5 = LobSegmentBuffer.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = LobSegmentBuffer.class.getDeclaredMethod("putSegment", Object.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = LobSegmentBuffer.class.getDeclaredMethod("reset", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = LobSegmentBuffer.class.getDeclaredMethod("getPosition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = LobSegmentBuffer.class.getDeclaredMethod("newCharacterBuffer", char[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = LobSegmentBuffer.class.getDeclaredMethod("newByteBuffer", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

