/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import oracle.jdbc.driver.PhasedPublisher;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;

final class BufferedPublisher<T>
extends PhasedPublisher<T> {
    private final AsyncQueue<T> itemQueue;
    private final Monitor monitor = Monitor.newInstance();
    private CompletableFuture<T> onNextFuture = null;
    private boolean isTerminated = false;
    private Throwable terminalError = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    private BufferedPublisher(int n2, Executor executor) {
        super(executor, null);
        this.itemQueue = new AsyncQueue(n2);
    }

    final CompletionStage<Void> offerItem(T t2) {
        return this.itemQueue.put(t2);
    }

    final void terminate(Throwable throwable) {
        try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
            this.isTerminated = true;
            this.terminalError = throwable;
            if (this.onNextFuture != null) {
                this.attemptTerminalSignal();
            }
        }
    }

    @Override
    protected final CompletionStage<T> advancePhaseAsync() {
        try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
            this.onNextFuture = this.itemQueue.take();
            if (this.isTerminated) {
                this.attemptTerminalSignal();
            }
            CompletableFuture<T> completableFuture = this.onNextFuture;
            return completableFuture;
        }
    }

    private void attemptTerminalSignal() {
        if (this.terminalError == null) {
            this.onNextFuture.complete(null);
        } else {
            this.onNextFuture.completeExceptionally(this.terminalError);
        }
    }

    static final <T> BufferedPublisher<T> newInstance(int n2, Executor executor) {
        return new BufferedPublisher<T>(n2, executor);
    }

    static {
        try {
            $$$methodRef$$$5 = BufferedPublisher.class.getDeclaredConstructor(Integer.TYPE, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = BufferedPublisher.class.getDeclaredMethod("newInstance", Integer.TYPE, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = BufferedPublisher.class.getDeclaredMethod("attemptTerminalSignal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = BufferedPublisher.class.getDeclaredMethod("advancePhaseAsync", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = BufferedPublisher.class.getDeclaredMethod("terminate", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = BufferedPublisher.class.getDeclaredMethod("offerItem", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private static final class AsyncQueue<T> {
        private final Monitor queueMonitor = Monitor.newInstance();
        private final ArrayDeque<T> queue = new ArrayDeque();
        private final int maxQueueSize;
        private CompletableFuture<Void> putFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;
        private CompletableFuture<Void> takeFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private AsyncQueue(int n2) {
            this.maxQueueSize = n2;
        }

        private final CompletionStage<Void> put(T t2) {
            try (Monitor.CloseableLock closeableLock = this.queueMonitor.acquireCloseableLock();){
                assert (this.takeFuture.isDone()) : "Stage returned by previous put is not complete";
                this.queue.addLast(t2);
                this.putFuture.complete(null);
                if (this.queue.size() < this.maxQueueSize) {
                    CompletableFuture<Void> completableFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;
                    return completableFuture;
                }
                this.takeFuture = new CompletableFuture<Void>();
                CompletableFuture<Void> completableFuture = this.takeFuture;
                return completableFuture;
            }
        }

        private final CompletableFuture<T> take() {
            try (Monitor.CloseableLock closeableLock = this.queueMonitor.acquireCloseableLock();){
                assert (this.putFuture.isDone()) : "Stage returned by previous take is not complete";
                T t2 = this.queue.pollFirst();
                this.takeFuture.complete(null);
                if (t2 != null) {
                    CompletableFuture<T> completableFuture = CompletableFuture.completedFuture(t2);
                    return completableFuture;
                }
                this.putFuture = new CompletableFuture();
                CompletionStage completionStage = this.putFuture.thenCompose(void_ -> this.take());
                return completionStage;
            }
        }

        static {
            try {
                $$$methodRef$$$3 = AsyncQueue.class.getDeclaredConstructor(Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = AsyncQueue.class.getDeclaredMethod("lambda$take$0", Void.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = AsyncQueue.class.getDeclaredMethod("take", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = AsyncQueue.class.getDeclaredMethod("put", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

