/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.io.Serializable;
import oracle.AQ.AQException;

public class AQQueueProperty
implements Serializable {
    public static final int NORMAL_QUEUE = 0;
    public static final int EXCEPTION_QUEUE = 1;
    static final int DEFAULT_QUEUE_TYPE = 0;
    static final int DEFAULT_MAX_RETRIES = 0;
    static final int DEFAULT_RETRY_INTERVAL = 0;
    static final int DEFAULT_RETENTION_TIME = 0;
    static final boolean DEFAULT_DEP_TRACKING = false;
    static final boolean DEFAULT_AUTO_COMMIT = true;
    public static final int INFINITE = -1;
    protected int type = 0;
    Integer max_retries = null;
    Double retry_interval = null;
    Double retention_time = null;
    private boolean dep_tracking = false;
    private String comment = null;
    private boolean auto_commit = true;
    private boolean sharded;
    private boolean migration;
    private boolean isJson;

    public int getQueueType() {
        return this.type;
    }

    public void setQueueType(int n) throws AQException {
        if (n != 0 && n != 1) {
            throw new AQException(0, "Invalid queue type");
        }
        this.type = n;
    }

    public int getMaxRetries() {
        if (this.max_retries == null) {
            return 0;
        }
        return this.max_retries;
    }

    public void setMaxRetries(int n) {
        this.max_retries = new Integer(n);
    }

    public void setMaxRetries(Integer n) {
        this.max_retries = n;
    }

    public double getRetryInterval() {
        if (this.retry_interval == null) {
            return 0.0;
        }
        return this.retry_interval;
    }

    public void setRetryInterval(double d) {
        this.retry_interval = new Double(d);
    }

    public void setRetryInterval(Double d) {
        this.retry_interval = d;
    }

    public double getRetentionTime() {
        if (this.retention_time == null) {
            return 0.0;
        }
        return this.retention_time;
    }

    public void setRetentionTime(double d) {
        this.retention_time = new Double(d);
    }

    public void setRetentionTime(Double d) {
        this.retention_time = d;
    }

    boolean isDepTrackingEnabled() {
        return this.dep_tracking;
    }

    void setDepTracking(boolean bl) throws AQException {
        if (bl) {
            throw new AQException(0, "Dependency tracking cannot be TRUE");
        }
        this.dep_tracking = bl;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public boolean isSharded() {
        return this.sharded;
    }

    public void setSharded(boolean bl) {
        this.sharded = bl;
    }

    public boolean isMigrating() {
        return this.migration;
    }

    public void setMigrating(boolean bl) {
        this.migration = bl;
    }

    public boolean isJson() {
        return this.isJson;
    }

    public void setJson(boolean bl) {
        this.isJson = bl;
    }

    boolean isAutoCommitEnabled() throws AQException {
        return this.auto_commit;
    }

    void setAutoCommit(boolean bl) throws AQException {
        this.auto_commit = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[AQQueueProperty]");
        if (this.type == 0) {
            stringBuffer.append("\n  type             : NORMAL");
        } else {
            stringBuffer.append("\n  type             : EXCEPTION");
        }
        stringBuffer.append("\n  max_retries      : " + this.max_retries);
        stringBuffer.append("\n  retry_interval   : " + this.retry_interval);
        stringBuffer.append("\n  retention_time   : " + this.retention_time);
        stringBuffer.append("\n  dep_tracking     : " + this.dep_tracking);
        stringBuffer.append("\n  comment          : " + this.comment);
        stringBuffer.append("\n  auto_commit      : " + this.auto_commit);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

