/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import java.sql.SQLException;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleStruct;
import oracle.jms.plsql.InternalException;
import oracle.jms.plsql.ResourceMgr;
import oracle.jms.plsql.TypeConversionException;
import oracle.sql.NUMBER;

class TypeConversion {
    private static Object[] nullAttribs = new Object[]{null, null, null, null, null};

    TypeConversion() {
    }

    static Object jmsConvert(Object object, int n) throws TypeConversionException {
        try {
            switch (n) {
                case 0: {
                    if (object instanceof Byte) {
                        return object;
                    }
                    if (object instanceof String) {
                        return Byte.valueOf((String)object);
                    }
                    throw new TypeConversionException();
                }
                case 1: {
                    if (object instanceof Short) {
                        return object;
                    }
                    if (object instanceof String) {
                        return Short.valueOf((String)object);
                    }
                    if (object instanceof Byte) {
                        return new Short(((Byte)object).shortValue());
                    }
                    throw new TypeConversionException();
                }
                case 2: {
                    if (object instanceof Integer) {
                        return object;
                    }
                    if (object instanceof String) {
                        return Integer.valueOf((String)object);
                    }
                    if (object instanceof Byte) {
                        return new Integer(((Byte)object).intValue());
                    }
                    if (object instanceof Short) {
                        return new Integer(((Short)object).intValue());
                    }
                    throw new TypeConversionException();
                }
                case 3: {
                    if (object instanceof Long) {
                        return object;
                    }
                    if (object instanceof String) {
                        return Long.valueOf((String)object);
                    }
                    if (object instanceof Byte) {
                        return new Long(((Byte)object).longValue());
                    }
                    if (object instanceof Short) {
                        return new Long(((Short)object).longValue());
                    }
                    if (object instanceof Integer) {
                        return new Long(((Integer)object).longValue());
                    }
                    throw new TypeConversionException();
                }
                case 4: {
                    if (object instanceof Float) {
                        return object;
                    }
                    if (object instanceof String) {
                        return Float.valueOf((String)object);
                    }
                    throw new TypeConversionException();
                }
                case 5: {
                    if (object instanceof Double) {
                        return object;
                    }
                    if (object instanceof String) {
                        return Double.valueOf((String)object);
                    }
                    if (object instanceof Float) {
                        return new Double(((Float)object).doubleValue());
                    }
                    throw new TypeConversionException();
                }
                case 6: {
                    if (object instanceof Boolean) {
                        return object;
                    }
                    if (object instanceof String) {
                        return Boolean.valueOf((String)object);
                    }
                    throw new TypeConversionException();
                }
                case 7: {
                    if (object instanceof Character) {
                        return object;
                    }
                    throw new TypeConversionException();
                }
                case 8: {
                    if (object instanceof String) {
                        return object;
                    }
                    if (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double) {
                        return object.toString();
                    }
                    throw new TypeConversionException();
                }
                case 9: {
                    if (object instanceof byte[]) {
                        return object;
                    }
                    throw new TypeConversionException();
                }
            }
            throw new TypeConversionException();
        }
        catch (NumberFormatException numberFormatException) {
            throw new TypeConversionException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void objToJmsValue(Object object, OracleStruct[] oracleStructArray, int[] nArray) throws TypeConversionException, SQLException {
        Object[] objectArray = new Object[]{null, null, null, null, null};
        if (object != null) {
            nArray[0] = 0;
            if (object instanceof Byte) {
                objectArray[0] = new NUMBER(0);
                objectArray[1] = new NUMBER(((Byte)object).byteValue());
            } else if (object instanceof Short) {
                objectArray[0] = new NUMBER(1);
                objectArray[1] = new NUMBER(((Short)object).shortValue());
            } else if (object instanceof Integer) {
                objectArray[0] = new NUMBER(2);
                objectArray[1] = new NUMBER(((Integer)object).intValue());
            } else if (object instanceof Long) {
                objectArray[0] = new NUMBER(3);
                objectArray[1] = new NUMBER(((Long)object).longValue());
            } else if (object instanceof Float) {
                objectArray[0] = new NUMBER(4);
                objectArray[1] = new NUMBER(((Float)object).floatValue());
            } else if (object instanceof Double) {
                objectArray[0] = new NUMBER(5);
                objectArray[1] = new NUMBER(((Double)object).doubleValue());
            } else if (object instanceof Boolean) {
                objectArray[0] = new NUMBER(6);
                objectArray[1] = new NUMBER(((Boolean)object).booleanValue());
            } else if (object instanceof Character) {
                objectArray[0] = new NUMBER(7);
                objectArray[2] = ((Character)object).toString();
            } else if (object instanceof String) {
                objectArray[0] = new NUMBER(8);
                OracleClob oracleClob = ResourceMgr.getSharedClob();
                oracleClob.setString(1L, (String)object);
                objectArray[3] = oracleClob;
            } else {
                if (!(object instanceof byte[])) throw new TypeConversionException();
                objectArray[0] = new NUMBER(9);
                OracleBlob oracleBlob = ResourceMgr.getSharedBlob();
                oracleBlob.setBytes(1L, (byte[])object);
                objectArray[4] = oracleBlob;
            }
        } else {
            nArray[0] = 1;
        }
        oracleStructArray[0] = (OracleStruct)ResourceMgr.getConnection().createStruct("SYS.AQ$_JMS_VALUE", objectArray);
    }

    static OracleStruct getNullSTRUCT() throws SQLException {
        return (OracleStruct)ResourceMgr.getConnection().createStruct("SYS.AQ$_JMS_VALUE", nullAttribs);
    }

    static OracleArray arrayToARRAY(String[] stringArray) throws SQLException {
        return (OracleArray)((OracleConnection)ResourceMgr.getConnection()).createOracleArray("SYS.AQ$_JMS_NAMEARRAY", (Object)stringArray);
    }

    static OracleArray getNullARRAY() throws SQLException {
        return (OracleArray)((OracleConnection)ResourceMgr.getConnection()).createOracleArray("SYS.AQ$_JMS_NAMEARRAY", (Object)new String[0]);
    }

    static NUMBER objToNumber(Object object, int n) throws InternalException, SQLException {
        if (object == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return new NUMBER(((Byte)object).byteValue());
            }
            case 1: {
                return new NUMBER(((Short)object).shortValue());
            }
            case 2: {
                return new NUMBER(((Integer)object).intValue());
            }
            case 3: {
                return new NUMBER(((Long)object).longValue());
            }
            case 4: {
                return new NUMBER(((Float)object).floatValue());
            }
            case 5: {
                return new NUMBER(((Double)object).doubleValue());
            }
            case 6: {
                return new NUMBER(((Boolean)object).booleanValue());
            }
        }
        throw new InternalException();
    }

    static Object numberToObj(NUMBER nUMBER, int n) throws InternalException, SQLException {
        switch (n) {
            case 0: {
                return new Byte(nUMBER.byteValue());
            }
            case 1: {
                return new Short(nUMBER.shortValue());
            }
            case 2: {
                return new Integer(nUMBER.intValue());
            }
            case 3: {
                return new Long(nUMBER.longValue());
            }
            case 4: {
                return new Float(nUMBER.floatValue());
            }
            case 5: {
                return new Double(nUMBER.doubleValue());
            }
            case 6: {
                return new Boolean(nUMBER.booleanValue());
            }
        }
        throw new InternalException();
    }
}

