/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import oracle.jms.plsql.MsgEntity;
import oracle.jms.plsql.WrongAccessModeException;

class BytesMsgEntity
extends MsgEntity {
    private int accessMode;
    private byte[] data;
    private DataInputStream dataInput;
    private ByteArrayOutputStream byteOutput;
    private DataOutputStream dataOutput;

    BytesMsgEntity() {
        this.byteOutput = new ByteArrayOutputStream();
        this.dataOutput = new DataOutputStream(this.byteOutput);
        this.accessMode = 1;
    }

    BytesMsgEntity(byte[] byArray) {
        this.data = byArray;
        this.dataInput = new DataInputStream(new ByteArrayInputStream(byArray));
        this.accessMode = 0;
    }

    @Override
    void clean() throws IOException {
        if (this.accessMode == 0) {
            if (this.dataInput != null) {
                this.dataInput.close();
                this.dataInput = null;
            }
            this.data = null;
        } else {
            if (this.dataOutput != null) {
                this.dataOutput.close();
                this.dataOutput = null;
            }
            if (this.byteOutput != null) {
                this.byteOutput.close();
                this.byteOutput = null;
            }
            this.data = null;
        }
    }

    int getMode() {
        return this.accessMode;
    }

    void reset() throws IOException {
        if (this.accessMode == 0) {
            this.dataInput.close();
            this.dataInput = new DataInputStream(new ByteArrayInputStream(this.data));
        } else {
            this.dataOutput.close();
            this.data = this.byteOutput.toByteArray();
            this.dataOutput = null;
            this.byteOutput = null;
            this.dataInput = new DataInputStream(new ByteArrayInputStream(this.data));
            this.accessMode = 0;
        }
    }

    byte[] flush() throws IOException {
        if (this.accessMode == 1) {
            this.data = this.byteOutput.toByteArray();
        }
        return this.data;
    }

    byte readByte() throws WrongAccessModeException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        return this.dataInput.readByte();
    }

    short readShort() throws WrongAccessModeException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        return this.dataInput.readShort();
    }

    int readInt() throws WrongAccessModeException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        return this.dataInput.readInt();
    }

    long readLong() throws WrongAccessModeException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        return this.dataInput.readLong();
    }

    float readFloat() throws WrongAccessModeException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        return this.dataInput.readFloat();
    }

    double readDouble() throws WrongAccessModeException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        return this.dataInput.readDouble();
    }

    boolean readBoolean() throws WrongAccessModeException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        return this.dataInput.readBoolean();
    }

    int readUnsignedByte() throws WrongAccessModeException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        return this.dataInput.readUnsignedByte();
    }

    int readUnsignedShort() throws WrongAccessModeException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        return this.dataInput.readUnsignedShort();
    }

    int readBytes(byte[] byArray) throws WrongAccessModeException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        try {
            return this.dataInput.read(byArray);
        }
        catch (EOFException eOFException) {
            return -1;
        }
    }

    char readChar() throws WrongAccessModeException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        return this.dataInput.readChar();
    }

    String readUTF() throws WrongAccessModeException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        try {
            return this.dataInput.readUTF();
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    void writeByte(byte by) throws WrongAccessModeException, IOException {
        if (this.accessMode == 0) {
            throw new WrongAccessModeException();
        }
        this.dataOutput.writeByte(by);
    }

    void writeShort(short s) throws WrongAccessModeException, IOException {
        if (this.accessMode == 0) {
            throw new WrongAccessModeException();
        }
        this.dataOutput.writeShort(s);
    }

    void writeInt(int n) throws WrongAccessModeException, IOException {
        if (this.accessMode == 0) {
            throw new WrongAccessModeException();
        }
        this.dataOutput.writeInt(n);
    }

    void writeLong(long l) throws WrongAccessModeException, IOException {
        if (this.accessMode == 0) {
            throw new WrongAccessModeException();
        }
        this.dataOutput.writeLong(l);
    }

    void writeFloat(float f) throws WrongAccessModeException, IOException {
        if (this.accessMode == 0) {
            throw new WrongAccessModeException();
        }
        this.dataOutput.writeFloat(f);
    }

    void writeDouble(double d) throws WrongAccessModeException, IOException {
        if (this.accessMode == 0) {
            throw new WrongAccessModeException();
        }
        this.dataOutput.writeDouble(d);
    }

    void writeBoolean(boolean bl) throws WrongAccessModeException, IOException {
        if (this.accessMode == 0) {
            throw new WrongAccessModeException();
        }
        this.dataOutput.writeBoolean(bl);
    }

    void writeBytes(byte[] byArray, int n, int n2) throws WrongAccessModeException, IOException {
        if (this.accessMode == 0) {
            throw new WrongAccessModeException();
        }
        this.dataOutput.write(byArray, n, n2);
    }

    void writeChar(char c) throws WrongAccessModeException, IOException {
        if (this.accessMode == 0) {
            throw new WrongAccessModeException();
        }
        this.dataOutput.writeChar(c);
    }

    void writeUTF(String string) throws WrongAccessModeException, IOException {
        if (this.accessMode == 0) {
            throw new WrongAccessModeException();
        }
        this.dataOutput.writeUTF(string);
    }
}

