/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.ucp.jdbc.JDBCConnectionPoolStatistics;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatistics;

public class AQjmsUcpDsStats {
    PoolDataSource pds;

    AQjmsUcpDsStats(PoolDataSource pds) {
        this.pds = pds;
    }

    public int getMaxPoolSize() {
        return this.pds.getMaxPoolSize();
    }

    public int getMinPoolSize() {
        return this.pds.getMinPoolSize();
    }

    public JDBCConnectionPoolStatistics getStatistics() {
        return this.pds.getStatistics();
    }

    public int getInitialPoolSize() {
        return this.pds.getInitialPoolSize();
    }

    public String getConnectionPoolName() {
        return this.pds.getConnectionPoolName();
    }

    public int getMaxConnectionReuseCount() {
        return this.pds.getMaxConnectionReuseCount();
    }

    public long getMaxConnectionReuseTime() {
        return this.pds.getMaxConnectionReuseTime();
    }

    public int getInactiveConnectionTimeout() {
        return this.pds.getInactiveConnectionTimeout();
    }

    public int getTimeToLiveConnectionTimeout() {
        return this.pds.getTimeToLiveConnectionTimeout();
    }

    public boolean getValidateConnectionOnBorrow() {
        return this.pds.getValidateConnectionOnBorrow();
    }

    public String getFCFProcessingInfo() {
        if (this.pds.getFastConnectionFailoverEnabled()) {
            return ((OracleJDBCConnectionPoolStatistics)this.pds.getStatistics()).getFCFProcessingInfo();
        }
        AQjmsOracleDebug.trace(4, "AQjmsUCpDsStats.getFCFProcessingInfo", "FastConnectionFailover is not enabled");
        return "";
    }
}

