/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsMessage;
import oracle.jakarta.jms.AQjmsMessageHeaderExt;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsPropDatum;
import oracle.jakarta.jms.AQjmsSession;
import oracle.jakarta.jms.JsonMessage;
import oracle.jdbc.driver.json.binary.OsonArrayImpl;
import oracle.jdbc.driver.json.binary.OsonObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public class AQjmsJsonMessage
extends AQjmsMessage
implements JsonMessage {
    OracleJsonDatum json_payload;

    private AQjmsJsonMessage(AQjmsSession s) throws JMSException {
        super(s, false);
        this.enqueue_time = 0L;
        this.msg_dest = null;
        this.del_mode = 2;
        this.corr_id = "";
        this.redelivered = false;
        this.expiration = 0L;
        this.priority = 1;
        this.msg_properties = null;
        this.access_mode = 2;
        this.prop_read_only = false;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.header_ext = null;
        this.json_payload = null;
    }

    AQjmsJsonMessage(AQjmsSession s, OracleJsonValue payload) throws JMSException {
        this(s);
        if (payload != null) {
            this.setJsonPayload(payload);
        }
    }

    AQjmsJsonMessage(AQjmsSession s, OracleJsonDatum payload) throws JMSException {
        this(s);
        this.json_payload = payload;
    }

    AQjmsJsonMessage(AQjmsSession s, String payload) throws JMSException {
        this(s);
        if (payload != null) {
            this.setJsonPayload(payload);
        }
    }

    @Override
    AQjmsMessageHeaderExt getMessageHeaderExt() {
        return this.header_ext;
    }

    @Override
    Hashtable getPropertiesHashtable() {
        return this.msg_properties;
    }

    @Override
    public String getJMSMessageID() throws JMSException {
        return this.message_id.getPartialJMSMessageID();
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    @Override
    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        AQjmsError.throwEx(102);
    }

    @Override
    public String getJMSType() throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    @Override
    public void setJMSType(String type) throws JMSException {
        AQjmsError.throwEx(102);
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this.getEnqueueTime();
    }

    @Override
    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.setEnqueueTime(timestamp);
    }

    @Override
    public boolean propertyExists(String name) throws JMSException {
        if (AQjmsMessage.isSystemProperty(name)) {
            return name.equals("JMSXRcvTimestamp") || name.equals("JMSXRecvTimestamp") || name.equals("JMSXState") || name.equals("JMSXDeliveryCount") || name.equals("JMS_OracleExcpQ") || name.equals("JMS_OracleDelay") || name.equals("JMS_OracleOriginalMessageID");
        }
        return false;
    }

    @Override
    public boolean getBooleanProperty(String name) throws JMSException {
        AQjmsError.throwEx(102);
        return false;
    }

    @Override
    public byte getByteProperty(String name) throws JMSException {
        AQjmsError.throwEx(102);
        return 0;
    }

    @Override
    public short getShortProperty(String name) throws JMSException {
        AQjmsError.throwEx(102);
        return 0;
    }

    @Override
    public int getIntProperty(String name) throws JMSException {
        Object value = null;
        if (name == null) {
            AQjmsError.throwEx(139);
            return 0;
        }
        try {
            if (AQjmsMessage.isSystemProperty(name)) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (value instanceof String) {
                        return Integer.parseInt((String)value);
                    }
                    return ((Datum)value).intValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0;
        }
    }

    @Override
    public long getLongProperty(String name) throws JMSException {
        Object value = null;
        if (name == null) {
            AQjmsError.throwEx(139);
            return 0L;
        }
        try {
            if (AQjmsMessage.isSystemProperty(name)) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (value instanceof String) {
                        return Long.parseLong((String)value);
                    }
                    return ((Datum)value).longValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0L;
        }
    }

    @Override
    public float getFloatProperty(String name) throws JMSException {
        AQjmsError.throwEx(102);
        return 0.0f;
    }

    @Override
    public double getDoubleProperty(String name) throws JMSException {
        AQjmsError.throwEx(102);
        return 0.0;
    }

    @Override
    public String getStringProperty(String name) throws JMSException {
        Object value = null;
        if (name == null) {
            AQjmsError.throwEx(139);
            return null;
        }
        try {
            if (AQjmsMessage.isSystemProperty(name)) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (value instanceof String) {
                        return (String)value;
                    }
                    return ((Datum)value).stringValue();
                }
                return null;
            }
            return null;
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwMsgFormatEx(161, null);
            return null;
        }
    }

    @Override
    public Object getObjectProperty(String name) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    @Override
    public synchronized Enumeration getPropertyNames() throws JMSException {
        Hashtable<String, AQjmsPropDatum> prop_ht = null;
        Enumeration prop_enum = null;
        AQjmsPropDatum prop_datum = null;
        prop_datum = new AQjmsPropDatum(27, (String)null);
        prop_ht = new Hashtable<String, AQjmsPropDatum>();
        prop_ht.put("JMSXRcvTimestamp", prop_datum);
        prop_ht.put("JMSXState", prop_datum);
        prop_ht.put("JMSXDeliveryCount", prop_datum);
        prop_ht.put("JMS_OracleExcpQ", prop_datum);
        prop_ht.put("JMS_OracleDelay", prop_datum);
        prop_ht.put("JMS_OracleOriginalMessageID", prop_datum);
        prop_enum = prop_ht.keys();
        return prop_enum;
    }

    @Override
    public void setBooleanProperty(String name, boolean value) throws JMSException {
        AQjmsError.throwEx(102);
        throw new AQjmsException("User properties not supported on JSON messages", 0);
    }

    @Override
    public void setByteProperty(String name, byte value) throws JMSException {
        AQjmsError.throwEx(102);
        throw new AQjmsException("User properties not supported on JSON messages", 0);
    }

    @Override
    public void setShortProperty(String name, short value) throws JMSException {
        AQjmsError.throwEx(102);
        throw new AQjmsException("User properties not supported on JSON messages", 0);
    }

    @Override
    public void setIntProperty(String name, int value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (name.equals("JMS_OracleDelay")) {
                NUMBER new_value = new NUMBER(value);
                this.msg_delay = new_value.intValue();
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119);
            throw new AQjmsException("Could not set property value", 0, sql_ex);
        }
    }

    @Override
    public void setLongProperty(String name, long value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (name.equals("JMS_OracleTimestamp")) {
                NUMBER new_value = new NUMBER(value);
                this.setEnqueueTime(new_value.longValue());
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119);
        }
    }

    @Override
    public void setFloatProperty(String name, float value) throws JMSException {
        AQjmsError.throwEx(102);
        throw new AQjmsException("User properties not supported on JSON messages", 0);
    }

    @Override
    public void setDoubleProperty(String name, double value) throws JMSException {
        AQjmsError.throwEx(102);
        throw new AQjmsException("User properties not supported on JSON messages", 0);
    }

    @Override
    public void setStringProperty(String name, String value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (name.equals("JMS_OracleExcpQ")) {
                if (value instanceof String) {
                    this.excp_queue = value;
                } else {
                    AQjmsError.throwEx(153);
                }
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (Exception e) {
            AQjmsError.throwEx(119);
            throw new AQjmsException("Could not set property value", 0, e);
        }
    }

    @Override
    public void setObjectProperty(String name, Object value) throws JMSException {
        AQjmsError.throwEx(102);
        throw new AQjmsException("User properties not supported on JSON messages", 0);
    }

    @Override
    public void clearBody() throws JMSException {
        this.json_payload = null;
        this.setAccessMode(2);
        this.setPropReadOnly(false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    Object getSystemProperty(String name) throws SQLException {
        void var2_11;
        Object var2_2 = null;
        AQjmsOracleDebug.trace(4, "AQjmsJsonMessage.getSystemProperty", "entry");
        if (!AQjmsMessage.isSystemProperty(name)) {
            AQjmsOracleDebug.trace(5, "AQjmsJsonMessage.getSystemProperty", "name does not start with JMS, returning null");
            return null;
        }
        if (name.equals("JMSXDeliveryCount")) {
            NUMBER nUMBER = new NUMBER(this.attempts);
        } else if (name.equals("JMSXRcvTimestamp") || name.equals("JMSXRecvTimestamp")) {
            NUMBER nUMBER = new NUMBER(this.recv_time);
        } else if (name.equals("JMSXState")) {
            NUMBER nUMBER = new NUMBER(this.msg_state);
        } else if (name.equals("JMS_OracleExcpQ")) {
            String string = this.excp_queue;
        } else if (name.equals("JMS_OracleDelay")) {
            NUMBER nUMBER = new NUMBER(this.msg_delay);
        } else if (name.equals("JMS_OracleOriginalMessageID")) {
            if (this.orig_msg_id == null) {
                Object var2_8 = null;
            } else {
                String string = "ID:" + RepConversion.bArray2String((byte[])this.orig_msg_id);
            }
        } else {
            if (!name.equals("JMS_OracleTimestamp")) {
                AQjmsOracleDebug.trace(5, "AQjmsJsonMessage.getSystemProperty", "returning null");
                return null;
            }
            NUMBER nUMBER = new NUMBER(this.getEnqueueTime());
        }
        AQjmsOracleDebug.trace(4, "AQjmsJsonMessage.getSystemProperty", "exit");
        return var2_11;
    }

    @Override
    public void setJsonPayload(OracleJsonDatum payload) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            this.json_payload = payload;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setJsonPayload(OracleJsonValue payload) throws JMSException {
        OracleJsonDatum jsonPayload;
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OracleJsonGenerator gen = null;){
            OracleJsonFactory oracleJsonFactory = this.session.jsonFactory;
            synchronized (oracleJsonFactory) {
                gen = this.session.jsonFactory.createJsonBinaryGenerator((OutputStream)baos);
                if (payload instanceof OracleJsonString) {
                    gen.write((OracleJsonValue)((OracleJsonString)payload));
                } else if (payload instanceof OracleJsonObject) {
                    gen.write((OracleJsonValue)((OracleJsonObject)payload));
                } else if (payload instanceof OracleJsonArray) {
                    gen.write((OracleJsonValue)((OracleJsonArray)payload));
                } else if (payload instanceof OracleJsonTimestamp) {
                    gen.write((OracleJsonValue)((OracleJsonTimestamp)payload));
                } else if (payload instanceof OracleJsonDecimal) {
                    gen.write((OracleJsonValue)((OracleJsonDecimal)payload));
                } else if (payload instanceof OracleJsonDouble) {
                    gen.write((OracleJsonValue)((OracleJsonDouble)payload));
                } else if (payload instanceof OracleJsonFloat) {
                    gen.write((OracleJsonValue)((OracleJsonFloat)payload));
                } else if (payload instanceof OracleJsonTimestampTZ) {
                    gen.write((OracleJsonValue)((OracleJsonTimestampTZ)payload));
                } else if (payload instanceof OracleJsonDate) {
                    gen.write((OracleJsonValue)((OracleJsonDate)payload));
                } else if (payload instanceof OracleJsonBinary) {
                    gen.write((OracleJsonValue)((OracleJsonBinary)payload));
                } else if (payload instanceof OracleJsonIntervalDS) {
                    gen.write((OracleJsonValue)((OracleJsonIntervalDS)payload));
                } else if (payload instanceof OracleJsonIntervalYM) {
                    gen.write((OracleJsonValue)((OracleJsonIntervalYM)payload));
                } else if (payload instanceof OracleJsonValue) {
                    gen.write(payload);
                } else if (payload instanceof OracleJsonNumber) {
                    gen.write((OracleJsonValue)((OracleJsonNumber)payload));
                } else if (payload instanceof OracleJsonStructure) {
                    gen.write((OracleJsonValue)((OracleJsonStructure)payload));
                } else {
                    AQjmsError.throwEx(102);
                }
            }
        }
        byte[] osonBytes = baos.toByteArray();
        this.json_payload = jsonPayload = new OracleJsonDatum(osonBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setJsonPayload(String payload) throws JMSException {
        OracleJsonDatum jsonPayload;
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OracleJsonGenerator gen = null;){
            OracleJsonFactory oracleJsonFactory = this.session.jsonFactory;
            synchronized (oracleJsonFactory) {
                gen = this.session.jsonFactory.createJsonBinaryGenerator((OutputStream)baos);
                gen.write(payload);
            }
        }
        byte[] osonBytes = baos.toByteArray();
        this.json_payload = jsonPayload = new OracleJsonDatum(osonBytes);
    }

    @Override
    public OracleJsonDatum getJsonPayload() throws JMSException {
        return this.json_payload;
    }

    @Override
    public String getJsonString() throws JMSException, SQLException {
        Object payload_obj = this.json_payload.toJdbc();
        if (payload_obj instanceof OracleJsonStringImpl) {
            return ((OracleJsonStringImpl)payload_obj).getString();
        }
        if (payload_obj instanceof OracleJsonBinaryImpl) {
            return ((OracleJsonBinaryImpl)payload_obj).getString();
        }
        if (payload_obj instanceof OracleJsonDateImpl) {
            return ((OracleJsonDateImpl)payload_obj).getString();
        }
        if (payload_obj instanceof OracleJsonDecimalImpl) {
            return ((OracleJsonDecimalImpl)payload_obj).getString();
        }
        if (payload_obj instanceof OracleJsonDoubleImpl) {
            return ((OracleJsonDoubleImpl)payload_obj).getString();
        }
        if (payload_obj instanceof OracleJsonFloatImpl) {
            return ((OracleJsonFloatImpl)payload_obj).getString();
        }
        if (payload_obj instanceof OracleJsonIntervalDSImpl) {
            return ((OracleJsonIntervalDSImpl)payload_obj).getString();
        }
        if (payload_obj instanceof OracleJsonIntervalYMImpl) {
            return ((OracleJsonIntervalYMImpl)payload_obj).getString();
        }
        if (payload_obj instanceof OracleJsonStringNumberImpl) {
            return ((OracleJsonStringNumberImpl)payload_obj).getString();
        }
        if (payload_obj instanceof OracleJsonTimestampImpl) {
            return ((OracleJsonTimestampImpl)payload_obj).getString();
        }
        if (payload_obj instanceof OracleJsonTimestampTZImpl) {
            return ((OracleJsonTimestampTZImpl)payload_obj).getString();
        }
        if (payload_obj instanceof OsonObjectImpl) {
            return ((OsonObjectImpl)payload_obj).toString();
        }
        if (payload_obj instanceof OsonArrayImpl) {
            return ((OsonArrayImpl)payload_obj).toString();
        }
        AQjmsError.throwEx(102);
        return null;
    }
}

