/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XAQueueConnectionFactory;
import jakarta.jms.XATopicConnectionFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jakarta.jms.AQjmsConnectionFactory;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsQueueConnectionFactory;
import oracle.jakarta.jms.AQjmsTopicConnectionFactory;
import oracle.jakarta.jms.AQjmsXAConnectionFactory;
import oracle.jakarta.jms.AQjmsXAQueueConnectionFactory;
import oracle.jakarta.jms.AQjmsXAResourceFactory;
import oracle.jakarta.jms.AQjmsXATopicConnectionFactory;

public class AQjmsFactory {
    public static ConnectionFactory getConnectionFactory(DataSource dataSource) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(dataSource);
        return conn_fac;
    }

    public static ConnectionFactory getConnectionFactory(DataSource dataSource, boolean compliant) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(dataSource);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static ConnectionFactory getConnectionFactory(String hostName, String oracleSID, int portNumber, String driver) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(hostName, oracleSID, portNumber, driver);
        return conn_fac;
    }

    public static ConnectionFactory getConnectionFactory(String hostName, String oracleSID, int portNumber, String driver, boolean compliant) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(hostName, oracleSID, portNumber, driver);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static ConnectionFactory getConnectionFactory(String jdbcURL, Properties info) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(jdbcURL, info);
        return conn_fac;
    }

    public static ConnectionFactory getConnectionFactory(String jdbcURL, Properties info, boolean compliant) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(jdbcURL, info);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static QueueConnectionFactory getQueueConnectionFactory(DataSource dataSource) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(dataSource);
        return conn_fac;
    }

    public static QueueConnectionFactory getQueueConnectionFactory(DataSource dataSource, boolean compliant) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(dataSource);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static QueueConnectionFactory getQueueConnectionFactory(String hostName, String oracleSID, int portNumber, String driver) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(hostName, oracleSID, portNumber, driver);
        return conn_fac;
    }

    public static QueueConnectionFactory getQueueConnectionFactory(String hostName, String oracleSID, int portNumber, String driver, boolean compliant) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(hostName, oracleSID, portNumber, driver);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static QueueConnectionFactory getQueueConnectionFactory(String jdbcURL, Properties info) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(jdbcURL, info);
        return conn_fac;
    }

    public static QueueConnectionFactory getQueueConnectionFactory(String jdbcURL, Properties info, boolean compliant) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(jdbcURL, info);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(DataSource dataSource) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(dataSource);
        return conn_fac;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(DataSource dataSource, boolean compliant) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(dataSource);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(String hostName, String oracleSID, int portNumber, String driver) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(hostName, oracleSID, portNumber, driver);
        return conn_fac;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(String hostName, String oracleSID, int portNumber, String driver, boolean compliant) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(hostName, oracleSID, portNumber, driver);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(String jdbcURL, Properties info) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(jdbcURL, info);
        return conn_fac;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(String jdbcURL, Properties info, boolean compliant) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(jdbcURL, info);
        conn_fac.setCompliant(compliant);
        return conn_fac;
    }

    public static XAConnectionFactory getXAConnectionFactory(XADataSource xadataSource) throws JMSException {
        return new AQjmsXAConnectionFactory(xadataSource);
    }

    public static XAConnectionFactory getXAConnectionFactory(XADataSource xadataSource, boolean compliant) throws JMSException {
        AQjmsXAConnectionFactory xaConnFact = new AQjmsXAConnectionFactory(xadataSource);
        xaConnFact.setCompliant(compliant);
        return xaConnFact;
    }

    public static XAConnectionFactory getXAConnectionFactory(DataSource dataSource, AQjmsXAResourceFactory xaresFactory) throws JMSException {
        return new AQjmsXAConnectionFactory(dataSource, xaresFactory);
    }

    public static XAConnectionFactory getXAConnectionFactory(DataSource dataSource, AQjmsXAResourceFactory xaresFactory, boolean compliant) throws JMSException {
        AQjmsXAConnectionFactory xaConnFact = new AQjmsXAConnectionFactory(dataSource, xaresFactory);
        xaConnFact.setCompliant(compliant);
        return xaConnFact;
    }

    public static XAConnectionFactory getXAConnectionFactory(String hostName, String oracleSID, int portNumber, String driver) throws JMSException {
        AQjmsXAConnectionFactory xaConnFact = null;
        xaConnFact = new AQjmsXAConnectionFactory(hostName, oracleSID, portNumber, driver);
        return xaConnFact;
    }

    public static XAConnectionFactory getXAConnectionFactory(String hostName, String oracleSID, int portNumber, String driver, boolean compliant) throws JMSException {
        AQjmsXAConnectionFactory xaConnFact = null;
        xaConnFact = new AQjmsXAConnectionFactory(hostName, oracleSID, portNumber, driver);
        xaConnFact.setCompliant(compliant);
        return xaConnFact;
    }

    public static XAConnectionFactory getXAConnectionFactory(String jdbcURL, Properties info) throws JMSException {
        AQjmsXAConnectionFactory xaConnFact = null;
        xaConnFact = new AQjmsXAConnectionFactory(jdbcURL, info);
        return xaConnFact;
    }

    public static XAConnectionFactory getXAConnectionFactory(String jdbcURL, Properties info, boolean compliant) throws JMSException {
        AQjmsXAConnectionFactory xaConnFact = null;
        xaConnFact = new AQjmsXAConnectionFactory(jdbcURL, info);
        xaConnFact.setCompliant(compliant);
        return xaConnFact;
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(XADataSource xadataSource) throws JMSException {
        return new AQjmsXAQueueConnectionFactory(xadataSource);
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(XADataSource xadataSource, boolean compliant) throws JMSException {
        AQjmsXAQueueConnectionFactory xaQConnFact = null;
        xaQConnFact = new AQjmsXAQueueConnectionFactory(xadataSource);
        xaQConnFact.setCompliant(compliant);
        return xaQConnFact;
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(DataSource dataSource, AQjmsXAResourceFactory xaresFactory) throws JMSException {
        return new AQjmsXAQueueConnectionFactory(dataSource, xaresFactory);
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(DataSource dataSource, AQjmsXAResourceFactory xaresFactory, boolean compliant) throws JMSException {
        AQjmsXAQueueConnectionFactory xaQConnFact = null;
        xaQConnFact = new AQjmsXAQueueConnectionFactory(dataSource, xaresFactory);
        xaQConnFact.setCompliant(compliant);
        return xaQConnFact;
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(String hostName, String oracleSID, int portNumber, String driver) throws JMSException {
        return new AQjmsXAQueueConnectionFactory(hostName, oracleSID, portNumber, driver);
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(String hostName, String oracleSID, int portNumber, String driver, boolean compliant) throws JMSException {
        AQjmsXAQueueConnectionFactory xaQConnFact = null;
        xaQConnFact = new AQjmsXAQueueConnectionFactory(hostName, oracleSID, portNumber, driver);
        xaQConnFact.setCompliant(compliant);
        return xaQConnFact;
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(String jdbcURL, Properties info) throws JMSException {
        return new AQjmsXAQueueConnectionFactory(jdbcURL, info);
    }

    public static XAQueueConnectionFactory getXAQueueConnectionFactory(String jdbcURL, Properties info, boolean compliant) throws JMSException {
        AQjmsXAQueueConnectionFactory xaQConnFact = null;
        xaQConnFact = new AQjmsXAQueueConnectionFactory(jdbcURL, info);
        xaQConnFact.setCompliant(compliant);
        return xaQConnFact;
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(XADataSource xadataSource) throws JMSException {
        return new AQjmsXATopicConnectionFactory(xadataSource);
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(XADataSource xadataSource, boolean compliant) throws JMSException {
        AQjmsXATopicConnectionFactory xaTConnFact = null;
        xaTConnFact = new AQjmsXATopicConnectionFactory(xadataSource);
        xaTConnFact.setCompliant(compliant);
        return xaTConnFact;
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(DataSource dataSource, AQjmsXAResourceFactory xaresFactory) throws JMSException {
        return new AQjmsXATopicConnectionFactory(dataSource, xaresFactory);
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(DataSource dataSource, AQjmsXAResourceFactory xaresFactory, boolean compliant) throws JMSException {
        AQjmsXATopicConnectionFactory xaTConnFact = null;
        xaTConnFact = new AQjmsXATopicConnectionFactory(dataSource, xaresFactory);
        xaTConnFact.setCompliant(compliant);
        return xaTConnFact;
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(String hostName, String oracleSID, int portNumber, String driver) throws JMSException {
        return new AQjmsXATopicConnectionFactory(hostName, oracleSID, portNumber, driver);
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(String hostName, String oracleSID, int portNumber, String driver, boolean compliant) throws JMSException {
        AQjmsXATopicConnectionFactory xaTConnFact = null;
        xaTConnFact = new AQjmsXATopicConnectionFactory(hostName, oracleSID, portNumber, driver);
        xaTConnFact.setCompliant(compliant);
        return xaTConnFact;
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(String jdbcURL, Properties info) throws JMSException {
        return new AQjmsXATopicConnectionFactory(jdbcURL, info);
    }

    public static XATopicConnectionFactory getXATopicConnectionFactory(String jdbcURL, Properties info, boolean compliant) throws JMSException {
        AQjmsXATopicConnectionFactory xaTConnFact = null;
        xaTConnFact = new AQjmsXATopicConnectionFactory(jdbcURL, info);
        xaTConnFact.setCompliant(compliant);
        return xaTConnFact;
    }

    static QueueConnectionFactory getQueueConnectionFactory(DataSource ds, String jdbc_url, Properties info) throws JMSException {
        AQjmsQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsQueueConnectionFactory(ds, jdbc_url, info);
        return conn_fac;
    }

    static TopicConnectionFactory getTopicConnectionFactory(DataSource ds, String jdbc_url, Properties info) throws JMSException {
        AQjmsTopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsTopicConnectionFactory(ds, jdbc_url, info);
        return conn_fac;
    }

    static ConnectionFactory getConnectionFactory(DataSource ds, String jdbc_url, Properties info) throws JMSException {
        AQjmsConnectionFactory conn_fac = null;
        conn_fac = new AQjmsConnectionFactory(ds, jdbc_url, info);
        return conn_fac;
    }

    static XAQueueConnectionFactory getXAQueueConnectionFactory(DataSource ds, String jdbc_url, Properties info) throws JMSException {
        AQjmsXAQueueConnectionFactory conn_fac = null;
        conn_fac = new AQjmsXAQueueConnectionFactory(ds, jdbc_url, info);
        return conn_fac;
    }

    static XATopicConnectionFactory getXATopicConnectionFactory(DataSource ds, String jdbc_url, Properties info) throws JMSException {
        AQjmsXATopicConnectionFactory conn_fac = null;
        conn_fac = new AQjmsXATopicConnectionFactory(ds, jdbc_url, info);
        return conn_fac;
    }

    static XAConnectionFactory getXAConnectionFactory(DataSource ds, String jdbc_url, Properties info) throws JMSException {
        AQjmsXAConnectionFactory conn_fac = null;
        conn_fac = new AQjmsXAConnectionFactory(ds, jdbc_url, info);
        return conn_fac;
    }

    public static int registerConnectionFactory(Connection connection, String connName, String hostName, String oracleSID, int portNumber, String driver, String type) throws JMSException {
        Statement addc_stmt = null;
        try {
            addc_stmt = type.toLowerCase().equals("queue") ? connection.prepareCall("begin dbms_aqadm.add_connection_to_ldap(connection=>?, host=>?, port=>?, sid=>?, driver=>?, type=>1); end;") : connection.prepareCall("begin dbms_aqadm.add_connection_to_ldap(connection=>?, host=>?, port=>?, sid=>?, driver=>?, type=>2); end;");
            addc_stmt.setString(1, connName);
            addc_stmt.setString(2, hostName);
            addc_stmt.setInt(3, portNumber);
            addc_stmt.setString(4, oracleSID);
            addc_stmt.setString(5, driver);
            addc_stmt.execute();
            addc_stmt.close();
        }
        catch (SQLException sqlex) {
            try {
                addc_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.registerConnectionFactory", sqlex);
            throw new AQjmsException(sqlex);
        }
        return 0;
    }

    public static int registerConnectionFactory(Connection connection, String connName, String jdbcURL, Properties info, String type) throws JMSException {
        Statement addc_stmt = null;
        try {
            addc_stmt = type.toLowerCase().equals("queue") ? connection.prepareCall("begin dbms_aqadm.add_connection_to_ldap(connection=>?, jdbc_string=>?, type=>1, username=>?, password=>?); end;") : connection.prepareCall("begin dbms_aqadm.add_connection_to_ldap(connection=>?, jdbc_string=>?, type=>2, username=>?, password=>?); end;");
            addc_stmt.setString(1, connName);
            addc_stmt.setString(2, jdbcURL);
            addc_stmt.setString(3, info == null ? null : info.getProperty("user", null));
            addc_stmt.setString(4, info == null ? null : info.getProperty("password", null));
            addc_stmt.execute();
            addc_stmt.close();
        }
        catch (SQLException sqlex) {
            try {
                addc_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.registerConnectionFactory", sqlex);
            throw new AQjmsException(sqlex);
        }
        return 0;
    }

    public static int registerConnectionFactory(Hashtable env, String connName, String hostName, String oracleSID, int portNumber, String driver, String type) throws JMSException {
        try {
            InitialDirContext inictx = new InitialDirContext(env);
            String searchbase = "cn=oracledbconnections," + (String)env.get("server_dn");
            DirContext ctx = (DirContext)inictx.lookup(searchbase);
            BasicAttributes attrs = new BasicAttributes(false);
            BasicAttribute objClasses = new BasicAttribute("objectclass");
            objClasses.add("top");
            objClasses.add("javaContainer");
            objClasses.add("javaObject");
            objClasses.add("javaNamingReference");
            objClasses.add("orclDBAQConnection");
            BasicAttribute gen_attr = new BasicAttribute("orclDBAQGeneric");
            gen_attr.add("Host=" + hostName);
            gen_attr.add("Port=" + String.valueOf(portNumber));
            gen_attr.add("Sid=" + oracleSID);
            if (driver != null) {
                gen_attr.add("Driver=" + driver);
            }
            attrs.put("cn", connName);
            attrs.put(gen_attr);
            if (type.toLowerCase().equals("queue")) {
                attrs.put("javaclassname", "oracle.jakarta.jms.AQjmsQueueConnectionFactory");
            } else {
                attrs.put("javaclassname", "oracle.jakarta.jms.AQjmsTopicConnectionFactory");
            }
            attrs.put("javafactory", "oracle.jakarta.jms.AQjmsConnectionFactory");
            attrs.put(objClasses);
            ctx.createSubcontext("cn=" + connName, (Attributes)attrs);
        }
        catch (NamingException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.registerConnectionFactory", e);
            AQjmsError.throwEx(205, (Throwable)e);
        }
        return 0;
    }

    public static int registerConnectionFactory(Hashtable env, String connName, String jdbcURL, Properties info, String type) throws JMSException {
        try {
            InitialDirContext inictx = new InitialDirContext(env);
            String searchbase = "cn=oracledbconnections," + (String)env.get("server_dn");
            DirContext ctx = (DirContext)inictx.lookup(searchbase);
            BasicAttributes attrs = new BasicAttributes(false);
            BasicAttribute objClasses = new BasicAttribute("objectclass");
            objClasses.add("top");
            objClasses.add("javaContainer");
            objClasses.add("javaObject");
            objClasses.add("javaNamingReference");
            objClasses.add("orclDBAQConnection");
            BasicAttribute gen_attr = new BasicAttribute("orclDBAQGeneric");
            gen_attr.add("JDBC_connect_string=" + jdbcURL);
            if (info != null && info.getProperty("user", null) != null && info.getProperty("password", null) != null) {
                gen_attr.add("Username=" + info.getProperty("user"));
                gen_attr.add("Password=" + info.getProperty("password"));
            }
            attrs.put("cn", connName);
            attrs.put(gen_attr);
            if (type.toLowerCase().equals("queue")) {
                attrs.put("javaclassname", "oracle.jakarta.jms.AQjmsQueueConnectionFactory");
            } else {
                attrs.put("javaclassname", "oracle.jakarta.jms.AQjmsTopicConnectionFactory");
            }
            attrs.put("javafactory", "oracle.jakarta.jms.AQjmsConnectionFactory");
            attrs.put(objClasses);
            ctx.createSubcontext("cn=" + connName, (Attributes)attrs);
        }
        catch (NamingException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.registerConnectionFactory", e);
            AQjmsError.throwEx(205, (Throwable)e);
        }
        return 0;
    }

    public static int unregisterConnectionFactory(Connection connection, String connName) throws JMSException {
        CallableStatement drpc_stmt = null;
        try {
            drpc_stmt = connection.prepareCall("begin dbms_aqadm.del_connection_from_ldap(connection=>?); end;");
            drpc_stmt.setString(1, connName);
            drpc_stmt.execute();
            drpc_stmt.close();
        }
        catch (SQLException sqlex) {
            try {
                drpc_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.unregisterConnectionFactory", sqlex);
            throw new AQjmsException(sqlex);
        }
        return 0;
    }

    public static int unregisterConnectionFactory(Hashtable env, String connName) throws JMSException {
        try {
            InitialDirContext inictx = new InitialDirContext(env);
            String searchbase = "cn=oracledbconnections," + (String)env.get("server_dn");
            DirContext ctx = (DirContext)inictx.lookup(searchbase);
            ctx.destroySubcontext("cn=" + connName);
        }
        catch (NamingException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.unregisterConnectionFactory", e);
            AQjmsError.throwEx(205, (Throwable)e);
        }
        return 0;
    }
}

