/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.Xid;
import oracle.jakarta.AQ.xml.AQxmlAuthContext;
import oracle.jakarta.AQ.xml.AQxmlCommitRequest;
import oracle.jakarta.AQ.xml.AQxmlConsumerOption;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlDocument;
import oracle.jakarta.AQ.xml.AQxmlEnqueueRequest;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlProcessor;
import oracle.jakarta.AQ.xml.AQxmlProducerOption;
import oracle.jakarta.AQ.xml.AQxmlPublishRequest;
import oracle.jakarta.AQ.xml.AQxmlPushRequest;
import oracle.jakarta.AQ.xml.AQxmlReceiveRequest;
import oracle.jakarta.AQ.xml.AQxmlRegisterRequest;
import oracle.jakarta.AQ.xml.AQxmlRollbackRequest;
import oracle.jakarta.AQ.xml.AQxmlSendRequest;
import oracle.jakarta.AQ.xml.AQxmlSequenceNumRequest;
import oracle.jakarta.AQ.xml.AQxmlServContext;
import oracle.jakarta.AQ.xml.AQxmlSessionContext;
import oracle.jakarta.AQ.xml.AQxmlTypeInfoRequest;
import oracle.jakarta.AQ.xml.AQxmlXid;
import oracle.jakarta.AQ.xml.StreamsAddTablePropagationRulesRequest;
import oracle.jakarta.AQ.xml.StreamsAddTableRulesRequest;
import oracle.jakarta.AQ.xml.StreamsSetupQueueRequest;
import oracle.jakarta.AQ.xml.StreamsStartApplyRequest;
import oracle.jakarta.AQ.xml.StreamsStartCaptureRequest;

class AQxmlSessionMgr {
    static boolean loaded_library = false;

    AQxmlSessionMgr() {
    }

    native void startGlobalTxn(long[] var1, long var2, int var4, long var5, byte[] var7, byte[] var8) throws SQLException;

    native void attachGlobalTxn(long[] var1, long var2, int var4, long var5, byte[] var7, byte[] var8) throws SQLException;

    native void detachGlobalTxn(long[] var1, long var2) throws SQLException;

    native void destroyGlobalTxn(long[] var1, long var2) throws SQLException;

    native void globalTxnCommit(long[] var1, long var2) throws SQLException;

    native void globalTxnRollback(long[] var1, long var2) throws SQLException;

    synchronized void initializeUserSession(AQxmlServContext serv_ctx, AQxmlSessionContext sess_ctx, AQxmlProcessor aq_proc, AQxmlDocument aq_xml_doc, boolean is_ddl) throws AQxmlException {
        this.initializeUserSession(serv_ctx, sess_ctx, aq_proc, aq_xml_doc, null, is_ddl);
    }

    synchronized void initializeUserSession(AQxmlServContext serv_ctx, AQxmlSessionContext sess_ctx, AQxmlProcessor aq_proc, AQxmlDocument aq_xml_doc, String dbuser, boolean is_ddl) throws AQxmlException {
        long[] oci_hdls = null;
        String[] own_queue = new String[2];
        String uname = null;
        int oper = -1;
        Object parent_conn = null;
        Connection db_conn = null;
        AQxmlAuthContext auth_ctx = null;
        Xid sess_xid = null;
        String iname = "oracle_aq_serv";
        String ename = "aq.oracle.com";
        String curr_dbuser = null;
        boolean multi_user = true;
        AQxmlDebug.trace(4, "AQxmlSessionMgr.initializeUserSession", "Entry");
        try {
            try {
                if (!loaded_library) {
                    String osName = System.getProperty("os.name");
                    if (osName.toUpperCase().startsWith("WINDOWS")) {
                        System.loadLibrary("oraclient19");
                        loaded_library = true;
                    } else {
                        System.loadLibrary("clntsh");
                        loaded_library = true;
                    }
                }
            }
            catch (Exception ex) {
                AQxmlDebug.traceEx(3, "AQxmlSessionMgr.initializeUserSession.loadLibrary excp:", ex);
                AQxmlError.throwAQEx(401, ex);
            }
            catch (Error err) {
                AQxmlDebug.traceErr(3, "AQxmlSessionMgr.initializeUserSession.loadLibrary error:", err);
                throw err;
            }
            sess_ctx.initDBConnection();
            sess_xid = sess_ctx.getSessionXid();
            auth_ctx = sess_ctx.getAuthContext();
            if (dbuser != null) {
                uname = dbuser;
            } else {
                oper = this.getUserOperation(aq_xml_doc, own_queue);
                AQxmlDebug.trace(4, "AQxmlSessionMgr.getUserSession: ", "before auth_ctx.getDBUser()");
                try {
                    uname = auth_ctx.getDBUser(serv_ctx, own_queue[0], own_queue[1], oper, auth_ctx.getCurrentDbUser());
                }
                catch (Exception sql_ex) {
                    AQxmlDebug.traceEx(3, "AQxmlSessionMgr.getUserSession-sql_ex", sql_ex);
                    AQxmlError.throwAQEx(410, sql_ex);
                }
                if (uname == null) {
                    AQxmlError.throwAQEx(438);
                }
            }
            if (sess_xid == null) {
                auth_ctx.setCurrentDbUser(uname);
            } else {
                curr_dbuser = auth_ctx.getCurrentDbUser();
                auth_ctx.setCurrentDbUser(uname);
            }
            AQxmlDebug.trace(4, "AQxmlSessionMgr.getUserSession: ", "after auth_ctx.getDBUser()  uname=" + uname);
            db_conn = sess_ctx.getCurrentDBConnection(uname, serv_ctx);
            if (!is_ddl) {
                String suid;
                if (sess_xid == null) {
                    AQxmlDebug.trace(4, "AQxmlSessionMgr.getUserSession: ", "sess_xid == null");
                    if (aq_xml_doc instanceof AQxmlCommitRequest || aq_xml_doc instanceof AQxmlRollbackRequest) {
                        AQxmlError.throwAQEx(401, "Not in a transaction");
                    }
                    sess_xid = AQxmlXid.createXid();
                    suid = AQxmlXid.ByteArraytoString(sess_xid.getGlobalTransactionId());
                    AQxmlDebug.trace(3, "AQxmlSessionMgr.initializeUserSession UUID: ", suid);
                    AQxmlDebug.trace(4, "AQxmlSessionMgr.getUserSession: ", "before startGlobalTxn multi_user = true");
                    oci_hdls = sess_ctx.getCurrentOCIHandles(serv_ctx);
                    sess_ctx.initJniCtx(oci_hdls);
                    try {
                        this.startGlobalTxn(oci_hdls, sess_ctx.getJNICtx(), serv_ctx.getMaxInactiveTime(), sess_xid.getFormatId(), sess_xid.getGlobalTransactionId(), sess_xid.getBranchQualifier());
                    }
                    catch (SQLException sql_ex) {
                        AQxmlDebug.traceEx(3, "AQxmlSessionMgr.initializeUserSession-sql_ex1", sql_ex);
                        AQxmlError.throwAQEx(410, sql_ex);
                    }
                    AQxmlDebug.trace(4, "AQxmlSessionMgr.getUserSession: ", "create txn");
                    sess_ctx.setSessionXid(sess_xid);
                    AQxmlDebug.trace(4, "AQxmlSessionMgr.getUserSession: ", "after startGlobalTxn");
                } else {
                    oci_hdls = sess_ctx.getCurrentOCIHandles(serv_ctx);
                    sess_ctx.initJniCtx(oci_hdls);
                    AQxmlDebug.trace(4, "AQxmlSessionMgr.initializeUserSession: ", "before attachGlobalTxn   sess_xid != null");
                    suid = AQxmlXid.ByteArraytoString(sess_xid.getGlobalTransactionId());
                    AQxmlDebug.trace(3, "AQxmlSessionMgr.reuseUserSession UUID: ", suid);
                    try {
                        this.attachGlobalTxn(oci_hdls, sess_ctx.getJNICtx(), serv_ctx.getMaxInactiveTime(), sess_xid.getFormatId(), sess_xid.getGlobalTransactionId(), sess_xid.getBranchQualifier());
                    }
                    catch (SQLException sql_ex) {
                        AQxmlDebug.traceEx(3, "AQxmlSessionMgr.initializeUserSession-sql_ex2", sql_ex);
                        AQxmlError.throwAQEx(410, sql_ex);
                    }
                    AQxmlDebug.trace(4, "AQxmlSessionMgr.initializeUserSession: ", "after attachGlobalTxn");
                }
            }
            sess_ctx.setCurrentDBConnection(db_conn);
        }
        catch (AQxmlException aqxml_ex) {
            AQxmlDebug.traceEx(3, "AQxmlSessionMgr.initializeUserSession-ex1", aqxml_ex);
            try {
                if (db_conn != null) {
                    AQxmlDebug.trace(4, "AQxmlSessionMgr.initializeUserSession", "close db connection");
                    db_conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            sess_ctx.setCurrentDBConnection(null);
            throw aqxml_ex;
        }
        catch (Exception sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlSessionMgr.initializeUserSession-sqlex", sql_ex);
            AQxmlError.throwAQEx(401, sql_ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void detachUserSession(AQxmlServContext serv_ctx, AQxmlSessionContext sess_ctx, AQxmlProcessor aq_proc, AQxmlDocument aq_xml_doc) {
        AQxmlDebug.trace(3, "AQxmlSessionMgr.detachUserSession: ", "entry");
        try {
            if (sess_ctx.getCurrentDBConnection() != null) {
                AQxmlDebug.trace(5, "AQxmlSessionMgr.detachUserSession", "current_db_conn != null");
            }
            try {
                if (sess_ctx.getSessionXid() != null) {
                    AQxmlDebug.trace(5, "AQxmlSessionMgr.detachUserSession: ", "before detachProxy - xid != null");
                    try {
                        this.detachGlobalTxn(sess_ctx.getCurrentOCIHandles(serv_ctx), sess_ctx.getJNICtx());
                    }
                    catch (SQLException sql_ex) {
                        AQxmlDebug.traceEx(3, "AQxmlSessionMgr.detachUserSession-sql_ex", sql_ex);
                    }
                }
                AQxmlDebug.trace(5, "AQxmlSessionMgr.detachUserSession: ", "after detachGlobalTxn");
            }
            finally {
                sess_ctx.closeDBConnection(true);
            }
        }
        catch (AQxmlException aqxml_ex) {
            AQxmlDebug.traceEx(3, "AQxmlSessionMgr.detachUserSession: aqxml_ex", aqxml_ex);
        }
        AQxmlDebug.trace(4, "AQxmlSessionMgr.detachUserSession: ", "exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void commitUserSession(AQxmlServContext serv_ctx, AQxmlSessionContext sess_ctx, AQxmlProcessor aq_proc) throws AQxmlException {
        block17: {
            Connection curr_conn = null;
            AQxmlDebug.trace(4, "AQxmlSessionMgr:commitUserSession", "Commiting ...");
            try {
                try {
                    curr_conn = sess_ctx.getCurrentDBConnection();
                    if (curr_conn != null) {
                        if (sess_ctx.getSessionXid() != null) {
                            AQxmlDebug.trace(5, "AQxmlSessionMgr:commitUserSession", "before globalTxnCommit");
                            try {
                                this.globalTxnCommit(sess_ctx.getCurrentOCIHandles(serv_ctx), sess_ctx.getJNICtx());
                            }
                            catch (SQLException sql_ex) {
                                AQxmlDebug.traceEx(3, "AQxmlSessionMgr.commitUserSession-sql_ex1", sql_ex);
                                AQxmlError.throwAQEx(410, sql_ex);
                            }
                        }
                        AQxmlDebug.trace(5, "AQxmlSessionMgr:commitUserSession", "after Commit");
                        break block17;
                    }
                    AQxmlError.throwAQEx(401, "conn = null");
                }
                finally {
                    if (sess_ctx.getSessionXid() != null) {
                        AQxmlDebug.trace(5, "AQxmlSessionMgr:commitUserSession", "before destroyProxy sess_xid != null");
                        sess_ctx.setSessionXid(null);
                        try {
                            this.destroyGlobalTxn(sess_ctx.getCurrentOCIHandles(serv_ctx), sess_ctx.getJNICtx());
                        }
                        catch (SQLException sql_ex) {
                            AQxmlDebug.traceEx(3, "AQxmlSessionMgr.commitUserSession-sql_ex2", sql_ex);
                        }
                    }
                    AQxmlDebug.trace(5, "AQxmlSessionMgr:commitUserSession", "after destroyProxy");
                }
            }
            catch (AQxmlException aqx_ex) {
                AQxmlDebug.traceEx(3, "AQxmlSessionMgr.commitUserSession-aqx_ex", aqx_ex);
                throw aqx_ex;
            }
            finally {
                sess_ctx.closeDBConnection(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void rollbackUserSession(AQxmlServContext serv_ctx, AQxmlSessionContext sess_ctx, AQxmlProcessor aq_proc) throws AQxmlException {
        block17: {
            Connection curr_conn = null;
            AQxmlDebug.trace(4, "AQxmlSessionMgr:rollbackUserSession", "Aborting ...");
            try {
                try {
                    curr_conn = sess_ctx.getCurrentDBConnection();
                    if (curr_conn != null) {
                        if (sess_ctx.getSessionXid() != null) {
                            AQxmlDebug.trace(5, "AQxmlSessionMgr:rollbackUserSession", "before globalTxnRollback");
                            try {
                                this.globalTxnRollback(sess_ctx.getCurrentOCIHandles(serv_ctx), sess_ctx.getJNICtx());
                            }
                            catch (SQLException sql_ex) {
                                AQxmlDebug.traceEx(3, "AQxmlSessionMgr.rollbackUserSession-sql_ex1", sql_ex);
                                AQxmlError.throwAQEx(410, sql_ex);
                            }
                        }
                        AQxmlDebug.trace(5, "AQxmlSessionMgr:rollbackUserSession", "after rollback");
                        break block17;
                    }
                    AQxmlError.throwAQEx(401, "conn = null");
                }
                finally {
                    if (sess_ctx.getSessionXid() != null) {
                        AQxmlDebug.trace(5, "AQxmlSessionMgr:rollbackUserSession", "before destroyProxy sess_xid != null");
                        sess_ctx.setSessionXid(null);
                        try {
                            this.destroyGlobalTxn(sess_ctx.getCurrentOCIHandles(serv_ctx), sess_ctx.getJNICtx());
                        }
                        catch (SQLException sql_ex) {
                            AQxmlDebug.traceEx(3, "AQxmlSessionMgr.rollbackUserSession-sql_ex2", sql_ex);
                        }
                    }
                    AQxmlDebug.trace(5, "AQxmlSessionMgr:rollbackUserSession", "after destroyProxy");
                }
            }
            catch (AQxmlException aqx_ex) {
                AQxmlDebug.traceEx(3, "AQxmlSessionMgr.rollbackUserSession-sqlex", aqx_ex);
                throw aqx_ex;
            }
            finally {
                sess_ctx.closeDBConnection(true);
            }
        }
    }

    synchronized int getUserOperation(AQxmlDocument aq_xml_doc, String[] own_queue) throws AQxmlException {
        int oper = -1;
        AQxmlProducerOption prod_opt = null;
        AQxmlConsumerOption cons_opt = null;
        AQxmlTypeInfoRequest qtyp_req = null;
        AQxmlSequenceNumRequest seq_req = null;
        Object dest = null;
        AQxmlDebug.trace(3, "AQxmlSessionMgr.getUserOperation", "entry");
        if (aq_xml_doc instanceof AQxmlSendRequest || aq_xml_doc instanceof AQxmlPublishRequest || aq_xml_doc instanceof AQxmlPushRequest) {
            prod_opt = ((AQxmlEnqueueRequest)aq_xml_doc).getProducerOption();
            own_queue[0] = prod_opt.getDestinationOwner();
            own_queue[1] = prod_opt.getDestinationName();
            oper = 0;
        } else if (aq_xml_doc instanceof AQxmlReceiveRequest) {
            cons_opt = ((AQxmlReceiveRequest)aq_xml_doc).getConsumerOption();
            own_queue[0] = cons_opt.getDestinationOwner();
            own_queue[1] = cons_opt.getDestinationName();
            oper = 1;
        } else if (aq_xml_doc instanceof AQxmlSequenceNumRequest) {
            oper = 2;
            seq_req = (AQxmlSequenceNumRequest)aq_xml_doc;
            own_queue[0] = seq_req.getQueueOwner();
            own_queue[1] = seq_req.getQueueName();
            AQxmlDebug.trace(3, "AQxmlSessionMgr.getUserOperation", "owner :" + own_queue[0]);
        } else if (aq_xml_doc instanceof AQxmlTypeInfoRequest) {
            oper = 2;
            qtyp_req = (AQxmlTypeInfoRequest)aq_xml_doc;
            own_queue[0] = qtyp_req.getQueueOwner();
            own_queue[1] = qtyp_req.getQueueName();
            AQxmlDebug.trace(3, "AQxmlSessionMgr.getUserOperation", "owner :" + own_queue[0]);
        } else if (aq_xml_doc instanceof AQxmlCommitRequest || aq_xml_doc instanceof AQxmlRollbackRequest || aq_xml_doc instanceof AQxmlRegisterRequest || aq_xml_doc instanceof StreamsSetupQueueRequest || aq_xml_doc instanceof StreamsAddTableRulesRequest || aq_xml_doc instanceof StreamsStartCaptureRequest || aq_xml_doc instanceof StreamsStartApplyRequest || aq_xml_doc instanceof StreamsAddTablePropagationRulesRequest) {
            oper = 2;
        } else {
            AQxmlDebug.trace(3, "AQxmlSessionMgr.getUserOperation", "doc: " + aq_xml_doc);
            AQxmlError.throwAQEx(401, "Invalid doc");
        }
        AQxmlDebug.trace(3, "AQxmlSessionMgr.getUserOperation", "oper = " + oper + " own_queue[0] = " + own_queue[0] + " own_queue[1] = " + own_queue[1]);
        AQxmlDebug.trace(3, "AQxmlSessionMgr.getUserOperation", "exit");
        return oper;
    }
}

