/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.util.Hashtable;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlDocument;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlRespConverter;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AQxmlIdapRespConverter {
    Document doc;
    static Hashtable envelopeHashtable;

    AQxmlIdapRespConverter() {
    }

    AQxmlIdapRespConverter(Document document) {
        AQxmlDebug.trace(4, "AQxmlConverter.AQxmlConverter", "Entry");
        this.doc = document;
    }

    void setDocument(Document document) {
        this.doc = document;
    }

    NodeList getRootNodeList() {
        NodeList root_nl = null;
        Node root_node = null;
        String nodename = null;
        NodeList root_cnl = null;
        root_nl = this.doc.getElementsByTagName("*");
        root_node = root_nl.item(0);
        nodename = root_node.getNodeName();
        AQxmlDebug.trace(5, "AQxmlConverter.getRootNodeList", "Root Node name: " + nodename);
        root_cnl = root_node.getChildNodes();
        return root_cnl;
    }

    Integer getNextIdapElement(Node n) throws AQxmlException {
        Integer xmlElement = null;
        String nodename = null;
        String local_name = null;
        Object namespace = null;
        nodename = n.getNodeName();
        AQxmlDebug.trace(5, "AQxmlConverter.genNextIdapElement", "Node name: " + nodename);
        local_name = ((XMLElement)n).getLocalName();
        AQxmlDebug.trace(5, "AQxmlConverter.genNextIdapElement", "Node Local Name: " + local_name);
        xmlElement = (Integer)envelopeHashtable.get(local_name.toUpperCase());
        AQxmlDebug.trace(5, "AQxmlConverter.genProducerOption", "XML ELEMENT: " + xmlElement);
        return xmlElement;
    }

    AQxmlDocument[] generateAQxmlDocument() throws AQxmlException {
        NodeList root_cnl = null;
        Node n = null;
        Integer xmlElement = null;
        NodeList cnl = null;
        AQxmlRespConverter conv = null;
        AQxmlDocument[] retDoc = null;
        AQxmlDebug.trace(4, "AQxmlIdapConverter.generateAQxmlDocument", "Entry");
        if (this.doc == null) {
            AQxmlDebug.trace(4, "AQxmlIdapConverter.generateAQxmlDocument", "Null doc");
        }
        root_cnl = this.getRootNodeList();
        try {
            AQxmlDebug.trace(5, "AQxmlIdapConverter.generateAQxmlDocument", "NL: " + root_cnl.getLength());
            block7: for (int i = 0; i < root_cnl.getLength(); ++i) {
                n = root_cnl.item(i);
                xmlElement = this.getNextIdapElement(n);
                if (xmlElement == null) {
                    AQxmlDebug.trace(4, "AQxmlConverter.generateAQxmlDocument", "Null Element");
                    continue;
                }
                switch (xmlElement) {
                    case 1020: {
                        AQxmlDebug.trace(5, "AQxmlConverter.generateAQxmlDocument", "ENVELOPE");
                        continue block7;
                    }
                    case 1000: {
                        cnl = n.getChildNodes();
                        conv = new AQxmlRespConverter();
                        retDoc = conv.generateAQxmlDocument(cnl);
                        continue block7;
                    }
                    case 1010: {
                        continue block7;
                    }
                    default: {
                        AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                    }
                }
            }
        }
        catch (AQxmlException aqxml_ex) {
            AQxmlDebug.traceEx(3, "AQxmlIdapConverter.generateAQxmlDocument-aqxml_ex", aqxml_ex);
            throw aqxml_ex;
        }
        return retDoc;
    }

    private static void initEnvelopeHashtable() {
        envelopeHashtable = new Hashtable();
        envelopeHashtable.put("BODY", new Integer(1000));
        envelopeHashtable.put("HEADER", new Integer(1010));
        envelopeHashtable.put("ENVELOPE", new Integer(1020));
    }

    static {
        AQxmlIdapRespConverter.initEnvelopeHashtable();
    }
}

