/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jdbc.pool.OracleOCIConnectionPool;

public class AQxmlDataSource {
    static final int DEFAULT_CACHE_SIZE = 50;
    static final int DEFAULT_CACHE_SCHEME = 1;
    static final String DATABASE_DRIVER = "oci8";
    String theUrl;
    String theHost;
    String thePort;
    String theDBDrv;
    String theSid;
    OracleOCIConnectionPool ocpool;
    int cache_size;
    int cache_scheme;

    public String getHost() {
        return this.theHost;
    }

    public String getPort() {
        return this.thePort;
    }

    public String getDBDrv() {
        return this.theDBDrv;
    }

    public String getSid() {
        return this.theSid;
    }

    public int getCacheSize() {
        return this.cache_size;
    }

    public int getCacheScheme() {
        return this.cache_scheme;
    }

    String getUrl() {
        return this.theUrl;
    }

    void setUrl(String aUrl) {
        this.theUrl = aUrl;
    }

    void setHost(String aHost) {
        this.theHost = aHost;
    }

    void setPort(String aPort) {
        this.thePort = aPort;
    }

    void setSid(String aSid) {
        this.theSid = aSid;
    }

    public AQxmlDataSource(String user, String password, String sid, String host, String port) throws AQxmlException {
        Properties prop = null;
        this.theHost = host;
        this.thePort = port;
        this.theSid = sid;
        this.theDBDrv = DATABASE_DRIVER;
        AQxmlDebug.trace(3, "AQxmlDataSource:constructor", "u/p/s/h/p - entry");
        try {
            this.buildUrl();
            this.cache_size = 50;
            this.cache_scheme = 1;
            prop = new Properties();
            prop.put("connpool_min_limit", "1");
            prop.put("connpool_increment", "1");
            prop.put("connpool_max_limit", Integer.toString(this.cache_size));
            prop.put("transactions_distributed", "true");
            this.ocpool = new OracleOCIConnectionPool(user, password, this.theUrl, prop);
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlDataSource:constructor- sql_ex", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
        AQxmlDebug.trace(3, "AQxmlDataSource:constructor", "exit");
    }

    public AQxmlDataSource(OracleOCIConnectionPool pool_ds) throws AQxmlException {
        AQxmlDebug.trace(3, "AQxmlDataSource:constructor", "pool_ds - entry");
        try {
            if (pool_ds != null) {
                this.ocpool = pool_ds;
            } else {
                AQxmlError.throwAQEx(419);
            }
            this.theUrl = this.ocpool.getURL();
            if (this.theUrl == null) {
                AQxmlError.throwAQEx(419);
            }
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlDataSource:constructor- sql_ex", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
        AQxmlDebug.trace(3, "AQxmlDataSource:constructor", "exit");
    }

    public void setCacheSize(int csize) throws AQxmlException {
        Properties prop = null;
        if (csize > 0) {
            this.cache_size = csize;
        } else {
            AQxmlError.throwAQEx(420);
        }
        try {
            prop = new Properties();
            prop.put("connpool_min_limit", "1");
            prop.put("connpool_increment", "1");
            prop.put("connpool_max_limit", Integer.toString(this.cache_size));
            this.ocpool.setPoolConfig(prop);
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlDataSource:setCacheSize- sql_ex", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
    }

    void setDBDrv(String driver) throws AQxmlException {
        if (driver.equalsIgnoreCase(DATABASE_DRIVER)) {
            this.theDBDrv = driver;
        } else {
            AQxmlError.throwAQEx(401, "invalid driver");
        }
    }

    void setCacheScheme(int scheme) throws AQxmlException {
    }

    void buildUrl() throws AQxmlException {
        String aHost = this.theHost;
        String aPort = this.thePort;
        String aSid = this.theSid;
        if (this.theDBDrv.toLowerCase().compareTo(DATABASE_DRIVER) == 0) {
            this.theUrl = new String("jdbc:oracle:oci8:");
            this.theUrl = this.theUrl.concat("@(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(PORT=" + aPort);
            this.theUrl = this.theUrl.concat(")(HOST=" + aHost + "))(CONNECT_DATA=(SID=" + aSid + ")))");
        } else if (this.theDBDrv.toLowerCase().compareTo("thin") == 0) {
            this.theUrl = new String("jdbc:oracle:thin:");
            this.theUrl = this.theUrl.concat("@" + aHost + ":" + aPort + ":" + aSid);
        } else {
            AQxmlError.throwAQEx(401, "invalid driver");
        }
    }

    public synchronized Connection getDBConnectionFromPool(String user) throws SQLException {
        Connection conn;
        Properties prop = new Properties();
        AQxmlDebug.trace(4, "AQxmlDataSource.getDBConnectionFromPool", "user: " + user);
        AQxmlDebug.trace(4, "AQxmlDataSource.getDBConnectionFromPool", "url: " + this.ocpool.getURL());
        if (user != null) {
            prop.put("proxy_user_name", user);
            conn = this.ocpool.getProxyConnection("proxytype_user_name", prop);
        } else {
            conn = this.ocpool.getConnection();
        }
        AQxmlDebug.trace(4, "AQxmlDataSource.getDBConnectionFromPool", "Active Size: " + this.ocpool.getActiveSize());
        AQxmlDebug.trace(4, "AQxmlDataSource.getDBConnectionFromPool", "Cache Size: " + this.ocpool.getPoolSize());
        conn.setAutoCommit(false);
        return conn;
    }

    public synchronized void close() {
        AQxmlDebug.trace(4, "AQxmlDataSource.close", "entry");
        if (this.ocpool != null) {
            try {
                AQxmlDebug.trace(4, "AQxmlDataSource.close", "closing conn pool");
                this.ocpool.close();
            }
            catch (Exception ex) {
                AQxmlDebug.traceEx(3, "AQxmlDataSource.close-ex", ex);
            }
            this.ocpool = null;
        }
        AQxmlDebug.trace(4, "AQxmlDataSource.close", "exit");
    }

    public void finalize() {
        this.close();
    }
}

