/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.AbstractGenerator;
import oracle.jdbc.driver.json.binary.OsonConstants;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.binary.StreamContext;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;

public final class OsonGeneratorImpl
extends AbstractGenerator
implements OracleJsonGenerator {
    private static boolean DEFAULT_SIMPLE_VALUE_SHARING = "true".equals(System.getProperty("oracle.jdbc.driver.json.binary.DEFAULT_SIMPLE_VALUE_SHARING", "false"));
    private static boolean DEFAULT_LAST_VALUE_SHARING = "true".equals(System.getProperty("oracle.jdbc.driver.json.binary.DEFAULT_LAST_VALUE_SHARING", "false"));
    private static boolean DEFAULT_RELATIVE_OFFSETS = "true".equals(System.getProperty("oracle.jdbc.driver.json.binary.DEFAULT_RELATIVE_OFFSETS", "false"));
    private static boolean DEFAULT_TINYNODE = "true".equals(System.getProperty("oracle.jdbc.driver.json.binary.DEFAULT_TINYNODE", "true"));
    private static final DuplicateKeyMode DEFAULT_DUPLICATE_KEY_MODE;
    private static int INITIAL_OPS;
    private static int OUT_BUFFER_SIZE;
    private static int SEEN_HASH_THRESHOLD;
    private static byte[] ONE;
    private static byte[] ZERO;
    private OsonGeneratorState state;

    public OsonGeneratorImpl(OsonGeneratorStatePool osonGeneratorStatePool, OutputStream outputStream) {
        this.state = osonGeneratorStatePool != null ? osonGeneratorStatePool.getState(outputStream) : new OsonGeneratorState(null, outputStream);
        this.state.reset(outputStream);
    }

    public void reset(OutputStream outputStream) {
        this.state.reset(outputStream);
    }

    public void setTinyNodeStat(boolean bl) {
        this.state.setTinyNodeStat(bl);
    }

    public void setUseRelativeOffsets(boolean bl) {
        this.state.setUseRelativeOffsets(bl);
    }

    public void setSimpleValueSharing(boolean bl) {
        this.state.setSimpleValueSharing(bl);
    }

    public void setLastValueSharing(boolean bl) {
        this.state.setLastValueSharing(bl);
    }

    public boolean getLastValueSharing() {
        return this.state.lastValueSharing;
    }

    public boolean getSimpleValuesharing() {
        return this.state.simpleValueSharing;
    }

    public boolean getRelativeOffsets() {
        return this.state.relativeOffsets;
    }

    @Override
    public OracleJsonGenerator writeStartObject() {
        this.state.writeStartObject();
        return this;
    }

    public OracleJsonGenerator writeStartObject(boolean bl) {
        if (bl) {
            this.state.writeStartObject();
        } else {
            this.state.writeStartObjectNoSort();
        }
        return this;
    }

    @Override
    public OracleJsonGenerator writeKey(String string) {
        this.state.writeKey(string);
        return this;
    }

    @Override
    public OracleJsonGenerator writeStartArray() {
        this.state.writeStartArray();
        return this;
    }

    @Override
    public OracleJsonGenerator writeEnd() {
        this.state.writeEnd();
        return this;
    }

    @Override
    public OracleJsonGenerator write(String string) {
        this.state.writeString(string);
        return this;
    }

    @Override
    public OracleJsonGenerator write(BigDecimal bigDecimal) {
        this.state.writeDecimal(bigDecimal);
        return this;
    }

    @Override
    public OracleJsonGenerator write(BigInteger bigInteger) {
        this.state.writeDecimal(bigInteger);
        return this;
    }

    @Override
    public OracleJsonGenerator write(int n2) {
        this.state.writeSB4(n2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(long l2) {
        this.state.writeSB8(l2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(double d2) {
        this.state.writeDouble(d2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(boolean bl) {
        this.state.writeBoolean(bl);
        return this;
    }

    @Override
    public OracleJsonGenerator writeNull() {
        this.state.writeNull();
        return this;
    }

    @Override
    public void close() {
        if (this.state != null) {
            this.state.close();
            if (this.state.pool != null) {
                this.state.pool.putState(this.state);
            }
            this.state = null;
        }
    }

    @Override
    public OracleJsonGenerator write(String string, byte[] byArray) {
        this.writeKey(string);
        this.write(byArray);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String string, LocalDateTime localDateTime) {
        this.writeKey(string);
        this.write(localDateTime);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String string, OffsetDateTime offsetDateTime) {
        this.writeKey(string);
        this.write(offsetDateTime);
        return this;
    }

    @Override
    public OracleJsonGenerator write(byte[] byArray) {
        this.state.writeBytes(byArray);
        return this;
    }

    @Override
    public OracleJsonGenerator writeId(byte[] byArray) {
        this.state.writeId(byArray);
        return this;
    }

    @Override
    public OracleJsonGenerator write(float f2) {
        this.state.writeFloat(f2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(LocalDateTime localDateTime) {
        byte[] byArray = OsonPrimitiveConversions.toOracleTimestamp(this.state.getExceptionFactory(), localDateTime);
        this.state.writeTimestamp(byArray);
        return this;
    }

    @Override
    public OracleJsonGenerator write(OffsetDateTime offsetDateTime) {
        byte[] byArray = OsonPrimitiveConversions.toOracleTimestampTZ(this.state.getExceptionFactory(), offsetDateTime);
        this.state.writeTimestampTZ(byArray);
        return this;
    }

    public OracleJsonGenerator writeIntervalDS(Duration duration) {
        byte[] byArray = OsonPrimitiveConversions.durationToIntervalDS(duration);
        this.state.writeIntervalDS(byArray);
        return this;
    }

    public OracleJsonGenerator writeIntervalYM(Period period) {
        byte[] byArray = OsonPrimitiveConversions.periodToIntervalYM(this.state.getExceptionFactory(), period);
        this.state.writeIntervalYM(byArray);
        return this;
    }

    public OracleJsonGenerator writeNumberAsString(BigDecimal bigDecimal) {
        this.state.writeNumberAsString(bigDecimal);
        return this;
    }

    @Override
    protected OracleJsonGenerator writeBinary(OracleJsonBinary oracleJsonBinary) {
        byte[] byArray = oracleJsonBinary.getBytes();
        if (oracleJsonBinary.isId()) {
            this.state.writeId(byArray);
        } else {
            this.state.writeBytes(byArray);
        }
        return this;
    }

    @Override
    protected OracleJsonGenerator writeDouble(OracleJsonDouble oracleJsonDouble) {
        return this.write(oracleJsonDouble.doubleValue());
    }

    @Override
    protected OracleJsonGenerator writeFloat(OracleJsonFloat oracleJsonFloat) {
        return this.write(oracleJsonFloat.floatValue());
    }

    public void writeDecimal(BigDecimal bigDecimal) {
        this.state.writeDecimal(bigDecimal);
    }

    public void writeSB4(int n2) {
        this.state.writeSB4(n2);
    }

    public void writeSB8(long l2) {
        this.state.writeSB8(l2);
    }

    @Override
    protected OracleJsonGenerator writeOraNumber(OracleJsonDecimal oracleJsonDecimal) {
        this.state.writeOraNumber(oracleJsonDecimal);
        return this;
    }

    @Override
    protected OracleJsonGenerator writeTimestamp(OracleJsonTimestamp oracleJsonTimestamp) {
        this.state.writeTimestamp(((OracleJsonTimestampImpl)oracleJsonTimestamp).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeTimestampTZ(OracleJsonTimestampTZ oracleJsonTimestampTZ) {
        this.state.writeTimestampTZ(((OracleJsonTimestampTZImpl)oracleJsonTimestampTZ).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeDate(OracleJsonDate oracleJsonDate) {
        this.state.writeDate(((OracleJsonDateImpl)oracleJsonDate).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeIntervalDS(OracleJsonIntervalDS oracleJsonIntervalDS) {
        this.state.writeIntervalDS(((OracleJsonIntervalDSImpl)oracleJsonIntervalDS).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeIntervalYM(OracleJsonIntervalYM oracleJsonIntervalYM) {
        this.state.writeIntervalYM(((OracleJsonIntervalYMImpl)oracleJsonIntervalYM).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeString(OracleJsonString oracleJsonString) {
        return this.write(oracleJsonString.getString());
    }

    @Override
    public void flush() {
    }

    @Override
    public OracleJsonGenerator write(Period period) {
        this.state.writeIntervalYM(OsonPrimitiveConversions.periodToIntervalYM(this.state.getExceptionFactory(), period));
        return this;
    }

    @Override
    public OracleJsonGenerator write(Duration duration) {
        this.state.writeIntervalDS(OsonPrimitiveConversions.durationToIntervalDS(duration));
        return this;
    }

    @Override
    protected void writeStringFromParser(OracleJsonParser oracleJsonParser) {
        if (oracleJsonParser instanceof OsonParserImpl) {
            OsonParserImpl osonParserImpl = (OsonParserImpl)oracleJsonParser;
            byte[] byArray = osonParserImpl.getContext().b.buffer.array();
            this.state.writeUTF8String(byArray, osonParserImpl.getCurrentStringPos(), osonParserImpl.getCurrentStringLen());
        } else {
            this.state.writeString(oracleJsonParser.getString());
        }
    }

    @Override
    protected void writeDecimalFromParser(OracleJsonParser oracleJsonParser) {
        this.write(oracleJsonParser.getValue());
    }

    public void setDuplicateKeyMode(DuplicateKeyMode duplicateKeyMode) {
        this.state.duplicateKeyMode = duplicateKeyMode;
    }

    static /* synthetic */ int access$100() {
        return INITIAL_OPS;
    }

    static /* synthetic */ int access$200() {
        return OUT_BUFFER_SIZE;
    }

    static {
        INITIAL_OPS = 64;
        OUT_BUFFER_SIZE = 8192;
        SEEN_HASH_THRESHOLD = 64;
        ONE = OsonPrimitiveConversions.toNumber(1);
        ZERO = OsonPrimitiveConversions.toNumber(0);
        String string = System.getProperty("oracle.jdbc.driver.json.binary.OsonGeneratorImpl.DEFAULT_DUPLICATE_KEY_MODE");
        DuplicateKeyMode duplicateKeyMode = null;
        duplicateKeyMode = string == null ? DuplicateKeyMode.DISALLOW : DuplicateKeyMode.valueOf(string);
        DEFAULT_DUPLICATE_KEY_MODE = duplicateKeyMode;
    }

    public static final class OsonGeneratorStatePool {
        private volatile WeakReference<ConcurrentLinkedQueue<OsonGeneratorState>> queue;

        private OsonGeneratorState getState(OutputStream outputStream) {
            ConcurrentLinkedQueue<OsonGeneratorState> concurrentLinkedQueue = this.getQueue();
            OsonGeneratorState osonGeneratorState = null;
            if (concurrentLinkedQueue != null) {
                osonGeneratorState = concurrentLinkedQueue.poll();
            }
            if (osonGeneratorState == null) {
                osonGeneratorState = new OsonGeneratorState(this, outputStream);
            }
            return osonGeneratorState;
        }

        private void putState(OsonGeneratorState osonGeneratorState) {
            ConcurrentLinkedQueue<OsonGeneratorState> concurrentLinkedQueue = this.getQueue();
            if (concurrentLinkedQueue == null) {
                concurrentLinkedQueue = new ConcurrentLinkedQueue();
                concurrentLinkedQueue.offer(osonGeneratorState);
                this.queue = new WeakReference<ConcurrentLinkedQueue<OsonGeneratorState>>(concurrentLinkedQueue);
            } else {
                concurrentLinkedQueue.offer(osonGeneratorState);
            }
        }

        private ConcurrentLinkedQueue<OsonGeneratorState> getQueue() {
            WeakReference<ConcurrentLinkedQueue<OsonGeneratorState>> weakReference = this.queue;
            return weakReference == null ? null : (ConcurrentLinkedQueue)weakReference.get();
        }
    }

    private static final class OsonGeneratorState {
        private int[][] keys = new int[256][];
        private int[][] keysLastSeenValue;
        private boolean keysNeedReset = true;
        int[] seenHash = new int[OsonGeneratorImpl.access$000()];
        int seenHashSize;
        int keyI;
        int keyJ;
        private String[] distinctKeys = new String[16];
        private int distinctKeysSize;
        private byte[] keyHeap;
        private int keyHeapSize;
        private int[] keyHeapOffsets;
        private int[] fidMap;
        private int numOps;
        private byte[] ops = new byte[OsonGeneratorImpl.access$100()];
        private int[] nextSiblings = new int[OsonGeneratorImpl.access$100()];
        private int[] fieldIDs = new int[OsonGeneratorImpl.access$100()];
        private byte[] depths = new byte[OsonGeneratorImpl.access$100()];
        private int[] valueIndex = new int[OsonGeneratorImpl.access$100()];
        private int[] numChildren = new int[OsonGeneratorImpl.access$100()];
        private int[] offsets;
        private int treeSegmentSize;
        private byte[] valueHeap = new byte[1024];
        private int valueHeapSize;
        private int tinyNodeCount;
        short headerFlags;
        private int[] opStack = new int[2];
        private byte depth;
        private int previousSiblingIdx;
        private int[] temporaryIntArray;
        private long[] temporaryLongArray;
        private final StreamContext ctx = new StreamContext(null);
        private OutputStream out;
        private byte[] outBuffer = new byte[OsonGeneratorImpl.access$200()];
        private int outBufferPos;
        public boolean relativeOffsets;
        public boolean simpleValueSharing;
        public boolean lastValueSharing;
        int opNull;
        int opTrue;
        int opFalse;
        int opZero;
        int opOne;
        int opEmptyString;
        int opEmptyObject;
        int opEmptyArray;
        int opLastValue;
        private OsonGeneratorStatePool pool;
        private DuplicateKeyMode duplicateKeyMode = OsonGeneratorImpl.access$300();

        private OsonGeneratorState(OsonGeneratorStatePool osonGeneratorStatePool, OutputStream outputStream) {
            this.pool = osonGeneratorStatePool;
            this.out = outputStream;
            this.ctx.setExceptionFactory(this.getExceptionFactory());
        }

        private void writeNumber(byte[] byArray) {
            if (byArray.length <= 8) {
                int n2 = byArray.length - 1 | OsonConstants.MASK_ORANUM_16;
                if (this.simpleValueSharing) {
                    if (Arrays.equals(ONE, byArray)) {
                        this.addOpAndValueNoPostOp(n2, byArray);
                        if (this.opOne == -1) {
                            this.opOne = this.numOps - 1;
                        } else {
                            this.headerFlags = (short)(this.headerFlags | 0x20);
                            this.markDuplicate(this.numOps - 1, this.opOne);
                        }
                        this.postOp(false);
                        return;
                    }
                    if (Arrays.equals(ZERO, byArray)) {
                        this.addOpAndValueNoPostOp(n2, byArray);
                        if (this.opZero == -1) {
                            this.opZero = this.numOps - 1;
                        } else {
                            this.headerFlags = (short)(this.headerFlags | 0x20);
                            this.markDuplicate(this.numOps - 1, this.opZero);
                        }
                        this.postOp(false);
                        return;
                    }
                }
                this.addOpAndValue(n2, byArray);
            } else if (byArray.length < 256) {
                this.addOpAndValue(52, byArray);
            }
        }

        private void push(int n2) {
            if (this.ctx.depth >= this.opStack.length) {
                this.opStack = Arrays.copyOf(this.opStack, this.opStack.length * 2);
            }
            this.opStack[this.depth] = n2;
            this.depth = (byte)(this.depth + 1);
            this.previousSiblingIdx = -1;
        }

        private void addOp(int n2) {
            int n3 = this.numOps++;
            this.ops[n3] = (byte)n2;
            this.depths[n3] = this.depth;
            if (this.previousSiblingIdx != -1) {
                this.nextSiblings[this.previousSiblingIdx] = n3;
            }
            this.nextSiblings[n3] = -1;
            if (this.depth > 0) {
                int n4 = this.opStack[this.depth - 1];
                this.numChildren[n4] = this.numChildren[n4] + 1;
            }
            this.previousSiblingIdx = n3;
        }

        private void expandOp() {
            int n2 = this.ops.length * 2;
            this.ops = Arrays.copyOf(this.ops, n2);
            this.nextSiblings = Arrays.copyOf(this.nextSiblings, n2);
            this.fieldIDs = Arrays.copyOf(this.fieldIDs, n2);
            this.depths = Arrays.copyOf(this.depths, n2);
            this.numChildren = Arrays.copyOf(this.numChildren, n2);
            this.valueIndex = Arrays.copyOf(this.valueIndex, n2);
        }

        private void preOp() {
            if (this.numOps >= this.ops.length) {
                this.expandOp();
            }
            this.numChildren[this.numOps] = 0;
        }

        private void postOp(boolean bl) {
            if (this.lastValueSharing && this.keyI != -1 && this.keyJ != -1) {
                this.initKeysLastSeenValue(this.keyI);
                int n2 = this.numOps - 1;
                if (this.numChildren[n2] >= 0 && bl) {
                    this.keysLastSeenValue[this.keyI][this.keyJ] = n2;
                }
                this.keyJ = -1;
                this.keyI = -1;
            }
            this.opLastValue = -1;
        }

        private void addValue(byte[] byArray) {
            this.expandValueHeap(byArray.length);
            this.addValueNoCheck(byArray);
        }

        private void addValueNoCheck(byte[] byArray) {
            this.valueIndex[this.numOps] = this.valueHeapSize;
            System.arraycopy(byArray, 0, this.valueHeap, this.valueHeapSize, byArray.length);
            this.valueHeapSize += byArray.length;
        }

        private boolean equals(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                if (byArray[n2] != byArray2[n3]) {
                    return false;
                }
                ++n2;
                ++n3;
            }
            return true;
        }

        private void expandValueHeap(int n2) {
            if (n2 + this.valueHeapSize >= this.valueHeap.length) {
                int n3 = (n2 + this.valueHeapSize) * 2;
                if (n3 <= 0) {
                    throw OracleJsonExceptions.IMAGE_TOO_BIG.create(this.getExceptionFactory(), new Object[0]);
                }
                this.valueHeap = Arrays.copyOf(this.valueHeap, n3);
            }
        }

        private void initializeKeyHeap() throws UnsupportedEncodingException {
            if (this.keyHeap == null) {
                this.keyHeap = new byte[this.distinctKeysSize * 15];
            }
            if (this.keyHeapOffsets == null || this.keyHeapOffsets.length < this.distinctKeysSize) {
                this.keyHeapOffsets = new int[this.distinctKeysSize];
            }
            this.keyHeapSize = 0;
            for (int i2 = 0; i2 < this.distinctKeysSize; ++i2) {
                int n2;
                int n3;
                this.keyHeapOffsets[i2] = this.keyHeapSize;
                String string = this.distinctKeys[i2];
                int n4 = 1 + string.length() * 4;
                if (n4 + this.keyHeapSize >= this.keyHeap.length) {
                    this.keyHeap = Arrays.copyOf(this.keyHeap, (this.keyHeap.length + n4) * 2);
                }
                if ((n3 = (n2 = this.writeString(string, this.keyHeap, this.keyHeapSize + 1)) - this.keyHeapSize - 1) > 256) {
                    throw OracleJsonExceptions.LONG_KEY.create(this.getExceptionFactory(), string);
                }
                this.keyHeap[this.keyHeapSize] = (byte)n3;
                this.keyHeapSize = n2;
            }
        }

        public OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
            return OracleJsonExceptions.ORACLE_FACTORY;
        }

        private int writeString(String string, byte[] byArray, int n2) {
            int n3 = n2;
            int n4 = string.length();
            for (int i2 = 0; i2 < n4; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 >= '\u007f') {
                    return this.slowWriteString(string, byArray, n2);
                }
                byArray[n3++] = (byte)c2;
            }
            return n3;
        }

        private int writeUTF8String(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
            int n5 = n4;
            for (int i2 = 0; i2 < n3; ++i2) {
                byArray2[n5++] = byArray[n2++];
            }
            return n5;
        }

        private int slowWriteString(String string, byte[] byArray, int n2) {
            byte[] byArray2 = string.getBytes(StandardCharsets.UTF_8);
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                byArray[n2++] = byArray2[i2];
            }
            return n2;
        }

        private void writeHeader() throws IOException {
            this.writeInt(-11904511);
            if (this.distinctKeysSize >= 65536) {
                this.headerFlags = (short)(this.headerFlags | 8);
            } else if (this.distinctKeysSize >= 256) {
                this.headerFlags = (short)(this.headerFlags | 0x400);
            }
            if (this.distinctKeysSize > 0) {
                this.headerFlags = (short)(this.headerFlags | 0x100);
            }
            if (this.keyHeapSize >= 65536) {
                this.headerFlags = (short)(this.headerFlags | 0x800);
            }
            if (this.treeSegmentSize > 65536) {
                this.headerFlags = (short)(this.headerFlags | 0x1000);
            }
            if (this.relativeOffsets) {
                this.headerFlags = (short)(this.headerFlags | 1);
            }
            if (this.numOps == 1 && !this.isObject(this.ops[0]) && !this.isArray(this.ops[0])) {
                int n2 = this.headerFlags;
                n2 &= 0xFFFFDFFF;
                this.writeShort(n2 |= 0x10);
                this.writeTreeSegmentSize();
                return;
            }
            this.writeShort(this.headerFlags);
            if (this.distinctKeysSize >= 65536) {
                this.writeInt(this.distinctKeysSize);
            } else if (this.distinctKeysSize >= 256) {
                this.writeShort(this.distinctKeysSize);
            } else {
                this.writeByte(this.distinctKeysSize);
            }
            if (this.keyHeapSize >= 65536) {
                this.writeInt(this.keyHeapSize);
            } else {
                this.writeShort(this.keyHeapSize);
            }
            this.writeTreeSegmentSize();
            if ((this.headerFlags & 0x2000) != 0) {
                this.writeShort(this.tinyNodeCount);
            } else {
                this.writeShort(0);
            }
        }

        private void writeTreeSegmentSize() throws IOException {
            if (this.treeSegmentSize > 65536) {
                this.writeInt(this.treeSegmentSize);
            } else {
                this.writeShort(this.treeSegmentSize);
            }
        }

        private void writeNameDictionary() throws IOException {
            if (this.fidMap == null || this.fidMap.length < this.distinctKeysSize) {
                this.fidMap = new int[this.distinctKeysSize];
            }
            this.initTemporaryIntArray(this.distinctKeysSize);
            if (this.seenHashSize < SEEN_HASH_THRESHOLD) {
                Arrays.sort(this.seenHash, 0, this.seenHashSize);
                int n2 = 0;
                for (int i2 = 0; i2 < this.seenHashSize; ++i2) {
                    int n3 = this.seenHash[i2];
                    n2 = this.processBucket(n2, n3);
                }
            } else {
                int n4 = 0;
                for (int i3 = 0; i3 < this.keys.length; ++i3) {
                    if (this.keys[i3] == null) continue;
                    n4 = this.processBucket(n4, i3);
                }
            }
            this.keysNeedReset = false;
            if (this.keyHeapSize >= 65536) {
                this.writeUb4Array(this.temporaryIntArray, this.distinctKeysSize);
            } else {
                this.writeUb2Array(this.temporaryIntArray, this.distinctKeysSize);
            }
            this.write(this.keyHeap, 0, this.keyHeapSize);
        }

        private int processBucket(int n2, int n3) throws IOException {
            int n4;
            int[] nArray = this.keys[n3];
            int[] nArray2 = this.lastValueSharing ? this.keysLastSeenValue[n3] : null;
            this.sortBucket(nArray);
            for (int i2 = 0; i2 < nArray.length && (n4 = nArray[i2] - 1) != -1; ++i2) {
                this.writeByte(n3);
                nArray[i2] = 0;
                if (this.lastValueSharing) {
                    nArray2[i2] = 0;
                }
                this.fidMap[n4] = n2;
                this.temporaryIntArray[n2++] = this.keyHeapOffsets[n4];
            }
            return n2;
        }

        private void sortBucket(int[] nArray) {
            for (int i2 = 0; i2 < nArray.length && nArray[i2] != 0; ++i2) {
                for (int i3 = i2 + 1; i3 < nArray.length && nArray[i3] != 0; ++i3) {
                    int n2 = this.keyHeapOffsets[nArray[i3] - 1];
                    int n3 = this.keyHeap[n2] & 0xFF;
                    int n4 = this.keyHeapOffsets[nArray[i2] - 1];
                    int n5 = this.keyHeap[n4] & 0xFF;
                    if (n3 >= n5 && (n3 != n5 || this.memcmp(n2 + 1, n4 + 1, n5) >= 0)) continue;
                    int n6 = nArray[i2];
                    nArray[i2] = nArray[i3];
                    nArray[i3] = n6;
                }
            }
        }

        private int memcmp(int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = (this.keyHeap[n2 + i2] & 0xFF) - (this.keyHeap[n3 + i2] & 0xFF);
                if (n5 == 0) continue;
                return n5;
            }
            return 0;
        }

        private void writeTreeNodeSegment() throws IOException {
            block20: for (int i2 = 0; i2 < this.numOps; ++i2) {
                int n2;
                int n3;
                int n4;
                int n5;
                byte by = this.ops[i2];
                if (this.isShared(i2)) continue;
                if (this.isArray(by)) {
                    n5 = this.offsets[i2];
                    n4 = this.numChildren[i2];
                    this.writeByte(this.flagObjectOrArray(by, n4));
                    if (n4 < 256) {
                        this.writeByte(n4);
                    } else if (n4 < 65536) {
                        this.writeShort(n4);
                    } else {
                        this.writeInt(n4);
                    }
                    this.initTemporaryIntArray(n4);
                    n3 = i2 + 1;
                    for (n2 = 0; n2 < n4; ++n2) {
                        this.temporaryIntArray[n2] = this.offsets[n3];
                        n3 = this.nextSiblings[n3];
                    }
                    this.writeChildOffsets(n4, this.temporaryIntArray, n5);
                    continue;
                }
                if (this.isObject(by)) {
                    int n6;
                    n5 = this.offsets[i2];
                    n4 = this.numChildren[i2];
                    this.writeByte(this.flagObject(by, n4));
                    this.initTemporaryLongArray(n4);
                    if (this.sharesFields(by)) {
                        n3 = this.firstChild(i2);
                        n2 = this.fieldIDs[n3];
                        n6 = this.offsets[n2];
                        this.fieldIDs[n3] = this.fieldIDs[this.firstChild(n2)];
                        if (this.treeSegmentSize < 65536) {
                            this.writeShort(n6);
                        } else {
                            this.writeInt(n6);
                        }
                        this.packOffsets(i2, n4, this.temporaryLongArray);
                        if (n4 > 10 && (by & 4) == 0) {
                            Arrays.sort(this.temporaryLongArray, 0, n4);
                        }
                        this.writeChildOffsets(n4, this.temporaryLongArray, n5);
                        continue;
                    }
                    this.packOffsets(i2, n4, this.temporaryLongArray);
                    if (n4 > 10 && (by & 4) == 0) {
                        Arrays.sort(this.temporaryLongArray, 0, n4);
                    } else if (this.duplicateKeyMode == DuplicateKeyMode.DISALLOW) {
                        this.checkDuplicateKeys(this.temporaryLongArray, n4);
                    }
                    if (n4 < 256) {
                        this.writeByte(n4);
                    } else if (n4 < 65536) {
                        this.writeShort(n4);
                    } else {
                        this.writeInt(n4);
                    }
                    n3 = -1;
                    for (n2 = 0; n2 < n4; ++n2) {
                        n6 = this.unpackFid(this.temporaryLongArray[n2]);
                        if (n6 == n3 && this.duplicateKeyMode == DuplicateKeyMode.DISALLOW) {
                            throw OracleJsonExceptions.DUPLICATE_KEY.create(this.getExceptionFactory(), this.reverseFidMap(n6));
                        }
                        n3 = n6;
                        if (this.distinctKeysSize >= 65536) {
                            this.writeInt(n6);
                            continue;
                        }
                        if (this.distinctKeysSize >= 256) {
                            this.writeShort(n6);
                            continue;
                        }
                        this.writeByte(n6);
                    }
                    this.writeChildOffsets(n4, this.temporaryLongArray, n5);
                    continue;
                }
                if (by <= 31) {
                    this.writeOpAndData(by, this.valueHeap, this.valueIndex[i2], by);
                    continue;
                }
                if (OsonConstants.isSB4(by) || OsonConstants.isSB8(by) || OsonConstants.isOraNum16(by) || OsonConstants.isDec_16(by)) {
                    this.writeByte(by);
                    this.write(this.valueHeap, this.valueIndex[i2], this.numChildren[i2]);
                    continue;
                }
                switch (by) {
                    case 49: {
                        this.writeByte(by);
                        continue block20;
                    }
                    case 50: {
                        this.writeByte(by);
                        continue block20;
                    }
                    case 48: {
                        this.writeByte(by);
                        continue block20;
                    }
                    case 51: 
                    case 52: 
                    case 116: {
                        this.writeByte(by);
                        n5 = this.numChildren[i2];
                        this.writeByte(n5);
                        this.write(this.valueHeap, this.valueIndex[i2], n5);
                        continue block20;
                    }
                    case 55: {
                        this.writeByte(by);
                        n5 = this.numChildren[i2];
                        this.writeShort(n5);
                        this.write(this.valueHeap, this.valueIndex[i2], n5);
                        continue block20;
                    }
                    case 56: {
                        this.writeByte(by);
                        n5 = this.numChildren[i2];
                        this.writeInt(n5);
                        this.write(this.valueHeap, this.valueIndex[i2], n5);
                        continue block20;
                    }
                    case 54: {
                        this.writeByte(by);
                        this.write(this.valueHeap, this.valueIndex[i2], 8);
                        continue block20;
                    }
                    case 127: {
                        this.writeByte(by);
                        this.write(this.valueHeap, this.valueIndex[i2], 4);
                        continue block20;
                    }
                    case 126: {
                        this.writeByte(by);
                        n5 = this.numChildren[i2];
                        this.writeByte(n5);
                        this.write(this.valueHeap, this.valueIndex[i2], n5);
                        continue block20;
                    }
                    case 58: {
                        this.writeByte(by);
                        n5 = this.numChildren[i2];
                        this.writeShort(n5);
                        this.write(this.valueHeap, this.valueIndex[i2], n5);
                        continue block20;
                    }
                    case 59: {
                        this.writeByte(by);
                        n5 = this.numChildren[i2];
                        this.writeInt(n5);
                        this.write(this.valueHeap, this.valueIndex[i2], n5);
                        continue block20;
                    }
                    case 57: {
                        this.writeByte(by);
                        this.write(this.valueHeap, this.valueIndex[i2], OsonPrimitiveConversions.SIZE_TIMESTAMP);
                        continue block20;
                    }
                    case 125: {
                        this.writeByte(by);
                        this.write(this.valueHeap, this.valueIndex[i2], OsonPrimitiveConversions.SIZE_TIMESTAMP_NOFRAC);
                        continue block20;
                    }
                    case 124: {
                        this.writeByte(by);
                        this.write(this.valueHeap, this.valueIndex[i2], OsonPrimitiveConversions.SIZE_TIMESTAMPTZ);
                        continue block20;
                    }
                    case 60: {
                        this.writeByte(by);
                        this.write(this.valueHeap, this.valueIndex[i2], OsonPrimitiveConversions.SIZE_DATE);
                        continue block20;
                    }
                    case 62: {
                        this.writeByte(by);
                        this.write(this.valueHeap, this.valueIndex[i2], 11);
                        continue block20;
                    }
                    case 61: {
                        this.writeByte(by);
                        this.write(this.valueHeap, this.valueIndex[i2], 5);
                        continue block20;
                    }
                    case 53: {
                        n5 = this.numChildren[i2];
                        if (n5 == 0) continue block20;
                        this.writeByte(by);
                        this.writeByte(n5);
                        this.write(this.valueHeap, this.valueIndex[i2], n5);
                        continue block20;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.valueOf(by));
                    }
                }
            }
        }

        private String reverseFidMap(int n2) {
            for (int i2 = 0; i2 < this.distinctKeysSize; ++i2) {
                if (this.fidMap[i2] != n2 - 1) continue;
                return this.distinctKeys[i2];
            }
            return "";
        }

        private void packOffsets(int n2, int n3, long[] lArray) {
            int n4 = n2 + 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5 = this.fieldIDs[n4];
                long l2 = this.fidMap[n5] + 1;
                lArray[i2] = l2 << 32 | (long)this.offsets[n4];
                n4 = this.nextSiblings[n4];
            }
        }

        private boolean sharesFields(int n2) {
            return (n2 & 0x18) == 24;
        }

        private boolean isReferredTo(int n2) {
            return (n2 & 2) == 2;
        }

        private void tryFieldIdSharing(int n2) {
            int n3 = this.nextSiblings[n2];
            while (n3 != -1) {
                if (this.sameFieldIds(n2, n3)) {
                    int n4 = n3;
                    this.ops[n4] = (byte)(this.ops[n4] | 0x18);
                    int n5 = n2;
                    this.ops[n5] = (byte)(this.ops[n5] | 2);
                    int n6 = this.firstChild(n3);
                    this.fieldIDs[n6] = n2;
                }
                n3 = this.nextSiblings[n3];
            }
        }

        private int firstChild(int n2) {
            if (n2 + 1 >= this.numOps) {
                return -1;
            }
            byte by = this.depths[n2 + 1];
            byte by2 = this.depths[n2];
            if (by == by2 + 1) {
                return n2 + 1;
            }
            return -1;
        }

        private boolean sameFieldIds(int n2, int n3) {
            if (!this.isObject(this.ops[n2]) || !this.isObject(this.ops[n3]) || this.numChildren[n2] != this.numChildren[n3] || this.numChildren[n2] == 0 || (this.ops[n2] & 4) != 0 || (this.ops[n3] & 4) != 0) {
                return false;
            }
            int n4 = this.firstChild(n2);
            int n5 = this.firstChild(n3);
            do {
                if (this.fieldIDs[n4] != this.fieldIDs[n5]) {
                    return false;
                }
                n4 = this.nextSiblings[n4];
                n5 = this.nextSiblings[n5];
                if (n4 != -1) continue;
                return n5 == -1;
            } while (n5 != -1);
            return false;
        }

        private boolean isArray(int n2) {
            return (n2 & 0xC0) == 192;
        }

        private boolean isObject(int n2) {
            return (n2 & 0xC0) == 128;
        }

        private boolean isStructure(int n2) {
            return n2 < 0;
        }

        private void writeChildOffsets(int n2, long[] lArray, int n3) throws IOException {
            int n4;
            int n5 = n4 = this.relativeOffsets ? n3 : 0;
            if (this.treeSegmentSize < 65536) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    short s2 = (short)(lArray[i2] & 0xFFFFL);
                    s2 = (short)(s2 - n4);
                    this.writeShort(s2);
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n6 = (int)(lArray[i3] & 0xFFFFFFFFFFFFFFFFL);
                    this.writeInt(n6 -= n4);
                }
            }
        }

        private void writeChildOffsets(int n2, int[] nArray, int n3) throws IOException {
            int n4;
            int n5 = n4 = this.relativeOffsets ? n3 : 0;
            if (this.treeSegmentSize < 65536) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    short s2 = (short)(nArray[i2] & 0xFFFF);
                    this.writeShort(s2 - n4);
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n6 = nArray[i3];
                    this.writeInt(n6 - n4);
                }
            }
        }

        private void initTemporaryLongArray(int n2) {
            if (this.temporaryLongArray == null || this.temporaryLongArray.length < n2) {
                this.temporaryLongArray = new long[n2];
            }
        }

        private int unpackFid(long l2) {
            return (int)(l2 >>> 32);
        }

        public void checkDuplicateKeys(long[] lArray, int n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.unpackFid(lArray[i2]);
                for (int i3 = i2 + 1; i3 < n2; ++i3) {
                    if (this.unpackFid(lArray[i3]) != n3) continue;
                    throw OracleJsonExceptions.DUPLICATE_KEY.create(this.getExceptionFactory(), this.distinctKeys[n3 - 1]);
                }
            }
        }

        private void initTemporaryIntArray(int n2) {
            if (this.temporaryIntArray == null || this.temporaryIntArray.length < n2) {
                this.temporaryIntArray = new int[n2];
            }
        }

        private void computeOffsets() {
            int n2;
            int n3;
            if (this.offsets == null || this.numOps > this.offsets.length) {
                this.offsets = new int[this.numOps];
            }
            int n4 = 0;
            this.tinyNodeCount = 0;
            for (n3 = 0; n3 < this.numOps; ++n3) {
                if (this.isShared(n3)) {
                    this.offsets[n3] = this.offsets[-this.numChildren[n3]];
                    continue;
                }
                this.offsets[n3] = n4;
                if (this.isFirstChildObjectOfArray(n3)) {
                    this.tryFieldIdSharing(n3);
                }
                n2 = this.sizeOfOp(n3, 2);
                this.countTiny(n3, n2);
                if ((n4 += n2) < 65536) continue;
                n4 = -1;
                break;
            }
            if (n4 != -1) {
                this.treeSegmentSize = n4;
                return;
            }
            n4 = 0;
            this.tinyNodeCount = 0;
            for (n3 = 0; n3 < this.numOps; ++n3) {
                if (this.isShared(n3)) {
                    this.offsets[n3] = this.offsets[-this.numChildren[n3]];
                    continue;
                }
                this.offsets[n3] = n4;
                if (this.isFirstChildObjectOfArray(n3)) {
                    this.tryFieldIdSharing(n3);
                }
                n2 = this.sizeOfOp(n3, 4);
                this.countTiny(n3, n2);
                if ((n4 += n2) >= 0) continue;
                throw OracleJsonExceptions.IMAGE_TOO_BIG.create(this.getExceptionFactory(), new Object[0]);
            }
            this.treeSegmentSize = n4;
        }

        private boolean isShared(int n2) {
            return this.numChildren[n2] < 0;
        }

        private void countTiny(int n2, int n3) {
            if (this.isStructure(this.ops[n2]) && (n3 < 5 || this.isObject(this.ops[n2]) && this.isReferredTo(this.ops[n2]))) {
                ++this.tinyNodeCount;
            }
        }

        private boolean isFirstChildObjectOfArray(int n2) {
            return this.isObject(this.ops[n2]) && n2 > 0 && this.firstChild(n2 - 1) == n2 && this.isArray(this.ops[n2 - 1]);
        }

        private int sizeOfOp(int n2, int n3) {
            byte by = this.ops[n2];
            if (this.isShared(n2)) {
                return 0;
            }
            if (this.isArray(by)) {
                int n4 = this.numChildren[n2];
                int n5 = this.bytesForNum(n4);
                int n6 = 1 + n5;
                return n6 += n3 * n4;
            }
            if (this.isObject(by)) {
                int n7 = this.numChildren[n2];
                if (this.sharesFields(by)) {
                    return 1 + n3 + n7 * n3;
                }
                int n8 = this.bytesForNum(n7);
                int n9 = n7;
                if (this.distinctKeysSize >= 65536) {
                    n9 *= 4;
                } else if (this.distinctKeysSize >= 256) {
                    n9 *= 2;
                }
                int n10 = 1 + n8 + n9;
                return n10 += n7 * n3;
            }
            if (by <= 31) {
                return 1 + by;
            }
            if (OsonConstants.isSB4(by) || OsonConstants.isSB8(by) || OsonConstants.isOraNum16(by) || OsonConstants.isDec_16(by)) {
                return 1 + this.numChildren[n2];
            }
            switch (by) {
                case 49: {
                    return 1;
                }
                case 50: {
                    return 1;
                }
                case 48: {
                    return 1;
                }
                case 51: {
                    return 2 + this.numChildren[n2];
                }
                case 55: {
                    return 3 + this.numChildren[n2];
                }
                case 56: {
                    return 5 + this.numChildren[n2];
                }
                case 52: 
                case 116: {
                    return 2 + this.numChildren[n2];
                }
                case 54: {
                    return 9;
                }
                case 127: {
                    return 5;
                }
                case 58: {
                    return 3 + this.numChildren[n2];
                }
                case 59: {
                    return 5 + this.numChildren[n2];
                }
                case 126: {
                    return 2 + this.numChildren[n2];
                }
                case 57: {
                    return OsonPrimitiveConversions.SIZE_TIMESTAMP + 1;
                }
                case 125: {
                    return OsonPrimitiveConversions.SIZE_TIMESTAMP_NOFRAC + 1;
                }
                case 124: {
                    return OsonPrimitiveConversions.SIZE_TIMESTAMPTZ + 1;
                }
                case 60: {
                    return OsonPrimitiveConversions.SIZE_DATE + 1;
                }
                case 62: {
                    return 12;
                }
                case 61: {
                    return 6;
                }
                case 53: {
                    int n11 = this.numChildren[n2];
                    return n11 == 0 ? 0 : 2 + n11;
                }
            }
            throw new UnsupportedOperationException(String.valueOf(by));
        }

        private int bytesForNum(int n2) {
            if (n2 < 256) {
                return 1;
            }
            if (n2 < 65536) {
                return 2;
            }
            return 4;
        }

        private int flagObject(int n2, int n3) {
            if (n3 <= 10) {
                return this.flagObjectOrArray(n2, n3) | 4;
            }
            return this.flagObjectOrArray(n2, n3);
        }

        private int flagObjectOrArray(int n2, int n3) {
            if (n3 >= 256) {
                n2 = n3 < 65536 ? (n2 |= 8) : (n2 |= 0x10);
            }
            if (this.treeSegmentSize > 65536) {
                n2 |= 0x20;
            }
            return n2;
        }

        private void writeUb2Array(int[] nArray, int n2) throws IOException {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.writeShort(nArray[i2]);
            }
        }

        private void writeUb4Array(int[] nArray, int n2) throws IOException {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.writeInt(nArray[i2]);
            }
        }

        private final void writeInt(int n2) throws IOException {
            if (this.outBufferPos + 3 >= this.outBuffer.length) {
                this.flushBuffer();
            }
            this.outBuffer[this.outBufferPos++] = (byte)(n2 >>> 24 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(n2 >>> 16 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(n2 >>> 8 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(n2 >>> 0 & 0xFF);
        }

        private final void writeShort(int n2) throws IOException {
            if (this.outBufferPos + 1 >= this.outBuffer.length) {
                this.flushBuffer();
            }
            this.outBuffer[this.outBufferPos++] = (byte)(n2 >>> 8 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(n2 >>> 0 & 0xFF);
        }

        private final void writeByte(int n2) throws IOException {
            if (this.outBufferPos >= this.outBuffer.length) {
                this.flushBuffer();
            }
            this.outBuffer[this.outBufferPos++] = (byte)n2;
        }

        private void flushBuffer() throws IOException {
            this.out.write(this.outBuffer, 0, this.outBufferPos);
            this.outBufferPos = 0;
        }

        private final void write(byte[] byArray, int n2, int n3) throws IOException {
            if (this.outBufferPos + n3 > this.outBuffer.length) {
                this.flushBuffer();
                if (n3 >= this.outBuffer.length) {
                    this.out.write(byArray, n2, n3);
                    return;
                }
            }
            System.arraycopy(byArray, n2, this.outBuffer, this.outBufferPos, n3);
            this.outBufferPos += n3;
        }

        private final void writeOpAndData(int n2, byte[] byArray, int n3, int n4) throws IOException {
            if (this.outBufferPos + (n4 + 1) > this.outBuffer.length) {
                this.flushBuffer();
                if (n4 + 1 >= this.outBuffer.length) {
                    this.out.write(n2);
                    this.out.write(byArray, n3, n4);
                    return;
                }
            }
            this.outBuffer[this.outBufferPos++] = (byte)n2;
            System.arraycopy(byArray, n3, this.outBuffer, this.outBufferPos, n4);
            this.outBufferPos += n4;
        }

        private void reset(OutputStream outputStream) {
            this.out = outputStream;
            this.valueHeapSize = 0;
            this.numOps = 0;
            this.distinctKeysSize = 0;
            this.seenHashSize = 0;
            this.headerFlags = (short)8198;
            this.setUseRelativeOffsets(DEFAULT_RELATIVE_OFFSETS);
            this.setTinyNodeStat(DEFAULT_TINYNODE);
            this.setSimpleValueSharing(DEFAULT_SIMPLE_VALUE_SHARING);
            this.setLastValueSharing(DEFAULT_LAST_VALUE_SHARING);
            if (this.keysNeedReset) {
                for (int i2 = 0; i2 < this.keys.length; ++i2) {
                    for (int i3 = 0; this.keys[i2] != null && i3 < this.keys[i2].length && this.keys[i2][i3] != 0; ++i3) {
                        this.keys[i2][i3] = 0;
                        if (!this.lastValueSharing) continue;
                        this.keysLastSeenValue[i2][i3] = 0;
                    }
                }
            }
            this.opLastValue = -1;
            this.keysNeedReset = true;
            this.depth = 0;
            this.outBufferPos = 0;
            this.tinyNodeCount = 0;
            this.duplicateKeyMode = DEFAULT_DUPLICATE_KEY_MODE;
            this.opEmptyArray = -1;
            this.opEmptyObject = -1;
            this.opEmptyString = -1;
            this.opOne = -1;
            this.opZero = -1;
            this.opNull = -1;
            this.opFalse = -1;
            this.opTrue = -1;
            this.keyJ = -1;
            this.keyI = -1;
            this.ctx.init();
            this.ctx.setExceptionFactory(this.getExceptionFactory());
        }

        private void initKeysLastSeenValue(int n2) {
            if (this.keysLastSeenValue == null) {
                this.keysLastSeenValue = new int[256][];
            }
            if (this.keysLastSeenValue[n2] == null) {
                this.keysLastSeenValue[n2] = new int[this.keys[n2].length];
            } else if (this.keysLastSeenValue[n2].length < this.keys[n2].length) {
                this.keysLastSeenValue[n2] = Arrays.copyOf(this.keysLastSeenValue[n2], this.keys[n2].length);
            }
        }

        public void setTinyNodeStat(boolean bl) {
            this.headerFlags = bl ? (short)(this.headerFlags | 0x2000) : (short)(this.headerFlags & 0xFFFFDFFF);
        }

        public void setUseRelativeOffsets(boolean bl) {
            this.relativeOffsets = bl;
        }

        public void setSimpleValueSharing(boolean bl) {
            this.simpleValueSharing = bl;
        }

        public void setLastValueSharing(boolean bl) {
            this.lastValueSharing = bl;
        }

        private void writeTimestamp(byte[] byArray) {
            if (byArray.length == OsonPrimitiveConversions.SIZE_TIMESTAMP) {
                this.fixedBinary(57, byArray.length, byArray);
            } else {
                this.fixedBinary(125, byArray.length, byArray);
            }
        }

        public void writeTimestampTZ(byte[] byArray) {
            OsonPrimitiveConversions.assertNoRegionTimestampTZ(this.getExceptionFactory(), byArray);
            this.fixedBinary(124, byArray.length, byArray);
        }

        private void writeDate(byte[] byArray) {
            this.fixedBinary(60, OsonPrimitiveConversions.SIZE_DATE, byArray);
        }

        private void writeIntervalYM(byte[] byArray) {
            this.fixedBinary(61, 5, byArray);
        }

        private void writeIntervalDS(byte[] byArray) {
            this.fixedBinary(62, 11, byArray);
        }

        private void fixedBinary(int n2, int n3, byte[] byArray) {
            if (n3 != byArray.length) {
                throw new IllegalArgumentException();
            }
            this.addOpAndValue(n2, byArray);
        }

        public void close() {
            this.ctx.close();
            try {
                this.initializeKeyHeap();
                this.computeOffsets();
                this.writeHeader();
                this.writeNameDictionary();
                this.writeTreeNodeSegment();
                this.flushBuffer();
                this.out.close();
            }
            catch (IOException iOException) {
                throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
            }
        }

        private void writeString(String string) {
            this.preOp();
            this.expandValueHeap(string.length() * 4);
            this.valueIndex[this.numOps] = this.valueHeapSize;
            int n2 = this.writeString(string, this.valueHeap, this.valueHeapSize);
            int n3 = n2 - this.valueHeapSize;
            this.valueHeapSize = n2;
            this.writeStringOp(n2, n3);
            boolean bl = this.checkStringDuplicate(n3);
            this.postOp(!bl);
        }

        private boolean checkStringDuplicate(int n2) {
            if (this.lastValueSharing && this.opLastValue != -1 && this.ops[this.numOps - 1] == this.ops[this.opLastValue] && this.numChildren[this.opLastValue] == n2 && this.equals(this.valueHeap, this.valueIndex[this.numOps - 1], this.valueHeap, this.valueIndex[this.opLastValue], n2)) {
                this.markDuplicate(this.numOps - 1, this.opLastValue);
                this.headerFlags = (short)(this.headerFlags | 0x40);
                return true;
            }
            if (n2 == 0 && this.simpleValueSharing) {
                if (this.opEmptyString == -1) {
                    this.opEmptyString = this.numOps - 1;
                } else {
                    this.headerFlags = (short)(this.headerFlags | 0x20);
                    this.markDuplicate(this.numOps - 1, this.opEmptyString);
                }
                return true;
            }
            return false;
        }

        private void writeUTF8String(byte[] byArray, int n2, int n3) {
            int n4;
            this.preOp();
            this.expandValueHeap(n3);
            this.valueIndex[this.numOps] = this.valueHeapSize;
            this.valueHeapSize = n4 = this.writeUTF8String(byArray, n2, n3, this.valueHeap, this.valueHeapSize);
            this.writeStringOp(n4, n3);
            this.checkStringDuplicate(n3);
            this.postOp(true);
        }

        private void writeStringOp(int n2, int n3) {
            if (n3 <= 31) {
                this.addOp(n3);
            } else if (n3 < 256) {
                this.addOp(51);
            } else if (n3 < 65536) {
                this.addOp(55);
            } else {
                this.addOp(56);
            }
            this.numChildren[this.numOps - 1] = n3;
            this.ctx.primitive();
        }

        private void writeStartObject() {
            this.preOp();
            this.addOp(128);
            this.push(this.numOps - 1);
            this.ctx.startObject();
            this.postOp(false);
        }

        private void writeStartObjectNoSort() {
            this.preOp();
            this.addOp(132);
            this.push(this.numOps - 1);
            this.ctx.startObject();
            this.postOp(false);
        }

        private void writeStartArray() {
            this.preOp();
            this.addOp(192);
            this.push(this.numOps - 1);
            this.ctx.startArray();
            this.postOp(false);
        }

        public void writeEnd() {
            this.ctx.end();
            this.depth = (byte)(this.depth - 1);
            this.previousSiblingIdx = this.opStack[this.depth];
            if (this.simpleValueSharing && this.numChildren[this.opStack[this.depth]] == 0) {
                int n2 = this.opStack[this.depth];
                if (this.isArray(this.ops[n2])) {
                    if (this.opEmptyArray == -1) {
                        this.opEmptyArray = n2;
                    } else {
                        this.headerFlags = (short)(this.headerFlags | 0x20);
                        this.markDuplicate(n2, this.opEmptyArray);
                    }
                } else if (this.opEmptyObject == -1) {
                    this.opEmptyObject = n2;
                } else {
                    this.headerFlags = (short)(this.headerFlags | 0x20);
                    this.markDuplicate(n2, this.opEmptyObject);
                }
            }
        }

        private void writeDouble(double d2) {
            byte[] byArray = OsonPrimitiveConversions.doubleToCanonicalFormatBytes(d2);
            this.addOpAndValue(54, byArray);
        }

        private void writeBoolean(boolean bl) {
            this.preOp();
            if (bl) {
                this.addOp(49);
                if (this.simpleValueSharing) {
                    if (this.opTrue == -1) {
                        this.opTrue = this.numOps - 1;
                    } else {
                        this.headerFlags = (short)(this.headerFlags | 0x20);
                        this.markDuplicate(this.numOps - 1, this.opTrue);
                    }
                }
            } else {
                this.addOp(50);
                if (this.simpleValueSharing) {
                    if (this.opFalse == -1) {
                        this.opFalse = this.numOps - 1;
                    } else {
                        this.headerFlags = (short)(this.headerFlags | 0x20);
                        this.markDuplicate(this.numOps - 1, this.opFalse);
                    }
                }
            }
            this.ctx.primitive();
            this.postOp(true);
        }

        private void writeOraNumber(OracleJsonDecimal oracleJsonDecimal) {
            OracleJsonDecimalImpl oracleJsonDecimalImpl = (OracleJsonDecimalImpl)oracleJsonDecimal;
            if (oracleJsonDecimalImpl.isDec()) {
                this.writeDecimal(oracleJsonDecimalImpl.bigDecimalValue());
            } else if (oracleJsonDecimalImpl.isSB4()) {
                this.writeSB4(oracleJsonDecimalImpl.intValue());
            } else if (oracleJsonDecimalImpl.isSB8()) {
                this.writeSB8(oracleJsonDecimalImpl.longValue());
            } else {
                this.writeNumber(oracleJsonDecimalImpl.raw());
            }
        }

        private void writeDecimal(BigDecimal bigDecimal) {
            byte[] byArray = OsonPrimitiveConversions.toNumber(bigDecimal);
            this.writeDecimal(byArray);
        }

        private void writeDecimal(byte[] byArray) {
            if (byArray.length <= 8) {
                this.addOpAndValue(byArray.length - 1 | OsonConstants.MASK_DEC_16, byArray);
            } else if (byArray.length < 256) {
                this.addOpAndValue(116, byArray);
            }
        }

        private void writeDecimal(BigInteger bigInteger) {
            this.writeDecimal(OsonPrimitiveConversions.toNumber(bigInteger));
        }

        private void writeSB4(int n2) {
            byte[] byArray = OsonPrimitiveConversions.toNumber(n2);
            int n3 = byArray.length | OsonConstants.MASK_SB4;
            this.addOpAndValue(n3, byArray);
        }

        private void markDuplicate(int n2, int n3) {
            this.numChildren[n2] = -n3;
        }

        private boolean tryMarkDuplicate(int n2, byte[] byArray) {
            if (this.lastValueSharing && this.opLastValue != -1 && n2 == this.ops[this.opLastValue] && this.numChildren[this.opLastValue] == byArray.length && this.equals(byArray, 0, this.valueHeap, this.valueIndex[this.opLastValue], byArray.length)) {
                this.markDuplicate(this.numOps, this.opLastValue);
                this.headerFlags = (short)(this.headerFlags | 0x40);
                return true;
            }
            return false;
        }

        private void addOpAndValue(int n2, byte[] byArray) {
            this.addOpAndValueNoPostOp(n2, byArray);
            this.postOp(true);
        }

        private void addOpAndValueNoPostOp(int n2, byte[] byArray) {
            this.preOp();
            if (!this.tryMarkDuplicate(n2, byArray)) {
                this.addValue(byArray);
                this.numChildren[this.numOps] = byArray.length;
            }
            this.addOp(n2);
            this.ctx.primitive();
        }

        public void writeSB8(long l2) {
            byte[] byArray = OsonPrimitiveConversions.toNumber(l2);
            this.addOpAndValue(byArray.length | OsonConstants.MASK_SB8, byArray);
        }

        private void writeNumberAsString(BigDecimal bigDecimal) {
            byte[] byArray = bigDecimal.toString().getBytes(StandardCharsets.UTF_8);
            if (byArray.length > 256) {
                throw new IllegalArgumentException();
            }
            this.addOpAndValue(53, byArray);
        }

        private void writeBytes(byte[] byArray) {
            int n2 = byArray.length < 65536 ? 58 : 59;
            this.addOpAndValue(n2, byArray);
        }

        protected void writeId(byte[] byArray) {
            if (byArray.length > 16) {
                throw new UnsupportedOperationException();
            }
            this.addOpAndValue(126, byArray);
        }

        private void writeFloat(float f2) {
            byte[] byArray = OsonPrimitiveConversions.floatToCanonicalFormatBytes(f2);
            this.addOpAndValue(127, byArray);
        }

        private void writeKey(String string) {
            int n2;
            this.ctx.pendingKey();
            if (this.numOps >= this.ops.length) {
                this.expandOp();
            }
            this.keyI = OsonHeader.ub1hash(string);
            int[] nArray = this.keys[this.keyI];
            if (nArray == null) {
                this.keys[this.keyI] = new int[2];
                nArray = this.keys[this.keyI];
            }
            this.keyJ = 0;
            while (this.keyJ < nArray.length && (n2 = nArray[this.keyJ] - 1) != -1) {
                if (this.distinctKeys[n2].equals(string)) {
                    this.fieldIDs[this.numOps] = n2;
                    if (this.lastValueSharing) {
                        this.opLastValue = this.keysLastSeenValue[this.keyI][this.keyJ];
                    }
                    return;
                }
                ++this.keyJ;
            }
            if (this.keyJ >= nArray.length) {
                this.keys[this.keyI] = Arrays.copyOf(this.keys[this.keyI], this.keys[this.keyI].length * 2);
                nArray = this.keys[this.keyI];
            } else if (this.keyJ == 0 && this.seenHashSize < SEEN_HASH_THRESHOLD) {
                this.seenHash[this.seenHashSize++] = this.keyI;
            }
            if (this.distinctKeysSize + 1 >= this.distinctKeys.length) {
                this.distinctKeys = Arrays.copyOf(this.distinctKeys, this.distinctKeys.length * 2);
            }
            this.fieldIDs[this.numOps] = this.distinctKeysSize;
            this.distinctKeys[this.distinctKeysSize++] = string;
            nArray[this.keyJ] = this.distinctKeysSize;
        }

        private void writeNull() {
            this.preOp();
            this.addOp(48);
            if (this.simpleValueSharing) {
                if (this.opNull == -1) {
                    this.opNull = this.numOps - 1;
                } else {
                    this.headerFlags = (short)(this.headerFlags | 0x20);
                    this.markDuplicate(this.numOps - 1, this.opNull);
                }
            }
            this.ctx.primitive();
            this.postOp(true);
        }
    }

    public static enum DuplicateKeyMode {
        ALLOW,
        DISALLOW;

    }
}

