/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient.api.capabilities;

import com.openshift.restclient.capability.ICapability;
import com.openshift.restclient.capability.IStoppable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface IPodExec
extends ICapability {
    public IStoppable start(IPodExecOutputListener var1, Options var2, String ... var3);

    public static class Options {
        public static final String CONTAINER = "container";
        public static final String STDOUT = "stdout";
        public static final String STDERR = "stderr";
        private Map<String, String> options = new HashMap<String, String>();
        private Map<String, String> secondaries = new HashMap<String, String>();

        private Options storeSecondary(String key, Object v) {
            this.secondaries.put(key, v.toString());
            return this;
        }

        public Options container(String container) {
            return this.storeSecondary(CONTAINER, container);
        }

        public Options stdOut(boolean value) {
            return this.storeSecondary(STDOUT, value);
        }

        public Options stdErr(boolean value) {
            return this.storeSecondary(STDERR, value);
        }

        public Options parameter(String name, String value) {
            this.options.put(name, value);
            return this;
        }

        public Map<String, String> getMap() {
            HashMap<String, String> combined = new HashMap<String, String>(this.secondaries);
            combined.putAll(this.options);
            return Collections.unmodifiableMap(combined);
        }
    }

    public static interface IPodExecOutputListener {
        public void onOpen();

        public void onStdOut(String var1);

        public void onStdErr(String var1);

        public void onExecErr(String var1);

        public void onFailure(Throwable var1);

        public void onClose(int var1, String var2);
    }
}

