/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.format;

import com.ethlo.time.ITU;
import com.ethlo.time.LeapSecondException;
import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeValidator.class);
    private static final String DATETIME = "date-time";

    public DateTimeValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, ValidatorTypeCode type) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, type, validationContext);
        this.validationContext = validationContext;
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        DateTimeValidator.debug(logger, node, rootNode, instanceLocation);
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        if (nodeType != JsonType.STRING) {
            return Collections.emptySet();
        }
        if (!DateTimeValidator.isLegalDateTime(node.textValue())) {
            return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).arguments(node.textValue(), DATETIME)).build());
        }
        return Collections.emptySet();
    }

    private static boolean isLegalDateTime(String string) {
        try {
            block4: {
                try {
                    ITU.parseDateTime((String)string);
                }
                catch (LeapSecondException ex) {
                    if (ex.isVerifiedValidLeapYearMonth()) break block4;
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            logger.debug("Invalid {}: {}", (Object)DATETIME, (Object)ex.getMessage());
            return false;
        }
    }
}

