/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.mysema.query.collections.CollQuery;
import com.mysema.query.collections.DefaultQueryEngine;
import com.mysema.query.collections.QueryEngine;
import com.mysema.query.dml.DeleteClause;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.Collection;

public class CollDeleteClause<T>
implements DeleteClause<CollDeleteClause<T>> {
    private final Collection<? extends T> col;
    private final Path<T> expr;
    private final CollQuery query;

    public CollDeleteClause(QueryEngine qe, Path<T> expr, Collection<? extends T> col) {
        this.query = (CollQuery)new CollQuery(qe).from(expr, col);
        this.expr = expr;
        this.col = col;
    }

    public CollDeleteClause(Path<T> expr, Collection<? extends T> col) {
        this(DefaultQueryEngine.getDefault(), expr, col);
    }

    public long execute() {
        int rv = 0;
        for (T match : this.query.list(this.expr)) {
            this.col.remove(match);
            ++rv;
        }
        return rv;
    }

    public CollDeleteClause<T> where(Predicate ... o) {
        this.query.where(o);
        return this;
    }

    public String toString() {
        return "delete " + this.query.toString();
    }
}

