package com.microsoft.sqlserver.jdbc;
import java.util.*;
public final class SQLServerResource_fr extends ListResourceBundle
				  {
protected Object[][]  getContents()
{
return contents;
}


static final Object[][] contents =
{
{"R_timedOutBeforeRouting","Le délai d'attente a expiré avant la connexion à la destination de routage."},
{"R_invalidRoutingInfo","Réception d'informations de routage inattendues. Vérifiez les propriétés de la connexion et la configuration de SQL Server."},
{"R_multipleRedirections","Deux redirections au minimum se sont produites. Une seule redirection est autorisée par tentative de connexion."},
{"R_dbMirroringWithMultiSubnetFailover","La connexion à une instance en miroir de SQL Server à l'aide de la propriété de connexion multiSubnetFailover n'est pas prise en charge."},
{"R_dbMirroringWithReadOnlyIntent","La connexion à une instance en miroir de SQL Server à l'aide de la propriété de connexion ApplicationIntent ReadOnly n'est pas prise en charge."},
{"R_ipAddressLimitWithMultiSubnetFailover","La connexion  à une instance de SQL Server configurée avec plus de {0} adresses IP à l''aide de la propriété de connexion multiSubnetFailover n''est pas prise en charge."},
{"R_connectionTimedOut","Expiration de la connexion : pas d'informations supplémentaires."},
{"R_invalidPositionIndex","L''index de position {0} n''est pas valide."},
{"R_invalidLength","La longueur {0} n''est pas valide."},
{"R_unknownSSType","Le type de données SQL Server {0} n''est pas valide."},
{"R_unknownJDBCType","Le type de données JDBC {0} n''est pas valide."},
{"R_notSQLServer","Le pilote a reçu une réponse de préconnexion inattendue. Examinez les propriétés de connexion et vérifiez qu'une instance de SQL Server est en cours d'exécution sur l'hôte et accepte les connexions TCP/IP au port. Ce pilote peut être utilisé uniquement avec SQL Server 2005 ou ultérieur."},
{"R_tcpOpenFailed","{0}. Vérifiez les propriétés de connexion. Assurez-vous qu''une instance de SQL Server est en cours d''exécution sur l''hôte et accepte les connexions TCP/IP au port. Vérifiez que les connexions TCP au port ne sont pas bloquées par un pare-feu."},
{"R_unsupportedServerVersion","SQL Server version {0} n''est pas pris en charge par ce pilote."},
{"R_noServerResponse","Le serveur SQL Server n'a retourné aucune réponse. La connexion a été fermée."},
{"R_truncatedServerResponse","Le serveur SQL Server a retourné une réponse incomplète. La connexion a été fermée."},
{"R_queryTimedOut","Le délai imparti à la requête a expiré."},
{"R_queryCanceled","La requête a été annulée."},
{"R_errorReadingStream","Une erreur s''est produite lors de la lecture de la valeur de l''objet flux. Erreur : « {0} »"},
{"R_read","L'opération de lecture du flux a retourné une valeur non valide pour la quantité de données lues."},
{"R_streamReadReturnedInvalidValue","L'opération de lecture du flux a retourné une valeur non valide pour la quantité de données lues."},
{"R_mismatchedStreamLength","La valeur du flux de données n''a pas la longueur spécifiée. La longueur spécifiée était {0}, la longueur effective est {1}."},
{"R_notSupported","Cette opération n'est pas prise en charge."},
{"R_invalidOutputParameter","L''index {0} du paramètre de sortie n''est pas valide."},
{"R_outputParameterNotRegisteredForOutput","Le paramètre de sortie {0} n''a pas été inscrit pour la sortie."},
{"R_parameterNotDefinedForProcedure","Le paramètre {0} n''a pas été défini pour la procédure stockée {1}."},
{"R_connectionIsClosed","La connexion est fermée."},
{"R_invalidBooleanValue","La propriété {0} ne contient pas de valeur booléenne valide. Seules les valeurs true ou false peuvent être utilisées."},
{"R_propertyMaximumExceedsChars","La propriété {0} dépasse le nombre maximal de caractères admis {1}."},
{"R_invalidPortNumber","Le numéro de port {0} n''est pas valide."},
{"R_invalidTimeOut","Le timeout {0} n''est pas valide."},
{"R_invalidLockTimeOut","La valeur lockTimeOut {0} n''est pas valide."},
{"R_invalidAuthenticationScheme","authenticationScheme {0} n''est pas valide."},
{"R_invalidPacketSize","La taille packetSize {0} n''est pas valide."},
{"R_packetSizeTooBigForSSL","Le chiffrement SSL ne peut pas être utilisé avec une taille de paquet réseau supérieure à {0} octets. Vérifiez les propriétés de votre connexion et la configuration SQL Server."},
{"R_redirectedFrom","{0} (redirigé à partir de {1})"},
{"R_tcpipConnectionFailed","Échec de la connexion TCP/IP à l''hôte {0}, port {1}. Erreur : « {2} »."},
{"R_invalidTransactionLevel","Le niveau de transaction {0} n''est pas valide."},
{"R_cantInvokeRollback","Impossible d'appeler une opération d'annulation (rollback) quand le mode AutoCommit a la valeur \"true\"."},
{"R_cantSetSavepoint","Impossible de définir un point d'enregistrement lorsque le mode AutoCommit a la valeur « true »."},
{"R_sqlServerHoldability","SQL Server ne prend en charge la fonction Holdability qu'au niveau de la connexion. Utilisez la méthode connection.setHoldability()."},
{"R_invalidHoldability","La valeur de la fonction Holdability {0} n''est pas valide."},
{"R_invalidColumnArrayLength","Le tableau de colonne n'est pas valide. Sa longueur doit être égale à 1."},
{"R_valueNotSetForParameter","Aucune valeur n''est définie pour le paramètre numéro {0}."},
{"R_sqlBrowserFailed","La connexion à l''hôte {0}, instance nommée {1}, a échoué. Erreur : « {2} ». Vérifiez le nom du serveur et celui de l''instance et veillez à ce qu''aucun pare-feu ne bloque le trafic UDP vers le port 1434. Pour SQL Server 2005 ou ultérieur, vérifiez que le service SQL Server Browser est en cours d''exécution sur l''hôte."},
{"R_notConfiguredToListentcpip","Le serveur {0} n''est pas configuré pour écouter avec TCP/IP."},
{"R_cantIdentifyTableMetadata","Impossible d''identifier la table {0} pour les métadonnées."},
{"R_metaDataErrorForParameter","Une erreur de métadonnées s''est produite pour le paramètre {0}."},
{"R_invalidParameterNumber","Le paramètre numéro {0} n''est pas valide."},
{"R_noMetadata","Il n'y a pas de métadonnées."},
{"R_resultsetClosed","Le jeu de résultat est fermé."},
{"R_invalidColumnName","Le nom de colonne {0} n''est pas valide."},
{"R_resultsetNotUpdatable","Le jeu de résultat ne peut pas être mis à jour."},
{"R_indexOutOfRange","L''index {0} est hors limites."},
{"R_savepointNotNamed","Le point d'enregistrement (savepoint) n'est pas nommé."},
{"R_savepointNamed","Le point d''enregistrement (savepoint) {0} est nommé."},
{"R_resultsetNoCurrentRow","Le jeu de résultat n'a pas de ligne actuelle."},
{"R_mustBeOnInsertRow","Le curseur n'est pas placé sur la ligne d'insertion."},
{"R_mustNotBeOnInsertRow","L'opération demandée n'est pas valide sur la ligne d'insertion."},
{"R_cantUpdateDeletedRow","Une ligne supprimée ne peut pas être mise à jour."},
{"R_noResultset","L'instruction n'a pas renvoyé le jeu de résultat."},
{"R_resultsetGeneratedForUpdate","Un jeu de résultat a été généré pour mise à jour."},
{"R_statementIsClosed","L'instruction est fermée."},
{"R_invalidRowcount","Le nombre maximal de lignes (rowcount) {0} pour un ensemble de résultats doit être non négatif."},
{"R_invalidQueryTimeOutValue","La valeur d''expiration de la requête {0} n''est pas valide."},
{"R_invalidFetchDirection","Le sens de l''extraction {0} n''est pas valide."},
{"R_invalidFetchSize","La taille de l'extraction ne peut pas être négative."},
{"R_noColumnParameterValue","Aucune valeur de paramètre de colonne n'a été indiquée pour la mise à jour de la ligne."},
{"R_statementMustBeExecuted","L'instruction doit être exécutée avant de pouvoir obtenir des résultats."},
{"R_modeSuppliedNotValid","Le mode indiqué n'est pas valide."},
{"R_errorConnectionString","La chaîne de connexion contient un nom ou une valeur au format incorrect."},
{"R_errorServerName","La valeur de la propriété de connexion serverName {0} est mal formée."},
{"R_errorProcessingComplexQuery","Une erreur s'est produite lors du traitement de la requête complexe."},
{"R_invalidOffset","Le décalage {0} n''est pas valide."},
{"R_nullConnection","L'URL de connexion est NULL."},
{"R_invalidConnection","L'URL de connexion n'est pas valide."},
{"R_cannotTakeArgumentsPreparedOrCallable","La méthode {0} n''accepte aucun argument pour PreparedStatement ou CallableStatement."},
{"R_unsupportedConversionFromTo","La conversion de {0} en {1} n''est pas prise en charge."},
{"R_unsupportedConversionTo","La conversion en {0} n''est pas prise en charge."},
{"R_errorConvertingValue","Une erreur s''est produite lors de la conversion de la valeur {0} vers le type de données JDBC {1}."},
{"R_streamIsClosed","Le flux de données est fermé."},
{"R_invalidTDS","Le flux de données de protocole TDS n'est pas valide."},
{"R_unexpectedToken"," token inattendu {0}."},
{"R_selectNotPermittedinBatch","L'instruction SELECT n'est pas autorisée dans un lot (batch)."},
{"R_failedToCreateXAConnection","Échec de la création de la connexion de contrôle XA. Erreur : « {0} »"},
{"R_codePageNotSupported","La page de codes {0} n''est pas prise en charge par l''environnement Java."},
{"R_unknownSortId","Le classement SQL Server {0} n''est pas pris en charge par ce pilote."},
{"R_unknownLCID","Le classement Windows {0} n''est pas pris en charge par ce pilote."},
{"R_encodingErrorWritingTDS","Une erreur d''encodage s''est produite lors de l''écriture d''une chaîne dans la mémoire tampon TDS. Erreur : « {0} »"},
{"R_processingError","Une erreur de traitement « {0} » s''est produite."},
{"R_requestedOpNotSupportedOnForward","L'opération demandée n'est pas prise en charge pour les jeux de résultats avant uniquement."},
{"R_unsupportedCursor","Ce type de curseur n'est pas pris en charge."},
{"R_unsupportedCursorOperation","L'opération demandée n'est pas prise en charge pour ce type de curseur."},
{"R_unsupportedConcurrency","Accès simultané non pris en charge."},
{"R_unsupportedCursorAndConcurrency","Cette combinaison type de curseur/accès simultané n'est pas prise en charge."},
{"R_stringReadError","Erreur de lecture de chaîne à l''offset : {0}."},
{"R_stringWriteError","Erreur d''écriture de chaîne à l''offset : {0}."},
{"R_stringNotInHex","La chaîne n'a pas un format hexadécimal valide."},
{"R_unknownType","Le type Java {0} n''est pas pris en charge."},
{"R_physicalConnectionIsClosed","La connexion physique est fermée pour cette connexion mise en pool."},
{"R_invalidDataSourceReference","Référence de DataSource non valide."},
{"R_cantGetColumnValueFromDeletedRow","Impossible d'obtenir une valeur à partir d'une ligne supprimée."},
{"R_cantGetUpdatedColumnValue","Impossible d'accéder aux colonnes mises à jour tant que updateRow() ou cancelRowUpdates() n'a pas été appelé."},
{"R_cantUpdateColumn","La valeur de la colonne ne peut pas être mise à jour."},
{"R_positionedUpdatesNotSupported","Les mises à jour et suppressions positionnées ne sont pas prises en charge."},
{"R_invalidAutoGeneratedKeys","La valeur {0} du paramètre autoGeneratedKeys n''est pas valide. Seules les valeurs Statement.RETURN_GENERATED_KEYS et Statement.NO_GENERATED_KEYS peuvent être utilisées."},
{"R_notConfiguredForIntegrated","Ce pilote n'est pas configuré pour l'authentification intégrée."},
{"R_failoverPartnerWithoutDB","databaseName est requis en cas d'utilisation de la propriété de connexion failoverPartner."},
{"R_invalidPartnerConfiguration","La base de données {0} sur le serveur {1} n''est pas configurée pour la mise en miroir de bases de données."},
{"R_invaliddisableStatementPooling","La valeur disableStatementPooling {0} n''est pas valide."},
{"R_invalidselectMethod","La méthode selectMethod {0} n''est pas valide."},
{"R_invalidpropertyValue","Le type de données de la propriété de connexion {0} n''est pas valide. Toutes les propriétés de cette connexion doivent être de type String."},
{"R_invalidArgument","L''argument {0} n''est pas valide."},
{"R_streamWasNotMarkedBefore","Le flux n'a pas été marqué."},
{"R_invalidresponseBuffering","La propriété de connexion responseBuffering {0} n''est pas valide."},
{"R_invalidapplicationIntent","La propriété de connexion applicationIntent {0} n''est pas valide."},
{"R_invalidDatetimeType","La propriété de connexion datetimeType {0} n’est pas valide."},
{"R_dataAlreadyAccessed","Un utilisateur a accédé aux données et elles ne sont pas disponibles pour cette colonne ou ce paramètre."},
{"R_outParamsNotPermittedinBatch","Les paramètres OUT et INOUT ne sont pas autorisés dans un lot."},
{"R_colNotMatchTable","Le nombre de colonnes fournies {0} ne correspond pas au {1} de définition de table."},
{"R_invalidSQL","Requête SQL {0} non valide."},
{"R_multipleQueriesNotAllowed","Les requêtes multiples ne sont pas autorisées."},
{"R_endOfQueryDetected","Fin de la requête détectée avant la détection de VALUES."},
{"R_onlyFullParamAllowed","Seules les requêtes entièrement paramétrées sont autorisées à utiliser l’API de copie en bloc pour l’insertion par lot pour le moment."},
{"R_sslRequiredNoServerSupport","Le pilote n'a pas pu établir de connexion sécurisée au serveur SQL Server à l'aide du chiffrement SSL (Secure Sockets Layer). L'application exigeait un chiffrement, mais le serveur n'est pas configuré pour prendre en charge SSL."},
{"R_sslRequiredByServer","La connexion SQL Server exige une connexion chiffrée qui utilise SSL (Secure Sockets Layer)."},
{"R_sslFailed","Le pilote n''a pas pu établir de connexion sécurisée au serveur SQL Server à l''aide du chiffrement SSL (Secure Sockets Layer). Erreur : « {0} »."},
{"R_certNameFailed","Échec de la validation du nom de serveur « {0} » dans un certificat lors de l''initialisation SSL (Secure Sockets Layer). Nom dans le certificat « {1} »"},
{"R_failedToInitializeXA","Échec de l''initialisation de la procédure stockée xp_sqljdbc_xa_init. L''état est : {0}. Erreur : « {1} »"},
{"R_failedFunctionXA","Échec de la fonction {0}. L''état est : {1}. Erreur : « {2} »"},
{"R_noTransactionCookie","Échec de la fonction {0}. Aucun cookie de transaction n''a été retourné."},
{"R_failedToEnlist","Échec de l''inscription. Erreur : « {0} »"},
{"R_failedToUnEnlist","Échec de l''annulation de l''inscription. Erreur : « {0} »"},
{"R_failedToReadRecoveryXIDs","Échec de la lecture des ID de transaction de branche XA de récupération (XID). Erreur : « {0} »"},
{"R_userPropertyDescription","Utilisateur de la base de données."},
{"R_passwordPropertyDescription","Mot de passe de la base de données."},
{"R_databaseNamePropertyDescription","Nom de la base de données à laquelle se connecter."},
{"R_domainPropertyDescription","Domaine Windows pour l'authentification à l'aide de NTLM."},
{"R_serverNamePropertyDescription","Ordinateur sur lequel s'exécute SQL Server."},
{"R_iPAddressPreferencePropertyDescription","Type d’adresse IP préféré."},
{"R_portNumberPropertyDescription","Port TCP sur lequel une instance de SQL Server est à l'écoute."},
{"R_realmPropertyDescription","Domaine pour l’authentification Kerberos."},
{"R_serverSpnPropertyDescription","SPN SQL Server."},
{"R_columnEncryptionSettingPropertyDescription","Paramètre de chiffrement de colonne."},
{"R_enclaveAttestationUrlPropertyDescription","URL d'attestation d'enclave."},
{"R_enclaveAttestationProtocolPropertyDescription","Protocole d'attestation d'enclave."},
{"R_serverNameAsACEPropertyDescription","Convertit le serverName Unicode en encodage ASCII Compatible Encoding (ACE), comme le définit l'opération ToASCII du document RFC 3490."},
{"R_sendStringParametersAsUnicodePropertyDescription","Détermine si les paramètres de chaîne sont envoyés au serveur en Unicode ou dans le jeu de caractères de la base de données."},
{"R_multiSubnetFailoverPropertyDescription","Indique que l'application se connecte à un écouteur du groupe de disponibilité (Availability Group Listener) d'un groupe de disponibilité (Availability Group) ou à l'instance de cluster de basculement (Failover Cluster Instance)."},
{"R_applicationNamePropertyDescription","Nom d'application pour les outils de définition de profils et de journalisation SQL Server."},
{"R_lastUpdateCountPropertyDescription","Permet de s'assurer que seul le dernier nombre de mises à jour est retourné par une instruction SQL transmise au serveur."},
{"R_disableStatementPoolingPropertyDescription","Désactive la fonctionnalité de regroupement d'instructions."},
{"R_integratedSecurityPropertyDescription","Indique si l'authentification Windows sera utilisée pour la connexion à SQL Server."},
{"R_authenticationSchemePropertyDescription","Schéma d'authentification à utiliser pour l'authentification intégrée."},
{"R_lockTimeoutPropertyDescription","Nombre de millisecondes à attendre avant que la base de données ne rapporte l'expiration d'un délai de verrouillage."},
{"R_connectRetryCountPropertyDescription","Nombre de tentatives de reconnexion en cas d’échec de la connexion."},
{"R_connectRetryIntervalPropertyDescription","Nombre de secondes entre chaque nouvelle tentative de connexion."},
{"R_loginTimeoutPropertyDescription","Nombre de secondes que le pilote doit attendre avant l'expiration d'une connexion qui a échoué."},
{"R_instanceNamePropertyDescription","Nom de l'instance de SQL Server à laquelle se connecter."},
{"R_xopenStatesPropertyDescription","Détermine si le pilote retourne les codes d'état SQL compatibles XOPEN dans des exceptions."},
{"R_selectMethodPropertyDescription","Permet à l'application d'utiliser des curseurs côté serveur pour traiter les jeux de résultats avant uniquement en lecture seule."},
{"R_responseBufferingPropertyDescription","Contrôle le comportement de la mise en mémoire tampon adaptative afin de permettre à l'application de traiter des jeux de résultats volumineux sans devoir utiliser de curseurs côté serveur."},
{"R_applicationIntentPropertyDescription","Déclare le type de charge de travail d'application lors de la connexion à un serveur. Les valeurs possibles sont ReadOnly et ReadWrite."},
{"R_workstationIDPropertyDescription","Nom d'hôte de la station de travail."},
{"R_failoverPartnerPropertyDescription","Nom du serveur de basculement utilisé dans une configuration de mise en miroir de bases de données."},
{"R_packetSizePropertyDescription","Taille du paquet réseau utilisée pour communiquer avec SQL Server."},
{"R_encryptPropertyDescription","Détermine si le chiffrement SSL (Secure Sockets Layer) doit être utilisé entre le client et le serveur."},
{"R_serverCertificatePropertyDescription","Chemin d’accès au fichier de certificat du serveur."},
{"R_prepareMethodPropertyDescription","Détermine la méthode de préparation utilisée dans le pilote."},
{"R_socketFactoryClassPropertyDescription","Classe à instancier comme SocketFactory pour les connexions"},
{"R_socketFactoryConstructorArgPropertyDescription","Argument facultatif à passer au constructeur spécifié par socketFactoryClass"},
{"R_trustServerCertificatePropertyDescription","Détermine si le pilote doit valider le certificat SSL (Secure Sockets Layer) SQL Server."},
{"R_trustStoreTypePropertyDescription","Type de magasin de clés."},
{"R_trustStorePropertyDescription","Chemin du fichier TrustStore de certificat."},
{"R_trustStorePasswordPropertyDescription","Mot de passe utilisé pour vérifier l'intégrité des données du magasin d'approbations."},
{"R_trustManagerClassPropertyDescription","Classe à instancier comme TrustManager pour les connexions SSL."},
{"R_trustManagerConstructorArgPropertyDescription","Argument facultatif à passer au constructeur spécifié par trustManagerClass."},
{"R_hostNameInCertificatePropertyDescription","Nom d'hôte à utiliser lors de la validation du certificat SSL (Secure Sockets Layer) SQL Server."},
{"R_replicationPropertyDescription","Ce paramètre indique au serveur si la connexion est utilisée pour la réplication."},
{"R_sendTimeAsDatetimePropertyDescription","Détermine s'il faut utiliser le type de données SQL Server datetime pour envoyer les valeurs java.sql.Time à la base de données."},
{"R_datetimeParameterTypePropertyDescription","Détermine le type de données à utiliser pour les valeurs datetime et timestamp. Les options valides sont : datetime, datetime2 ou datetimeoffset"},
{"R_TransparentNetworkIPResolutionPropertyDescription","Détermine s'il faut utiliser la fonctionnalité de résolution transparente de l'adresse IP du réseau."},
{"R_queryTimeoutPropertyDescription","Nombre de secondes à attendre avant que la base de données ne signale l'expiration d'une requête."},
{"R_socketTimeoutPropertyDescription","Nombre de millisecondes à attendre avant que java.net.SocketTimeoutException ne soit déclenché."},
{"R_serverPreparedStatementDiscardThresholdPropertyDescription","Seuil définissant quand fermer les instructions prepare ignorées sur le serveur (en appelant un lot de sp_unprepares). La valeur 1 ou inférieure entraîne immédiatement l'appel de sp_unprepare lors de la fermeture de PreparedStatment."},
{"R_enablePrepareOnFirstPreparedStatementCallPropertyDescription","Ce paramètre spécifie si une instruction prepare est préparée (sp_prepexec) à la première utilisation (property=true) ou à la seconde après avoir appelé sp_executesql (property=false)."},
{"R_statementPoolingCacheSizePropertyDescription","Ce paramètre spécifie la taille du cache d'instructions préparé pour une connexion. Une valeur inférieure à 1 signifie qu'il n'y a pas de cache."},
{"R_gsscredentialPropertyDescription","Informations d'identification GSS représentées pour accéder à SQL Server."},
{"R_msiClientIdPropertyDescription","ID client de l'identité managée affectée par l'utilisateur servant à générer le jeton d'accès pour l'authentification MSI Azure AD"},
{"R_clientCertificatePropertyDescription","Chemin du certificat client pour la fonctionnalité d'authentification de certificat client."},
{"R_clientKeyPropertyDescription","Chemin du fichier de clé privée pour la fonctionnalité d'authentification de certificat client."},
{"R_clientKeyPasswordPropertyDescription","Mot de passe de la clé privée si la clé privée est protégée par un mot de passe."},
{"R_sendTemporalDataTypesAsStringForBulkCopyPropertyDescription","Indicateur qui spécifie si le pilote envoie des types de données temporels sous forme de valeur de chaîne au serveur pour la copie en bloc."},
{"R_delayLoadingLobsPropertyDescription","Indicateur booléen qui spécifie si le pilote charge les types de données LOB dans la mémoire."},
{"R_AADSecurePrincipalIdPropertyDescription","ID d'une application inscrite ayant une autorisation sur la base de données connectée."},
{"R_AADSecurePrincipalSecretPropertyDescription","Secret défini pour une application inscrite ayant une autorisation sur la base de données connectée."},
{"R_noParserSupport","Une erreur s''est produite lors de l''instanciation de l''analyseur requis. Erreur : « {0} »"},
{"R_writeOnlyXML","Impossible de lire cette instance SQLXML. Cette instance est en écriture seule."},
{"R_dataHasBeenReadXML","Impossible de lire cette instance SQLXML. Les données ont déjà été lues."},
{"R_readOnlyXML","Impossible d'écrire dans cette instance SQLXML. Cette instance est en lecture seule."},
{"R_dataHasBeenSetXML","Impossible d'écrire dans cette instance SQLXML. Les données ont déjà été définies."},
{"R_noDataXML","Aucune donnée n'a été définie dans cette instance SQLXML."},
{"R_cantSetNull","Impossible de définir une valeur Null."},
{"R_failedToParseXML","Échec de l''analyse XML. Erreur : « {0} »"},
{"R_isFreed","Cet objet {0} a été libéré. Il n''est plus possible d''y accéder."},
{"R_invalidProperty","Cette propriété n''est pas prise en charge : {0}."},
{"R_referencingFailedTSP","Le mot de passe DataSource trustStore doit être défini."},
{"R_valueOutOfRange","Une ou plusieurs valeurs sont hors plage pour le type de données SQL Server {0}."},
{"R_valueOutOfRangeSQLType","Une ou plusieurs valeurs sont hors plage pour le type SQL {0}."},
{"R_integratedAuthenticationFailed","L'authentification intégrée a échoué."},
{"R_permissionDenied","Violation de sécurité. L''autorisation sur la cible « {0} » est refusée."},
{"R_getSchemaError","Erreur lors de l'obtention du nom de schéma par défaut."},
{"R_setSchemaWarning","Avertissement : setSchema ne présente aucune opération dans cette version de pilote."},
{"R_updateCountOutofRange","La valeur du nombre de mises à jour est hors limites."},
{"R_limitOffsetNotSupported","La clause OFFSET dans la séquence d'échappement Limit n'est pas prise en charge."},
{"R_limitEscapeSyntaxError","Erreur dans la syntaxe d'échappement Limit. Échec de l'analyse de la requête."},
{"R_featureNotSupported","{0} n''est pas pris en charge."},
{"R_zoneOffsetError","Erreur lors de la récupération du décalage de zone."},
{"R_invalidMaxRows","Le nombre maximal de lignes pris en charge pour un jeu de résultats est Integer.MAX_VALUE ou inférieur."},
{"R_schemaMismatch","Les schémas source et de destination ne correspondent pas."},
{"R_invalidColumn","La colonne {0} n''est pas valide. Vérifiez vos mappages de colonne."},
{"R_invalidDestinationTable","Le nom de la table de destination est manquant ou non valide."},
{"R_unableRetrieveColMeta","Impossible de récupérer les métadonnées de colonne."},
{"R_invalidDestConnection","La connexion de destination doit être une connexion de Microsoft JDBC Driver for SQL Server."},
{"R_unableRetrieveSourceData","Impossible de récupérer les données à partir de la source."},
{"R_ParsingError","Échec de l''analyse des données pour le type {0}."},
{"R_ParsingDataError","L''analyse des données {0} pour le type {1} a échoué."},
{"R_BulkTypeNotSupported","Le type de données {0} n''est pas pris en charge pour la copie en bloc."},
{"R_BulkTypeNotSupportedDW","Le type de données {0} n''est pas pris en charge pour la copie en bloc sur Azure Data Warehouse."},
{"R_invalidTransactionOption","L'option UseInternalTransaction ne peut pas être définie sur TRUE quand elle est utilisée avec un objet Connection."},
{"R_invalidNegativeArg","L''argument {0} ne peut pas être négatif."},
{"R_BulkColumnMappingsIsEmpty","Impossible d'effectuer une opération de copie en bloc si le seul mappage est une colonne d'identité et que KeepIdentity a la valeur false."},
{"R_DataSchemaMismatch","Les données sources ne correspondent pas au schéma source."},
{"R_BulkDataDuplicateColumn","Les noms de colonne en double ne sont pas autorisés."},
{"R_invalidColumnOrdinal","La colonne {0} n''est pas valide. Le nombre de colonnes doit être supérieur à zéro."},
{"R_unsupportedEncoding","L''encodage {0} n''est pas pris en charge."},
{"R_UnexpectedDescribeParamFormat","Erreur interne. Le format du jeu de résultats retourné par sp_describe_parameter_encryption n'est pas valide. Il manque un des jeux de résultats."},
{"R_InvalidEncryptionKeyOrdinal","Erreur interne. L''ordinal de clé de chiffrement de colonne référencé « {0} » ne figure pas dans les métadonnées de chiffrement retournées par sp_describe_parameter_encryption. L''ordinal maximal est « {1} »."},
{"R_MissingParamEncryptionMetadata","Erreur interne. Les métadonnées de certains paramètres dans l''instruction ou la procédure « {0} » ne figurent pas dans le jeu de résultats retourné par sp_describe_parameter_encryption."},
{"R_UnableRetrieveParameterMetadata","Impossible de récupérer les métadonnées de chiffrement du paramètre."},
{"R_InvalidCipherTextSize","Le texte chiffré spécifié a une taille non valide de {0} octets, ce qui est inférieur au minimum de {1} octets exigé pour le déchiffrement."},
{"R_InvalidAlgorithmVersion","La version spécifiée ({0}) de l''algorithme de chiffrement du texte chiffré ne correspond pas à la version attendue ({1})."},
{"R_InvalidAuthenticationTag","Le texte chiffré spécifié a une balise d'authentification non valide. "},
{"R_EncryptionFailed","Erreur interne lors du chiffrement :  {0} "},
{"R_DecryptionFailed","Erreur interne lors du déchiffrement :  {0} "},
{"R_InvalidKeySize","La clé de chiffrement de colonne a été déchiffrée, mais sa longueur ({0}) ne correspond pas à la longueur ({1}) de l''algorithme « {2} ». Vérifiez la valeur chiffrée de la clé de chiffrement de colonne dans la base de données."},
{"R_InvalidEncryptionType","Le type de chiffrement {0} spécifié pour la colonne dans la base de données n''est pas valide ou est endommagé. Les types de chiffrement valides pour l''algorithme {1} sont : {2}."},
{"R_UnknownColumnEncryptionAlgorithm","L''algorithme {0} n''existe pas. Les algorithmes inscrits dans la fabrique sont {1}."},
{"R_KeyExtractionFailed","Échec de l''extraction de la clé : {0}."},
{"R_UntrustedKeyPath","Le chemin de clé principale de colonne {0} reçu du serveur {1} n''est pas un chemin de clé approuvé. Le chemin de clé principale de colonne est peut-être endommagé ou vous devez définir {0} comme chemin de clé approuvé à l''aide de SQLServerConnection.setColumnEncryptionTrustedMasterKeyPaths()."},
{"R_UnrecognizedKeyStoreProviderName","Échec du déchiffrement d''une clé de chiffrement de colonne. Nom de fournisseur de magasins de clés non valide : {0}. Un nom de fournisseur de magasins de clés doit désigner soit un fournisseur de magasins de clés système, soit un fournisseur de magasins de clés personnalisé inscrit. Les noms de fournisseurs de magasins de clés système valides sont : {1}. Les noms de fournisseurs de magasins de clés personnalisés (actuellement inscrits) valides sont : {2}. Vérifiez les informations des fournisseurs de magasins de clés dans les définitions de clé principale de colonne dans la base de données. Vérifiez aussi que tous les fournisseurs de magasins de clés personnalisés utilisés dans votre application sont correctement inscrits."},
{"R_UnrecognizedConnectionKeyStoreProviderName","Échec du déchiffrement d’une clé de chiffrement de colonne. Nom de fournisseur de magasin de clés non valide : {0}. Un nom de fournisseur de magasin de clés doit indiquer un fournisseur de magasin de clés inscrit. Les noms de fournisseur de magasin de clés inscrits sur cette connexion sont : {1}. Vérifiez les informations du fournisseur de magasin de clés dans les définitions de clé principale de colonne dans la base de données et vérifiez que tous les fournisseurs de magasins de clés utilisés dans votre application sont correctement inscrits."},
{"R_UnrecognizedStatementKeyStoreProviderName","Échec du déchiffrement d’une clé de chiffrement de colonne. Nom de fournisseur de magasin de clés non valide : {0}. Un nom de fournisseur de magasin de clés doit indiquer un fournisseur de magasin de clés inscrit. Les noms de fournisseur de magasin de clés inscrits sur cette instruction sont : {1}. Vérifiez les informations du fournisseur de magasin de clés dans les définitions de clé principale de colonne dans la base de données et vérifiez que tous les fournisseurs de magasins de clés utilisés dans votre application sont correctement inscrits."},
{"R_UnsupportedDataTypeAE","Le chiffrement et le déchiffrement du type de données {0} ne sont pas pris en charge."},
{"R_NormalizationErrorAE","Échec du déchiffrement du type de données {0}. Erreur de normalisation."},
{"R_UnsupportedNormalizationVersionAE","La version de normalisation « {0} » reçue de SQL Server n''est pas valide ou est endommagée. Les versions de normalisation valides sont : {1}."},
{"R_NullCipherTextAE","Erreur interne. La valeur Ciphertext ne peut pas avoir la valeur Null."},
{"R_NullColumnEncryptionAlgorithmAE","Erreur interne. L'algorithme de chiffrement ne peut pas avoir la valeur Null. Les algorithmes valides sont : {1}."},
{"R_CustomCipherAlgorithmNotSupportedAE","Algorithme de chiffrement personnalisé non pris en charge."},
{"R_PlainTextNullAE","Erreur interne. La valeur Plaintext ne peut pas avoir la valeur Null."},
{"R_StreamingDataTypeAE","Les données d''une longueur supérieure à {0} ne sont pas prises en charge dans la colonne {1} chiffrée."},
{"R_AE_NotSupportedByServer","SQL Server utilisée ne prend pas en charge le chiffrement de colonne."},
{"R_InvalidAEVersionNumber","Le numéro de version reçu (« {0} ») n''est pas valide pour Always Encrypted."},
{"R_NullEncryptedColumnEncryptionKey","Erreur interne. La clé de chiffrement de colonne chiffrée ne peut pas avoir la valeur Null."},
{"R_EmptyEncryptedColumnEncryptionKey","Erreur interne. Une clé de chiffrement de colonne chiffrée vide a été spécifiée."},
{"R_InvalidMasterKeyDetails","Les détails de la clé principale spécifiés ne sont pas valides."},
{"R_CertificateError","Une erreur s''est produite lors de la récupération du certificat « {0} » dans le magasin de clés « {1} »."},
{"R_ByteToShortConversion","Une erreur s'est produite lors du déchiffrement de la clé de chiffrement de colonne."},
{"R_InvalidCertificateSignature","La signature de clé de chiffrement de colonne chiffrée spécifiée ne correspond pas à la signature calculée avec la clé principale de colonne (certificat) dans « {0} ». Peut-être que la clé de chiffrement de colonne chiffrée est endommagée ou que le chemin spécifié est incorrect."},
{"R_CEKDecryptionFailed","Exception pendant le déchiffrement de la clé de chiffrement de colonne chiffrée : {0} "},
{"R_CryptoCacheInaccessible","{0} erreur lors de la tentative d’exécution d’opérations de cache de chiffrement de session : {1} "},
{"R_NullKeyEncryptionAlgorithm","L'algorithme de chiffrement de clé ne peut pas avoir la valeur Null."},
{"R_NullKeyEncryptionAlgorithmInternal","Erreur interne. L'algorithme de chiffrement de clé ne peut avoir la valeur Null."},
{"R_InvalidKeyEncryptionAlgorithm","Algorithme de chiffrement de clé non valide spécifié : {0}. Valeur attendue : {1}."},
{"R_InvalidKeyEncryptionAlgorithmInternal","Erreur interne. L''algorithme de chiffrement de clé spécifié ({0}) n''est pas valide. Valeur attendue : {1}."},
{"R_NullColumnEncryptionKey","La clé de chiffrement de colonne ne peut pas avoir la valeur Null."},
{"R_EmptyColumnEncryptionKey","Une clé de chiffrement de colonne vide a été spécifiée."},
{"R_CertificateNotFoundForAlias","Le certificat avec l''alias {0} est introuvable dans le magasin fourni par {1}. Vérifiez que le certificat a été importé correctement dans le magasin de certificats ou l''emplacement de certificat."},
{"R_UnrecoverableKeyAE","Impossible de récupérer la clé privée du magasin de clés avec les détails de certificat {0}. Vérifiez que le certificat importé pour Always Encrypted contient une clé privée et que le mot de passe fourni pour le certificat est correct."},
{"R_KeyStoreNotFound","Le système ne peut pas trouver le fichier de magasin de clés dans le chemin spécifié. Vérifiez que le chemin est correct et que vous disposez des autorisations appropriées pour y accéder."},
{"R_CustomKeyStoreProviderMapNull","Le mappage du fournisseur de magasins de clés de chiffrement de colonne ne peut pas avoir la valeur Null. Valeur non-Null attendue."},
{"R_EmptyCustomKeyStoreProviderName","Le nom du fournisseur de magasins de clés spécifié n'est pas valide. Le nom du fournisseur de magasins de clés ne peut pas être vide ou avoir la valeur Null."},
{"R_InvalidCustomKeyStoreProviderName","Le nom du fournisseur de magasins de clés {0} n''est pas valide. Le préfixe {1} est réservé aux fournisseurs de magasins de clés système."},
{"R_CustomKeyStoreProviderValueNull","Référence Null spécifiée pour le fournisseur de magasins de clés {0}. Valeur non-Null attendue."},
{"R_CustomKeyStoreProviderSetOnce","Impossible de définir plusieurs fois les fournisseurs de magasins de clés."},
{"R_unknownColumnEncryptionType","Type de chiffrement de colonne non valide : {0}."},
{"R_unsupportedStmtColEncSetting","SQLServerStatementColumnEncryptionSetting ne peut pas avoir la valeur Null."},
{"R_unsupportedConversionAE","La conversion de {0} en {1} n''est pas prise en charge pour la colonne chiffrée."},
{"R_InvalidDataForAE","Impossible de convertir la valeur de type {0} fournie pour la source de données en type {1} de la colonne cible spécifiée {2}."},
{"R_authenticationPropertyDescription","Authentification à utiliser."},
{"R_accessTokenPropertyDescription","Jeton d'accès à utiliser pour Azure Active Directory."},
{"R_FedAuthRequiredPreLoginResponseInvalidValue","Le serveur a envoyé une valeur inattendue pour l''option FedAuthRequired PreLogin. La valeur était {0}."},
{"R_FedAuthInfoLengthTooShortForCountOfInfoIds","Le jeton FedAuthInfo doit contenir au moins 4 octets indiquant le nombre d'ID d'informations."},
{"R_FedAuthInfoInvalidOffset","FedAuthInfoDataOffset pointe vers un emplacement non valide. Le dataOffset actuel est {0}."},
{"R_FedAuthInfoFailedToReadData","Échec de la lecture de FedAuthInfoData."},
{"R_FedAuthInfoLengthTooShortForData","Le flux de jetons FEDAUTHINFO n''est pas assez long ({0}) pour contenir les données prétendues."},
{"R_FedAuthInfoDoesNotContainStsurlAndSpn","Ni STSURL ni SPN ne figurent dans le flux de jetons FEDAUTHINFO."},
{"R_MSALExecution","Échec de l''authentification de l''utilisateur {0} dans Active Directory (Authentication={1})."},
{"R_MSALAuthComplete","Authentification effectuée. Vous pouvez fermer le navigateur et revenir à l'application."},
{"R_UnrequestedFeatureAckReceived","Accusé de réception de fonctionnalité non sollicité reçu. ID de fonctionnalité : {0}."},
{"R_FedAuthFeatureAckContainsExtraData","L'accusé de réception d'extension de la fonctionnalité d'authentification fédérée pour ADAL et Security Token contient des données supplémentaires."},
{"R_FedAuthFeatureAckUnknownLibraryType","Tentative d''utilisation d''une bibliothèque d''authentification fédérée inconnue. ID de bibliothèque : {0}."},
{"R_UnknownFeatureAck","Accusé de réception de fonctionnalité inconnu reçu."},
{"R_SetAuthenticationWhenIntegratedSecurityTrue","Impossible de définir « Authentication » si « IntegratedSecurity » a la valeur « true »."},
{"R_NtlmNoUserPasswordDomain","Les propriétés de connexion « User » (ou « UserName ») et « Password » doivent être spécifiées pour l'authentification NTLM."},
{"R_SetAccesstokenWhenIntegratedSecurityTrue","Impossible de définir la propriété AccessToken si le mot clé de chaîne de connexion « IntegratedSecurity » a la valeur « true »."},
{"R_IntegratedAuthenticationWithUserPassword","Impossible d'utiliser « Authentication=ActiveDirectoryIntegrated » avec le mot clé de chaîne de connexion « User », « UserName » ou « Password »."},
{"R_ManagedIdentityAuthenticationWithPassword","Impossible d’utiliser « Authentication={0} » avec le mot clé de chaîne de connexion « Password »."},
{"R_AccessTokenWithUserPassword","Impossible de définir la propriété AccessToken si « User », « UserName » ou « Password » a été spécifié dans la chaîne de connexion."},
{"R_AccessTokenCallbackWithUserPassword","Impossible de définir le rappel du jeton d’accès si « User », « UserName » ou « Password » a été défini."},
{"R_AccessTokenCannotBeEmpty","AccesToken ne peut pas être vide."},
{"R_SetBothAuthenticationAndAccessToken","Impossible de définir la propriété AccessToken si « Authentication » a été spécifié dans la chaîne de connexion."},
{"R_NoUserPasswordForActivePassword","Si « Authentication=ActiveDirectoryPassword », les mots clés de chaîne de connexion « User » (ou « UserName ») et « Password » doivent être spécifiés."},
{"R_NoUserPasswordForActiveServicePrincipal","Les mots clés de chaîne de connexion « UserName » et « Password » doivent être spécifiés, si « Authentication=ActiveDirectoryServicePrincipal »."},
{"R_NoUserPasswordForSqlPassword","Si « Authentication=SqlPassword », les mots clés de chaîne de connexion « User » (ou « UserName ») et « Password » doivent être spécifiés."},
{"R_BothUserPasswordandDeprecated","Les mots clés de chaîne de connexion « User » (ou « UserName ») « Password » et « AADSecurePrincipalId », « AADSecurePrincipalSecret » sont spécifiés. Utilisez uniquement « User » (ou « UserName ») ou « Password »."},
{"R_ForceEncryptionTrue_HonorAEFalse","Impossible d''affecter la valeur true à l''option Forcer le chiffrement pour le paramètre {0} car le chiffrement n''est pas activé pour l''instruction ou la procédure {1}."},
{"R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumn","Impossible d''exécuter l''instruction ou la procédure {0} car l''option Forcer le chiffrement a la valeur true pour le paramètre {1} alors que la base de données s''attend à ce que ce paramètre soit envoyé sous forme de texte en clair. Une erreur de configuration est peut-être la cause du problème."},
{"R_ForceEncryptionTrue_HonorAEFalseRS","Impossible d''affecter la valeur true à l''option Forcer le chiffrement pour le paramètre {0} car le chiffrement n''est pas activé pour l''instruction ou la procédure."},
{"R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumnRS","Impossible d''exécuter la mise à jour car l''option Forcer le chiffrement a la valeur true pour le paramètre {0} alors que la base de données s''attend à ce que ce paramètre soit envoyé sous forme de texte en clair. Une erreur de configuration est peut-être la cause du problème."},
{"R_NullValue","{0} ne peut pas avoir la valeur Null."},
{"R_AKVPathNull","Le chemin de la clé Azure Key Vault ne peut pas avoir la valeur Null."},
{"R_AKVURLInvalid","URL non valide spécifiée : {0}."},
{"R_AKVMasterKeyPathInvalid","Chemin de clé Azure Key Vault non valide spécifié : {0}."},
{"R_ManagedIdentityInitFail","L'initialisation du package pour obtenir le jeton d'identité managée pour Azure Key Vault a échoué."},
{"R_EmptyCEK","Une clé de chiffrement de colonne vide a été spécifiée."},
{"R_EncryptedCEKNull","Une clé de chiffrement de colonne chiffrée ne peut pas avoir la valeur Null."},
{"R_EmptyEncryptedCEK","La longueur d'une clé de chiffrement de colonne chiffrée ne doit pas être égale à zéro."},
{"R_NonRSAKey","Impossible d''utiliser une clé non-RSA : {0}."},
{"R_GetAKVKeySize","Impossible d'obtenir la taille de la clé publique Azure Key Vault en octets."},
{"R_InvalidEcryptionAlgorithmVersion","La clé de chiffrement de colonne chiffrée spécifiée contient une version d''algorithme de chiffrement non valide ({0}). La version attendue est {1}."},
{"R_AKVKeyLengthError","La longueur ciphertext spécifiée ({0}) pour la clé de chiffrement de colonne chiffrée ne correspond pas à la longueur de texte chiffré ({1}) quand la clé principale de colonne (clé Azure Key Vault) est utilisée dans {2}. Peut-être que la clé de chiffrement de colonne chiffrée est endommagée ou que le chemin de clé Azure Key Vault spécifié est incorrect."},
{"R_AKVSignatureLengthError","La longueur de signature spécifiée ({0}) pour la clé de chiffrement de colonne chiffrée ne correspond pas à la longueur de signature ({1}) quand la clé principale de colonne (clé Azure Key Vault) est utilisée dans {2}. Peut-être que la clé de chiffrement de colonne chiffrée est endommagée ou que le chemin de clé Azure Key Vault spécifié est incorrect."},
{"R_HashNull","Le code de hachage ne doit pas avoir la valeur Null lors du déchiffrement de la clé de chiffrement de colonne chiffrée."},
{"R_NoSHA256Algorithm","L'algorithme SHA-256 n'est pas pris en charge."},
{"R_VerifySignature","Impossible de vérifier la signature de la clé de chiffrement de colonne."},
{"R_CEKSignatureNotMatchCMK","La signature de clé de chiffrement de colonne chiffrée spécifiée ne correspond pas à la signature calculée avec la clé principale de colonne (clé asymétrique dans Azure Key Vault) dans {0}. Peut-être que la clé de chiffrement de colonne chiffrée est endommagée ou que le chemin spécifié est incorrect."},
{"R_DecryptCEKError","Impossible de déchiffrer la clé de chiffrement de colonne avec la clé Azure Key Vault spécifiée."},
{"R_EncryptCEKError","Impossible de chiffrer la clé de chiffrement de colonne avec la clé Azure Key Vault spécifiée."},
{"R_CipherTextLengthNotMatchRSASize","La longueur de CipherText ne correspond pas à la taille de la clé RSA."},
{"R_GenerateSignature","Impossible de générer la signature avec l'URL de la clé Azure Key Vault spécifiée."},
{"R_SignedHashLengthError","La longueur du code de hachage signé ne correspond pas à la taille de la clé RSA."},
{"R_InvalidSignatureComputed","Une signature non valide de la clé de chiffrement de colonne chiffrée a été calculée."},
{"R_UnableLoadADALSqlDll","Impossible de charger adalsql.dll. Code d''erreur : 0x{0}. Pour plus d''informations, consultez : http://go.microsoft.com/fwlink/?LinkID=513072"},
{"R_ADALAuthenticationMiddleErrorMessage","Code d''erreur 0x{0} ; état {1}."},
{"R_unsupportedDataTypeTVP","Le type de données {0} n''est pas pris en charge dans Table-Valued Parameter."},
{"R_moreDataInRowThanColumnInTVP","Le tableau d'entrée est plus long que le nombre de colonnes de cette table."},
{"R_invalidTVPName"," Table-Valued Parameter doit avoir un nom de type valide."},
{"R_invalidThreePartName","Format de nom en 3 parties de TypeName non valide."},
{"R_unsupportedConversionTVP","La conversion de {0} en {1} n''est pas prise en charge pour Table-Valued Parameter."},
{"R_TVPMixedSource","Impossible d'ajouter des métadonnées de colonne. Ce Table-Valued Parameter a un ResultSet à partir duquel les métadonnées sont dérivées."},
{"R_TVPEmptyMetadata","Le type Structured ne comprend pas suffisamment de champs. Les types Structured doivent avoir au moins un champ."},
{"R_TVPInvalidValue","La valeur fournie pour Table-Valued Parameter {0} n''est pas valide. Seuls les objets SQLServerDataTable, ResultSet et ISQLServerDataRecord sont pris en charge."},
{"R_TVPInvalidColumnValue","Le format des données d'entrée est incorrect."},
{"R_TVPSortOrdinalGreaterThanFieldCount","L''ordinal de tri {0} sur le champ {1} dépasse le nombre total de champs."},
{"R_TVPMissingSortOrderOrOrdinal","L''ordre de tri et l''ordinal doivent être tous les deux spécifiés ou aucun ne doit l''être (SortOrder.Unspecified et -1). Les valeurs données étaient : ordre = {0}, ordinal = {1}."},
{"R_TVPDuplicateSortOrdinal","L''ordinal de tri {0} a été spécifié deux fois."},
{"R_TVPMissingSortOrdinal","L''ordinal de tri {0} n''a pas été spécifié."},
{"R_TVPDuplicateColumnName","Une colonne nommée {0} appartient déjà à ce SQLServerDataTable."},
{"R_InvalidConnectionSetting","Le valeur de {0} (« {1} ») n''est pas valide."},
{"R_InvalidWindowsCertificateStoreEncryption","Impossible de chiffrer une clé de chiffrement de colonne avec le Windows Certificate Store."},
{"R_AEKeypathEmpty","Erreur interne. Le chemin de certificat ne peut pas avoir la valeur Null. Utilisez le format suivant : « emplacement de certificat/magasin de certificats/empreinte numérique de certificat », où « emplacement de certificat » a la valeur LocalMachine ou CurrentUser."},
{"R_AEWinApiErr","Erreur native de l'API Windows."},
{"R_AECertpathBad","Erreur interne. Le chemin de certificat {0} n''est pas valide. Utilisez le format suivant : « emplacement de certificat/magasin de certificats/empreinte numérique de certificat », où « emplacement de certificat » a la valeur LocalMachine ou CurrentUser."},
{"R_AECertLocBad","Erreur interne. L''emplacement de certificat {0} dans le chemin de certificat {1} n''est pas valide. Utilisez le format suivant : « emplacement de certificat/magasin de certificats/empreinte numérique de certificat », où « emplacement de certificat » a la valeur LocalMachine ou CurrentUser."},
{"R_AECertStoreBad","Erreur interne. Le magasin de certificats {0} spécifié dans le chemin de certificat {1} n''est pas valide. Valeur attendue : My."},
{"R_AECertHashEmpty","Erreur interne. Une empreinte numérique de certificat vide a été spécifiée dans le chemin de certificat {0}."},
{"R_AECertNotFound","Le certificat avec l''empreinte numérique {2} est introuvable dans l''emplacement de certificat {0} du magasin de certificats {1}. Vérifiez l''exactitude du chemin du certificat dans la définition de clé principale de colonne de la base de données. Vérifiez aussi que le certificat a été correctement importé dans le magasin de certificats ou l''emplacement de certificat."},
{"R_AEMaloc","Échec d'allocation de mémoire."},
{"R_AEKeypathLong","Erreur interne. Le chemin de certificat spécifié fait {0} octets, ce qui dépasse la longueur maximale de {1} octets."},
{"R_AEECEKLenBad","La longueur de ciphertext spécifiée ({0}) pour la clé de chiffrement de colonne chiffrée ne correspond pas à la longueur de ciphertext ({1}) quand la clé principale de colonne (certificat) est utilisée dans « {2} ». Peut-être que la clé de chiffrement de colonne chiffrée est endommagée ou que le chemin de certificat spécifié est incorrect."},
{"R_AEECEKSigLenBad","La longueur de signature spécifiée ({0}) pour la clé de chiffrement de colonne chiffrée ne correspond pas à la longueur ({1}) quand la clé principale de colonne (certificat) est utilisée dans « {2} ». Peut-être que la clé de chiffrement de colonne chiffrée est endommagée ou que le chemin de certificat spécifié est incorrect."},
{"R_AEKeyPathEmptyOrReserved","Le chemin de certificat « {0} » n''est pas valide. Il est vide ou contient des noms de répertoire réservés."},
{"R_AEKeyPathCurUser","CurrentUser a été spécifié dans le chemin de la clé, mais une erreur s'est produite lors de l'obtention du répertoire de travail initial de l'utilisateur actuel."},
{"R_AEKeyFileOpenError","Erreur lors de l''ouverture du fichier de certificat {0}."},
{"R_AEKeyFileReadError","Erreur lors de la lecture du fichier de certificat {0}."},
{"R_keyStoreAuthenticationPropertyDescription","Nom qui identifie un magasin de clés."},
{"R_keyStoreSecretPropertyDescription","Informations ou secret d'authentification nécessaires pour localiser le secret."},
{"R_keyStoreLocationPropertyDescription","Emplacement du magasin de clés."},
{"R_keyStoreAuthenticationNotSet","Le mot clé de chaîne de connexion « keyStoreAuthentication » doit être spécifié si « {0} » est spécifié."},
{"R_keyStoreSecretOrLocationNotSet","« keyStoreSecret » et « keyStoreLocation » doivent être tous les deux définis si « keyStoreAuthentication=JavaKeyStorePassword » est spécifié dans la chaîne de connexion."},
{"R_keyStoreSecretNotSet","Si « keyStoreAuthentication=KeyVaultClientSecret » a été spécifié dans la chaîne de connexion, « keyStoreSecret » doit être défini."},
{"R_keyVaultProviderClientKeyNotSet","« keyVaultProviderClientKey » doit être défini si « keyVaultProviderClientId » a été spécifié dans la chaîne de connexion."},
{"R_keyVaultProviderNotSupportedWithKeyStoreAuthentication","« keyStoreAuthentication » ne peut pas être utilisé avec « keyVaultProviderClientId » ou « keyVaultProviderClientKey » dans la chaîne de connexion."},
{"R_certificateStoreInvalidKeyword","Impossible de définir « keyStoreSecret » si « keyStoreAuthentication=CertificateStore » est spécifié dans la chaîne de connexion."},
{"R_certificateStoreLocationNotSet","« keyStoreLocation » doit être spécifié si « keyStoreAuthentication=CertificateStore » est spécifié dans la chaîne de connexion."},
{"R_certificateStorePlatformInvalid","Impossible de définir « keyStoreAuthentication=CertificateStore » sur un système d'exploitation Windows."},
{"R_invalidKeyStoreFile","Impossible d''analyser « {0} ». Le format du fichier n''est pas valide ou le mot de passe est incorrect."},
{"R_invalidCEKCacheTtl","La durée de vie du cache de clé de chiffrement de colonne spécifiée n'est pas valide. La valeur columnEncryptionKeyCacheTtl ne peut pas être négative et timeUnit peut uniquement être DAYS, HOURS, MINUTES ou SECONDS."},
{"R_sendTimeAsDateTimeForAE","Utilisez sendTimeAsDateTime=false avec Always Encrypted."},
{"R_TVPnotWorkWithSetObjectResultSet","setObject() avec ResultSet n'est pas pris en charge pour le paramètre table. Utilisez setStructured()."},
{"R_invalidQueryTimeout","Le délai d''expiration de la requête {0} n''est pas valide."},
{"R_invalidSocketTimeout","Le délai d''expiration du socket {0} n''est pas valide."},
{"R_fipsPropertyDescription","Détermine si le mode FIPS est activé."},
{"R_invalidFipsConfig","Impossible de vérifier les paramètres du mode FIPS."},
{"R_serverPreparedStatementDiscardThreshold","Le serverPreparedStatementDiscardThreshold {0} n''est pas valide."},
{"R_statementPoolingCacheSize","La taille du cache du regroupement d''instructions {0} n''est pas valide."},
{"R_kerberosLoginFailedForUsername","Connexion impossible avec le principal Kerberos {0}, vérifiez vos informations d''identification. {1}"},
{"R_kerberosLoginFailed","La connexion Kerberos a échoué : {0} en raison de {1} ({2})"},
{"R_StoredProcedureNotFound","La procédure stockée « {0} » est introuvable."},
{"R_jaasConfigurationNamePropertyDescription","Fichier de configuration de connexion pour l'authentification Kerberos."},
{"R_AKVKeyNotFound","Clé introuvable : {0}"},
{"R_SQLVariantSupport","SQL_VARIANT n'est pas pris en charge dans les versions de SQL Server antérieures à 2008."},
{"R_invalidProbbytes","SQL_VARIANT : probBytes non valides pour le type {0}."},
{"R_invalidStringValue","SQL_VARIANT ne prend pas en charge des valeurs de chaîne dont la longueur est supérieure à 8000."},
{"R_invalidValueForTVPWithSQLVariant","L'utilisation de paramètres table contenant des colonnes sql_variant null n'est pas prise en charge."},
{"R_invalidDataTypeSupportForSQLVariant","Type TDS inattendu « ''{0}'' » dans SQL_VARIANT."},
{"R_sslProtocolPropertyDescription","Étiquette de protocole SSL avec la valeur TLS, TLSv1, TLSv1.1 ou TLSv1.2. La valeur par défaut est TLS."},
{"R_invalidSSLProtocol","L''étiquette de protocole SSL {0} n''est pas valide. Seules les valeurs TLS, TLSv1, TLSv1.1 et TLSv1.2 sont prises en charge."},
{"R_cancelQueryTimeoutPropertyDescription","Nombre de secondes d’attente pour annuler l’envoi d’un délai d'expiration de requête."},
{"R_invalidCancelQueryTimeout","La valeur d''expiration de l''annulation {0} n''est pas valide."},
{"R_useBulkCopyForBatchInsertPropertyDescription","Indique si le pilote utilisera les API de copie en bloc pour les opérations d'insertion par lot"},
{"R_UnknownDataClsTokenNumber","Jeton inconnu pour la classification des données."},
{"R_InvalidDataClsVersionNumber","Numéro de version non valide {0} pour la classification des données."},
{"R_unknownUTF8SupportValue","Valeur inconnue pour la prise en charge UTF8."},
{"R_unknownAzureSQLDNSCachingValue","Valeur inconnue pour la mise en cache DNS d'Azure SQL."},
{"R_illegalWKT","Texte WKT (Well-Known text) non conforme. Vérifiez que le texte WKT est valide."},
{"R_illegalTypeForGeometry","{0} n''est pas pris en charge pour Geometry."},
{"R_illegalWKTposition","Caractère non conforme dans du texte WKT (Well-Known text) à l''emplacement {0}."},
{"R_keyVaultProviderClientIdPropertyDescription","ID client utilisé pour accéder au coffre de clés Key Vault où est stockée la clé principale de chiffrement de colonne."},
{"R_keyVaultProviderClientKeyPropertyDescription","Clé client utilisée pour accéder au coffre de clés Key Vault où est stockée la clé principale de chiffrement de colonne."},
{"R_keyStorePrincipalIdPropertyDescription","ID de principal d'Azure Active Directory."},
{"R_MSALMissing","Le chargement de la bibliothèque Java MSAL4J pour effectuer l''authentification {0} a échoué."},
{"R_DLLandMSALMissing","Le chargement de {0} et de la bibliothèque Java MSAL4J pour effectuer l''authentification {1} a échoué. Installez l''un de ces éléments pour continuer."},
{"R_MSITokenFailureEndpoint","Échec du jeton MSI : Impossible d'obtenir le jeton auprès du point de terminaison MSI"},
{"R_propertyNotSupported","Actuellement, Microsoft JDBC Driver pour SQL Server ne prend pas en charge la propriété : {0}"},
{"R_ntlmHmacMD5Error","Impossible d'initialiser l'authentification NTLM : erreur d'initialisation HMAC-MD5."},
{"R_ntlmSignatureError","Erreur de signature du message de stimulation NTLM : {0}"},
{"R_ntlmMessageTypeError","Erreur de type du message de stimulation NTLM : {0}"},
{"R_ntlmAuthenticateError","Erreur NTLM pendant la construction du message d''authentification : {0}"},
{"R_ntlmNoTargetInfo","Le message de stimulation NTLM ne contient pas TargetInfo."},
{"R_ntlmUnknownValue","Erreur de TargetInfo dans le message de stimulation NTLM : valeur inconnue « {0} »"},
{"R_useFmtOnlyPropertyDescription","Détermine s'il faut activer/désactiver l'utilisation de SET FMTONLY pour récupérer les métadonnées de paramètre."},
{"R_invalidOpenqueryCall","Syntaxe non valide : OPENQUERY/OPENJSON/OPENDATASOURCE/OPENROWSET/OPENXML doit être précédé de parenthèses"},
{"R_invalidCTEFormat","Syntaxe non valide : AS doit être suivi de parenthèses dans les expressions de table communes."},
{"R_noTokensFoundInUserQuery","Requête non valide : aucun jeton analysé à partir du SQL fourni."},
{"R_invalidUserSQL","Une erreur s'est produite pendant la tentative d'analyse de l'utilisateur SQL. Vérifiez la syntaxe SQL."},
{"R_invalidInsertValuesQuery","Une erreur s'est produite pendant la correspondance de la liste VALUES avec les colonnes de la table. Vérifiez la syntaxe SQL."},
{"R_invalidValuesList","Une erreur s'est produite pendant la lecture de la liste VALUES. Vérifiez la syntaxe SQL."},
{"R_enclaveNotSupported","L’SQL Server ne prend pas en charge les calculs basés sur des enclaves : consultez https://go.microsoft.com/fwlink/?linkid=2157649 pour plus de détails."},
{"R_enclavePropertiesError","La propriété de connexion « columnEncryptionSetting » doit être activée, ainsi que les propriétés de connexion « enclaveAttestationUrl » et « enclaveAttestationProtocol » valides lors de l'activation de la fonctionnalité Always Encrypted avec des enclaves sécurisées : consultez https://go.microsoft.com/fwlink/?linkid=2157649 pour plus de détails."},
{"R_enclaveInvalidAttestationProtocol","« EnclaveAttestationProtocol » n’est pas valide : consultez https://go.microsoft.com/fwlink/?linkid=2157649 pour plus de détails."},
{"R_enclaveTypeInvalid","Le type d’enclave {0} n’est pas valide ou n’est pas pris en charge par le pilote : consultez https://go.microsoft.com/fwlink/?linkid=2157649 pour plus de détails."},
{"R_attestationUrlInvalid","Impossible d’attester l’enclave spécifiée par {0} : consultez https://go.microsoft.com/fwlink/?linkid=2157649 pour plus de détails."},
{"R_EnclaveResponseLengthError","Plus d’octets du serveur ont été reçus que prévu lors de l’analyse de la réponse d’attestation d’enclave : consultez https://go.microsoft.com/fwlink/?linkid=2157649 pour plus de détails."},
{"R_EnclavePackageLengthError","Plus d’octets du serveur ont été reçus que prévu lors de l’analyse de le package d’enclave : consultez https://go.microsoft.com/fwlink/?linkid=2157649 pour plus de détails."},
{"R_EnclavePKLengthError","Plus d’octets du serveur ont été reçus que prévu lors de l’analyse de la clé publique d’enclave : consultez https://go.microsoft.com/fwlink/?linkid=2157649 pour plus de détails."},
{"R_MalformedECDHPublicKey","La clé publique ECDH du serveur doit être avoir une longueur de 104 bits."},
{"R_MalformedECDHHeader","Valeurs inattendues pour l'en-tête de clé publique ECDH du serveur."},
{"R_HealthCertError","L''attestation d''enclave a échoué. Impossible de récupérer les certificats de rapport d''intégrité fournis dans l''enclave : {0} - consultez https://go.microsoft.com/fwlink/?linkid=2160553 pour plus de détails."},
{"R_InvalidHealthCert","Échec de l’attestation d’enclave, le certificat de rapport d’intégrité fourni dans l’enclave n’a pas été signé par le SGH : consultez https://go.microsoft.com/fwlink/?linkid=2160553 pour plus de détails."},
{"R_InvalidSignedStatement","Échec de l’attestation d’enclave, les octets de l’instruction n’ont pas été signés par le certificat d’intégrité . consultez https://go.microsoft.com/fwlink/?linkid=2160553 pour plus de détails."},
{"R_InvalidDHKeySignature","L'attestation d'enclave a échoué. Impossible de vérifier signature de clé publique DH avec la clé publique d'enclave : consultez https://go.microsoft.com/fwlink/?linkid=2157649 pour plus de détails."},
{"R_AasJWTError","Une erreur s'est produite durant la récupération et la validation du jeton web JSON."},
{"R_AasEhdError","La revendication aas-ehd de JWT ne correspond pas à la clé publique d'enclave."},
{"R_VbsRpDataError","La revendication rp_data de JWT ne correspond pas à la valeur nonce du client."},
{"R_pvkParseError","Impossible de lire la clé privée dans le fichier PVK, vérifiez le mot de passe fourni."},
{"R_pvkHeaderError","Impossible d'analyser le fichier PVK, car il ne contient pas l'en-tête approprié."},
{"R_clientCertError","La lecture du certificat client a échoué. Vérifiez l'emplacement du certificat."},
{"R_unassignableError","La classe spécifiée par la propriété {0} doit pouvoir être attribuée à {1}."},
{"R_InvalidCSVQuotes","L'analyse du fichier CSV a échoué, vérifiez que les champs sont correctement placés entre guillemets doubles."},
{"R_TokenRequireUrl","Les informations d'identification de jeton nécessitent une URL utilisant le schéma de protocole HTTPS."},
{"R_maxResultBufferPropertyDescription","Détermine le nombre maximal d'octets pouvant être lus pendant la récupération du jeu de résultats"},
{"R_maxResultBufferInvalidSyntax","Syntaxe non valide : {0} dans le paramètre maxResultBuffer."},
{"R_maxResultBufferNegativeParameterValue","MaxResultBuffer doit avoir une valeur positive : {0}."},
{"R_maxResultBufferPropertyExceeded","Propriété MaxResultBuffer dépassée : {0}. MaxResultBuffer a été défini sur : {1}."},
{"R_invalidConnectRetryCount","Le nombre de tentatives de connexion {0} n’est pas valide."},
{"R_connectRetryCountPropertyDescription","Nombre maximal de tentatives de rétablissement d’une connexion interrompue."},
{"R_invalidConnectRetryInterval","L’intervalle de nouvelle tentative de connexion {0} n’est pas valide."},
{"R_connectRetryIntervalPropertyDescription","Intervalle, en secondes, entre les tentatives de rétablissement d’une connexion."},
{"R_crClientAllRecoveryAttemptsFailed","La connexion est interrompue et la récupération est impossible. Le pilote client a tenté de récupérer la connexion une ou plusieurs fois et toutes les tentatives ont échoué. Augmentez la valeur de ConnectRetryCount pour augmenter le nombre de tentatives de récupération."},
{"R_crClientNoRecoveryAckFromLogin","Le serveur n'a pas accepté une tentative de récupération. La récupération de la connexion est impossible."},
{"R_crServerSessionStateNotRecoverable","La connexion est interrompue et la récupération est impossible. La connexion est marquée par le serveur comme non récupérable. Aucune tentative de restaurer la connexion n'a été faite."},
{"R_crClientUnrecoverable","La connexion est interrompue et la récupération est impossible. La connexion est marquée par le pilote client comme non récupérable. Aucune tentative de restaurer la connexion n'a été faite."},
{"R_crClientSSLStateNotRecoverable","Le serveur n'a pas conservé le chiffrement SSL pendant une tentative de récupération. La récupération de la connexion est impossible."},
{"R_crCommandCannotTimeOut","La demande n’a pas pu expirer et SQLServerConnection n’existe pas"},
{"R_InvalidIPAddressPreference","La préférence d’adresse IP {0} n’est pas valide."},
{"R_UnableLoadAuthDll","Impossible de charger la DLL {0} d’authentification"},
{"R_illegalArgumentTrustManager","Erreur interne. La chaîne de certificats d’homologue ou l’algorithme de l’échange de clés ne peuvent pas être null ou vides."},
{"R_serverCertError","Erreur lors de la validation du certificat de serveur : {0} : {1}."},
{"R_SecureStringInitFailed","Échec de l’initialisation de SecureStringUtil pour stocker les chaînes sécurisées"},
{"R_ALPNFailed","Échec de la négociation du {0} de protocole Application-Layer. Serveur retourné : {1}."},
{"R_serverError","Une erreur s’est produite lors de la commande actuelle (État terminé {0}). {1}"},
{"R_ManagedIdentityTokenAcquisitionFail","Échec de l’acquisition du jeton d’identité managée. La demande du jeton a réussi, mais aucun jeton n’a été retourné. Le jeton est nul."},
{"R_InvalidSqlQuery","Requête SQL non valide : {0}"},
};
}
