/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IWorkbookTableRowCollectionPage;
import com.microsoft.graph.extensions.IWorkbookTableRowCollectionRequest;
import com.microsoft.graph.extensions.WorkbookTableRow;
import com.microsoft.graph.extensions.WorkbookTableRowCollectionPage;
import com.microsoft.graph.extensions.WorkbookTableRowCollectionRequest;
import com.microsoft.graph.extensions.WorkbookTableRowCollectionRequestBuilder;
import com.microsoft.graph.extensions.WorkbookTableRowRequestBuilder;
import com.microsoft.graph.generated.BaseWorkbookTableRowCollectionResponse;
import com.microsoft.graph.generated.IBaseWorkbookTableRowCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseWorkbookTableRowCollectionRequest
extends BaseCollectionRequest<BaseWorkbookTableRowCollectionResponse, IWorkbookTableRowCollectionPage>
implements IBaseWorkbookTableRowCollectionRequest {
    public BaseWorkbookTableRowCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseWorkbookTableRowCollectionResponse.class, IWorkbookTableRowCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookTableRowCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseWorkbookTableRowCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookTableRowCollectionPage get() throws ClientException {
        BaseWorkbookTableRowCollectionResponse response = (BaseWorkbookTableRowCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookTableRow newWorkbookTableRow, ICallback<WorkbookTableRow> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookTableRowRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookTableRow, callback);
    }

    @Override
    public WorkbookTableRow post(WorkbookTableRow newWorkbookTableRow) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookTableRowRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookTableRow);
    }

    @Override
    public IWorkbookTableRowCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (WorkbookTableRowCollectionRequest)this;
    }

    @Override
    public IWorkbookTableRowCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (WorkbookTableRowCollectionRequest)this;
    }

    @Override
    public IWorkbookTableRowCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (WorkbookTableRowCollectionRequest)this;
    }

    public IWorkbookTableRowCollectionPage buildFromResponse(BaseWorkbookTableRowCollectionResponse response) {
        WorkbookTableRowCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookTableRowCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookTableRowCollectionPage page = new WorkbookTableRowCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

