/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IWorkbookTableColumnCollectionPage;
import com.microsoft.graph.extensions.IWorkbookTableColumnCollectionRequest;
import com.microsoft.graph.extensions.WorkbookTableColumn;
import com.microsoft.graph.extensions.WorkbookTableColumnCollectionPage;
import com.microsoft.graph.extensions.WorkbookTableColumnCollectionRequest;
import com.microsoft.graph.extensions.WorkbookTableColumnCollectionRequestBuilder;
import com.microsoft.graph.extensions.WorkbookTableColumnRequestBuilder;
import com.microsoft.graph.generated.BaseWorkbookTableColumnCollectionResponse;
import com.microsoft.graph.generated.IBaseWorkbookTableColumnCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseWorkbookTableColumnCollectionRequest
extends BaseCollectionRequest<BaseWorkbookTableColumnCollectionResponse, IWorkbookTableColumnCollectionPage>
implements IBaseWorkbookTableColumnCollectionRequest {
    public BaseWorkbookTableColumnCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseWorkbookTableColumnCollectionResponse.class, IWorkbookTableColumnCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookTableColumnCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseWorkbookTableColumnCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookTableColumnCollectionPage get() throws ClientException {
        BaseWorkbookTableColumnCollectionResponse response = (BaseWorkbookTableColumnCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookTableColumn newWorkbookTableColumn, ICallback<WorkbookTableColumn> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookTableColumnRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookTableColumn, callback);
    }

    @Override
    public WorkbookTableColumn post(WorkbookTableColumn newWorkbookTableColumn) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookTableColumnRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookTableColumn);
    }

    @Override
    public IWorkbookTableColumnCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (WorkbookTableColumnCollectionRequest)this;
    }

    @Override
    public IWorkbookTableColumnCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (WorkbookTableColumnCollectionRequest)this;
    }

    @Override
    public IWorkbookTableColumnCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (WorkbookTableColumnCollectionRequest)this;
    }

    public IWorkbookTableColumnCollectionPage buildFromResponse(BaseWorkbookTableColumnCollectionResponse response) {
        WorkbookTableColumnCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookTableColumnCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookTableColumnCollectionPage page = new WorkbookTableColumnCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

