/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IWorkbookRangeBorderCollectionPage;
import com.microsoft.graph.extensions.IWorkbookRangeBorderCollectionRequest;
import com.microsoft.graph.extensions.WorkbookRangeBorder;
import com.microsoft.graph.extensions.WorkbookRangeBorderCollectionPage;
import com.microsoft.graph.extensions.WorkbookRangeBorderCollectionRequest;
import com.microsoft.graph.extensions.WorkbookRangeBorderCollectionRequestBuilder;
import com.microsoft.graph.extensions.WorkbookRangeBorderRequestBuilder;
import com.microsoft.graph.generated.BaseWorkbookRangeBorderCollectionResponse;
import com.microsoft.graph.generated.IBaseWorkbookRangeBorderCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseWorkbookRangeBorderCollectionRequest
extends BaseCollectionRequest<BaseWorkbookRangeBorderCollectionResponse, IWorkbookRangeBorderCollectionPage>
implements IBaseWorkbookRangeBorderCollectionRequest {
    public BaseWorkbookRangeBorderCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseWorkbookRangeBorderCollectionResponse.class, IWorkbookRangeBorderCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookRangeBorderCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseWorkbookRangeBorderCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookRangeBorderCollectionPage get() throws ClientException {
        BaseWorkbookRangeBorderCollectionResponse response = (BaseWorkbookRangeBorderCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookRangeBorder newWorkbookRangeBorder, ICallback<WorkbookRangeBorder> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookRangeBorderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookRangeBorder, callback);
    }

    @Override
    public WorkbookRangeBorder post(WorkbookRangeBorder newWorkbookRangeBorder) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookRangeBorderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookRangeBorder);
    }

    @Override
    public IWorkbookRangeBorderCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (WorkbookRangeBorderCollectionRequest)this;
    }

    @Override
    public IWorkbookRangeBorderCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (WorkbookRangeBorderCollectionRequest)this;
    }

    @Override
    public IWorkbookRangeBorderCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (WorkbookRangeBorderCollectionRequest)this;
    }

    public IWorkbookRangeBorderCollectionPage buildFromResponse(BaseWorkbookRangeBorderCollectionResponse response) {
        WorkbookRangeBorderCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookRangeBorderCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookRangeBorderCollectionPage page = new WorkbookRangeBorderCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

