/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.ISectionGroupCollectionPage;
import com.microsoft.graph.extensions.ISectionGroupCollectionRequest;
import com.microsoft.graph.extensions.SectionGroup;
import com.microsoft.graph.extensions.SectionGroupCollectionPage;
import com.microsoft.graph.extensions.SectionGroupCollectionRequest;
import com.microsoft.graph.extensions.SectionGroupCollectionRequestBuilder;
import com.microsoft.graph.extensions.SectionGroupRequestBuilder;
import com.microsoft.graph.generated.BaseSectionGroupCollectionResponse;
import com.microsoft.graph.generated.IBaseSectionGroupCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseSectionGroupCollectionRequest
extends BaseCollectionRequest<BaseSectionGroupCollectionResponse, ISectionGroupCollectionPage>
implements IBaseSectionGroupCollectionRequest {
    public BaseSectionGroupCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseSectionGroupCollectionResponse.class, ISectionGroupCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISectionGroupCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseSectionGroupCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISectionGroupCollectionPage get() throws ClientException {
        BaseSectionGroupCollectionResponse response = (BaseSectionGroupCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SectionGroup newSectionGroup, ICallback<SectionGroup> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SectionGroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSectionGroup, callback);
    }

    @Override
    public SectionGroup post(SectionGroup newSectionGroup) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SectionGroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSectionGroup);
    }

    @Override
    public ISectionGroupCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (SectionGroupCollectionRequest)this;
    }

    @Override
    public ISectionGroupCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (SectionGroupCollectionRequest)this;
    }

    @Override
    public ISectionGroupCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (SectionGroupCollectionRequest)this;
    }

    public ISectionGroupCollectionPage buildFromResponse(BaseSectionGroupCollectionResponse response) {
        SectionGroupCollectionRequestBuilder builder = response.nextLink != null ? new SectionGroupCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SectionGroupCollectionPage page = new SectionGroupCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

