/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.ISchemaExtensionCollectionPage;
import com.microsoft.graph.extensions.ISchemaExtensionCollectionRequest;
import com.microsoft.graph.extensions.SchemaExtension;
import com.microsoft.graph.extensions.SchemaExtensionCollectionPage;
import com.microsoft.graph.extensions.SchemaExtensionCollectionRequest;
import com.microsoft.graph.extensions.SchemaExtensionCollectionRequestBuilder;
import com.microsoft.graph.extensions.SchemaExtensionRequestBuilder;
import com.microsoft.graph.generated.BaseSchemaExtensionCollectionResponse;
import com.microsoft.graph.generated.IBaseSchemaExtensionCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseSchemaExtensionCollectionRequest
extends BaseCollectionRequest<BaseSchemaExtensionCollectionResponse, ISchemaExtensionCollectionPage>
implements IBaseSchemaExtensionCollectionRequest {
    public BaseSchemaExtensionCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseSchemaExtensionCollectionResponse.class, ISchemaExtensionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISchemaExtensionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseSchemaExtensionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISchemaExtensionCollectionPage get() throws ClientException {
        BaseSchemaExtensionCollectionResponse response = (BaseSchemaExtensionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SchemaExtension newSchemaExtension, ICallback<SchemaExtension> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SchemaExtensionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSchemaExtension, callback);
    }

    @Override
    public SchemaExtension post(SchemaExtension newSchemaExtension) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SchemaExtensionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSchemaExtension);
    }

    @Override
    public ISchemaExtensionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (SchemaExtensionCollectionRequest)this;
    }

    @Override
    public ISchemaExtensionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (SchemaExtensionCollectionRequest)this;
    }

    @Override
    public ISchemaExtensionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (SchemaExtensionCollectionRequest)this;
    }

    public ISchemaExtensionCollectionPage buildFromResponse(BaseSchemaExtensionCollectionResponse response) {
        SchemaExtensionCollectionRequestBuilder builder = response.nextLink != null ? new SchemaExtensionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SchemaExtensionCollectionPage page = new SchemaExtensionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

